<?php 
$wp_customize->add_section(
    'service_area',
    array(
        'title'         => __( 'Services Section', 'luzuk' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);
$wp_customize->add_setting(
    'service_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'service_area_disable',
        array(
            'settings'      => 'service_area_disable',
            'section'       => 'service_area',
            'label'         => __( 'Disable Section', 'luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk' ),
                'off' => __( 'No', 'luzuk' )
            )   
        )
    )
);

backgroundManager($wp_customize, 'service', 'service_area', $color='#fff', get_template_directory_uri().'/images/default.png', 'img');


lzCustomLable($wp_customize, 'luzuk_sec_servicessectionpadding', 'service_area', 'Section Padding');

$wp_customize->add_setting(
    'service_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaTpadding',
    array(
        'settings'      => 'service_areaTpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'service_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaBpadding',
    array(
        'settings'      => 'service_areaBpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);


$wp_customize->add_setting('service_area_lbl2', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'service_area_lbl2',
        array(
            'settings'      => 'service_area_lbl2',
            'section'       => 'service_area',
            'label'         => __( 'Note 2 :', 'luzuk' ),  
            'description'   => __( 'Use Shortcode [SERVICES] to show all services in a page', 'luzuk' ),
        )
    )
);


$wp_customize->add_setting('service_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'service_npp_heading',
        array(
            'settings'      => 'service_npp_heading',
            'section'       => 'service_area',
            'label'         => __( 'Number Of Services To Show', 'luzuk' ),
        )
    )
);    
$wp_customize->add_setting('service_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control(
    'service_npp_count',
    array(
        'settings'      => 'service_npp_count',
        'section'       => 'service_area',
        'type'          => 'select',
        'label'         => __( 'Number Of Services To Show', 'luzuk' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
    )
);

$ServicesSingleChoice[] = 'Select';

for( $i = 1; $i <= 12; $i++ ){
    $wp_customize->add_setting(
        'services_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'services_heading'.$i,
            array(
                'settings'      => 'services_heading'.$i,
                'section'       => 'service_area',
                'label'         => __( 'Service ', 'luzuk' ).$i,
            )
        )
    );
    if(is_array($ServicesSingleChoice)){
        $wp_customize->add_setting(
            'services_page'.$i,
            array(
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(
            'services_page'.$i,
            array(
                'settings'      => 'services_page'.$i,
                'section'       => 'service_area',
                'type'=> 'select',
                'label'         => __( 'Select A Service Box ', 'luzuk' ),
                'choices' => $ServicesSingleChoice,
            )
        );

// $wp_customize->add_setting(
//         'services_page_icon1'.$i,
//         array(
//             'default'           => 'fa fa-user-o',
//             'sanitize_callback' => 'luzuk_sanitize_text'
//         )
//     );        
//     $wp_customize->add_control(
//         new luzuk_Fontawesome_Icon_Chooser(
//             $wp_customize,
//             'services_page_icon1'.$i,
//             array(
//                 'settings'      => 'services_page_icon1'.$i,
//                 'section'       => 'service_area',
//                 'type'          => 'icon',
//                 'label'         => __( 'FontAwesome Icon', 'luzuk' ),
//             )
//         )
//     );



    }else{
        $wp_customize->add_setting('service_area_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
        $wp_customize->add_control(
            new luzuk_Info_Text( 
                $wp_customize,
                'service_area_lbl'.$i,
                array(
                    'settings'      => 'service_area_lbl'.$i,
                    'section'       => 'service_area',
                    'label'         => __( 'Note:', 'luzuk' ),    
                    'description'   => __( '<strong>Changes will not reflect unless you select the Service Page.</strong> <br/>Please add the Services from "Services menu" and then select Services to show information.', 'luzuk' ),
                )
            )
        );
    }
}

lzCustomLable($wp_customize, 'luzuk_sec_servicesclr', 'service_area', 'Service Section Color');

addColorPalatOption($wp_customize, 'ser_secimgClr1', 'service_area', 'Section Image Color 1 ', '#FDAF1B');

addColorPalatOption($wp_customize, 'ser_secimgClr2', 'service_area', 'Section Image Color 2 ', '#FE931F');

addColorPalatOption($wp_customize, 'ser_secimgbrdClr', 'service_area', 'Section Image Border Color', '#FDAF1B');

addColorPalatOption($wp_customize, 'services_secTitleClr', 'service_area', 'Section Title Color ', '#000');


lzCustomLable($wp_customize, 'luzuk_secssbtnclr', 'service_area', 'Slider Arrow Button Color');

addColorPalatOption($wp_customize, 'ser_slidebtnbrdclr', 'service_area', 'Section Slider Button Border Color ', '#FDAF1B');

addColorPalatOption($wp_customize, 'ser_slidebtnbgclr', 'service_area', 'Section Slider Button BG Color ', '#000');

//addColorPalatOption($wp_customize, 'ser_slidebtnbghvclr', 'service_area', 'Section Slider Button BG Hover Color ', '#FDAF1B');

addColorPalatOption($wp_customize, 'ser_slidebtnicnclr', 'service_area', 'Section Slider Button Icon Color ', '#fff');

addColorPalatOption($wp_customize, 'ser_slidebtnicnhvclr', 'service_area', 'Section Slider Button Icon Hover Color ', '#FDAF1B');