<?php  

$luzukSliderSingleChoice = getFitnessPostsType('slider');
$wp_customize->add_section(
    'slider_section',
    array(
        'title' => __( 'Slider Section', 'Luzuk' ),
        'panel' => 'luzuk_premium_home_panel',
        'priority' =>18
    )
);
$wp_customize->add_setting(
    'slider_section_show_content',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'slider_section_show_content',
        array(
            'settings'      => 'slider_section_show_content',
            'section'       => 'slider_section',
            'label'         => __( 'Hide Title And Description On Slider', 'Luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'No', 'Luzuk' ),
                'off' => __( 'Yes', 'Luzuk' )
            ),
        )
    )
);
$wp_customize->add_setting('slider_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'slider_section_lbl',
        array(
            'settings'      => 'slider_section_lbl',
            'section'       => 'slider_section',
            'label'         => __( 'Note:', 'Luzuk' ),  
            'description'   => __( 'The page featured image works as a banner and the title & content work as a slider caption. You can add this from the Slider menu. <br/> Recommended Image Size: 850X720', 'Luzuk' ),
        )
    )
);


lzCustomLable($wp_customize, 'luzuk_sliderotherclrs', 'slider_section', 'Slider Color');

addColorPalatOption($wp_customize, 'slider_imgbrdClr1', 'slider_section', 'Slider Image Border Color', '#FDAF1B');

addColorPalatOption($wp_customize, 'slider_conbxbg1Clr', 'slider_section', 'Slider Content Box BG Color 1', '#FE931F');

addColorPalatOption($wp_customize, 'slider_conbxbg2Clr', 'slider_section', 'Slider Content Box BG Color 2', '#FDAF1B');

addColorPalatOption($wp_customize, 'slider_titleClr', 'slider_section', 'Slider Title Color', '#292B2A');

addColorPalatOption($wp_customize, 'slider_SubtitleClr', 'slider_section', 'Slider Text Color', '#414141');

addColorPalatOption($wp_customize, 'slider_ButtontextColor', 'slider_section', 'Section Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'slider_ButtontexthoverColor', 'slider_section', 'Section Button Text Hover Color', '#292B2A');

addColorPalatOption($wp_customize, 'slider_Buttonibrd', 'slider_section', 'Section Button Background Color', '#292B2A');

addColorPalatOption($wp_customize, 'slider_Buttonihv', 'slider_section', 'Section Button Background Hover Color', '#fff');

lzCustomLable($wp_customize, 'luzuk_sliderphbtn', 'slider_section', 'Slider Phone Number ');

$wp_customize->add_setting(
    'MS_phnum',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '(415) 555‑0132', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'MS_phnum',
    array(
        'settings'      => 'MS_phnum',
        'section'       => 'slider_section',
        'type'          => 'text',
        'label'         => __( 'Phone Number ', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'sli_phBXBGclr', 'slider_section', 'Slider Phone Box BG Color', '#292B2A');

addColorPalatOption($wp_customize, 'sli_phbtnicnclr', 'slider_section', 'Slider Phone Icon Color', '#292B2A');

addColorPalatOption($wp_customize, 'sli_phbtnicnbgclr', 'slider_section', 'Slider Phone Icon BG Color', '#fff');

addColorPalatOption($wp_customize, 'sli_phbtnicnnumclr', 'slider_section', 'Slider Phone Number Color', '#fff');

addColorPalatOption($wp_customize, 'sli_phbtnicnhvnumclr', 'slider_section', 'Slider Phone Number Hover Color', '#FDAF1B');



lzCustomLable($wp_customize, 'luzuk_sliderbutnclrs', 'slider_section', 'Slider Buttton Colors ');

addColorPalatOption($wp_customize, 'sli_btnbgclr', 'slider_section', 'Slider Button Background Color', '#292B2A');

addColorPalatOption($wp_customize, 'sli_btnarowclr', 'slider_section', 'Slider Button Arrow Color', '#fff');

addColorPalatOption($wp_customize, 'sli_btnarowhvclr', 'slider_section', 'Slider Button Arrow Hover Color', '#6B6B6B');

lzCustomLable($wp_customize, 'luzuk_sliderresclr', 'slider_section', 'Slider Responsive');

lzCustomLable($wp_customize, 'luzuk_sliderover', 'slider_section', 'Section Overlay & Opacity Setting');

$wp_customize->add_setting(
    'slider_areaOpacity',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.4', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'slider_areaOpacity',
    array(
        'settings'      => 'slider_areaOpacity',
        'section'       => 'slider_section',
        'type'          => 'text',
        'label'         => __( 'Opacity', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'sli_imgolyclr', 'slider_section', 'Image Overlay  Color', '#fff');