<?php 
/**
 * Createing an about us pannel for customizer
 *
 */
// TEAM SECTION START HERE 
/*============TEAM SECTION PANEL============*/
$wp_customize->add_section(
	'team_section',
	array(
		'title'         => __( 'Team Section', 'luzuk-premium' ),
		'panel'   => 'luzuk_premium_home_panel',
	)
);
// ENABLE/DISABLE TEAM SECTION
$wp_customize->add_setting(
	'team_section_disable',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'team_section_disable',
		array(
			'settings'      => 'team_section_disable',
			'section'       => 'team_section',
			'label'         => __( 'Disable Section', 'luzuk-premium' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'luzuk-premium' ),
				'off' => __( 'No', 'luzuk-premium' )
			)   
		)
	)
);

backgroundManager($wp_customize, 'team', 'team_section', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

// section top border color
//addColorPalatOption($wp_customize, 'team_sectopborderColor', 'team_section', 'Section top border color','#e4e9ef');

lzCustomLable($wp_customize, 'teamsection_padding', 'team_section', ' Section Padding');

$wp_customize->add_setting(
    'team_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'team_areaTpadding',
    array(
        'settings'      => 'team_areaTpadding',
        'section'       => 'team_section',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'team_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'team_areaBpadding',
    array(
        'settings'      => 'team_areaBpadding',
        'section'       => 'team_section',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);



$wp_customize->add_setting(
	'team_title_subtitle_heading',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
	)
);
$wp_customize->add_control(
	new luzuk_Customize_Heading(
		$wp_customize,
		'team_title_subtitle_heading',
		array(
			'settings'      => 'team_title_subtitle_heading',
			'section'       => 'team_section',
			'label'         => __( 'Section Heading', 'luzuk-premium' ),
		)
	)
);

$wp_customize->add_setting(
	'team_title1',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'OUR', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'team_title1',
	array(
		'settings'      => 'team_title1',
		'section'       => 'team_section',
		'type'          => 'text',
		'label'         => __( 'Heading 1', 'luzuk-premium' )
	)
);

addColorPalatOption($wp_customize, 'team_Heading1', 'team_section', 'Heading 1 Text Color', '#000');

addColorPalatOption($wp_customize, 'team_Heading1brd', 'team_section', 'Heading 1 Border Color', '#FFD800');

addColorPalatOption($wp_customize, 'team_Heading1bg', 'team_section', 'Heading 1 BG Color', '#FDAF1B');

addColorPalatOption($wp_customize, 'team_Heading1bgcor', 'team_section', 'Heading 1 BG Corner Color', '#F9880D');

$wp_customize->add_setting(
    'team_title2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Team', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'team_title2',
    array(
        'settings'      => 'team_title2',
        'section'       => 'team_section',
        'type'          => 'text',
        'label'         => __( 'Heading 2', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'team_Heading2', 'team_section', 'Heading 2 Text Color', '#FDAF1B');

addColorPalatOption($wp_customize, 'team_Heading2bg', 'team_section', 'Heading 2 BG Color', '#6B6B6B');

addColorPalatOption($wp_customize, 'team_Heading2bgbrd1', 'team_section', 'Heading 2 Border Color', '#9F9F9F');

addColorPalatOption($wp_customize, 'team_Heading2bxbrd', 'team_section', 'Heading 2 Box Border Color', '#292B2A');

$wp_customize->add_setting('team_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Customize_Heading(
		$wp_customize,
		'team_npp_heading',
		array(
			'settings'      => 'team_npp_heading',
			'section'       => 'team_section',
			'label'         => __( 'Number Of Team To Show', 'luzuk-premium' ),
		)
	)
);    
$wp_customize->add_setting('team_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control(
	'team_npp_count',
	array(
		'settings'      => 'team_npp_count',
		'section'       => 'team_section',
		'type'          => 'select',
		'label'         => __( 'Number Of Team Members To Show', 'luzuk-premium' ),
		'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
	)
);

// TEAM PAGES
for( $i = 1; $i <= 12; $i++ ){
	$wp_customize->add_setting(
		'team_heading'.$i,
		array(
			'sanitize_callback' => 'luzuk_sanitize_text'
		)
	);
	$wp_customize->add_control(
		new luzuk_Customize_Heading(
			$wp_customize,
			'team_heading'.$i,
			array(
				'settings'      => 'team_heading'.$i,
				'section'       => 'team_section',
				'label'         => __( 'Team Member ', 'luzuk-premium' ).$i,
			)
		)
	);
	if(is_array($TeamsSingleChoice)){
		$wp_customize->add_setting(
			'team_page'.$i,
			array(
				'sanitize_callback' => 'absint'
			)
		);
		$wp_customize->add_control(
			'team_page'.$i,
			array(
				'settings'      => 'team_page'.$i,
				'section'       => 'team_section',
				'type'=> 'select',
				'label'         => __( 'Select A Team Member', 'luzuk-premium' ),
				'choices' => $TeamsSingleChoice,
			)
		);
	}else{
		$wp_customize->add_setting('team_section_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
		$wp_customize->add_control(
			new luzuk_Info_Text( 
				$wp_customize,
				'team_section_lbl'.$i,
				array(
					'settings'		=> 'team_section_lbl'.$i,
					'section'		=> 'team_section',
					'label'			=> __( 'Note:', 'luzuk-premium' ),	
					'description'	=> __( '<strong>Changes will not reflect unless you select the team member.</strong> <br/>Please add the team from "Teams menu" and then select team member to show information.', 'luzuk-premium' ),
				)
			)
		);
	}
}

lzCustomLable($wp_customize, 'teamsection_clr', 'team_section', 'Team Section Color');

addColorPalatOption($wp_customize, 'team_conbxclr', 'team_section', 'Conten Box Color', '#fff');

addColorPalatOption($wp_customize, 'team_TitleColor', 'team_section', 'Member Name Color', '#292B2A');

addColorPalatOption($wp_customize, 'team_DesColor', 'team_section', 'Designation Color', '#292B2A');

addColorPalatOption($wp_customize, 'team_DesbgClr', 'team_section', 'Designation BG Color', '#FDAF1B');

addColorPalatOption($wp_customize, 'team_Socialbxclr', 'team_section', 'Social Icon Box BG Color', '#292B2A');

addColorPalatOption($wp_customize, 'team_Socialbxbrdclr', 'team_section', 'Social Icon Box Border Color', '#FDAF1B');

addColorPalatOption($wp_customize, 'team_SocialColor', 'team_section', 'Social Icon Color', '#FDAF1B');

addColorPalatOption($wp_customize, 'team_SclicnhvClr', 'team_section', 'Social Icon Hover Color', '#fff');