<?php  
// TESTIMONIALS SECTION START HERE 

$wp_customize->add_section(
    'testimonials_area',
    array(
        'title'         => __( 'Testimonial Section', 'luzuk Premium' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);

    //ENABLE/DISABLE TESTIMONIALS SECTION
$wp_customize->add_setting(
    'testimonials_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'testimonials_area_disable',
        array(
            'settings'      => 'testimonials_area_disable',
            'section'       => 'testimonials_area',
            'label'         => __( 'Disable Section', 'luzuk Premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk Premium' ),
                'off' => __( 'No', 'luzuk Premium' )
            )   
        ) 
    )
);
 
backgroundManager($wp_customize, 'testimonials', 'testimonials_area', $color='#e7edf8', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'luzuk_sec_testsectionpadding', 'testimonials_area', 'Section Padding');

$wp_customize->add_setting(
    'testimonials_areaTpadding', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk Premium' )
    )
);
$wp_customize->add_control(
    'testimonials_areaTpadding',
    array(
        'settings'      => 'testimonials_areaTpadding',
        'section'       => 'testimonials_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk Premium' )
    )
);
$wp_customize->add_setting(
    'testimonials_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3em', 'luzuk Premium' )
    )
);
$wp_customize->add_control(
    'testimonials_areaBpadding',
    array(
        'settings'      => 'testimonials_areaBpadding',
        'section'       => 'testimonials_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk Premium' )
    )
);

$wp_customize->add_setting(
    'testi_title_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'testi_title_subtitle_heading',
        array(
            'settings'      => 'testi_title_subtitle_heading',
            'section'       => 'testimonials_area',
            'label'         => __( 'Section Heading ', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'testititle1',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'CLIENT', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'testititle1',
    array(
        'settings'      => 'testititle1',
        'section'       => 'testimonials_area',
        'type'          => 'text',
        'label'         => __( 'Heading 1', 'luzuk-premium' )
    )
);

//addColorPalatOption($wp_customize, 'testi_headingclr', 'testimonials_area', 'Section Heading Color', '#052C54');

addColorPalatOption($wp_customize, 'tessec_Heading1', 'testimonials_area', 'Heading 1 Text Color', '#000');

addColorPalatOption($wp_customize, 'tessec_Heading1brd', 'testimonials_area', 'Heading 1 Border Color', '#FFD800');

addColorPalatOption($wp_customize, 'tessec_Heading1bg', 'testimonials_area', 'Heading 1 BG Color', '#FDAF1B');

addColorPalatOption($wp_customize, 'tessec_Heading1bgcor', 'testimonials_area', 'Heading 1 BG Corner Color', '#F9880D');


$wp_customize->add_setting(
    'testi_title2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Review', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'testi_title2',
    array(
        'settings'      => 'testi_title2',
        'section'       => 'testimonials_area',
        'type'          => 'text',
        'label'         => __( 'Heading 2', 'luzuk-premium' )
    )
);
addColorPalatOption($wp_customize, 'tessec_Heading2', 'testimonials_area', 'Heading 2 Text Color', '#FDAF1B');

addColorPalatOption($wp_customize, 'tessec_Heading2bg', 'testimonials_area', 'Heading 2 BG Color', '#6B6B6B');

addColorPalatOption($wp_customize, 'tessec_Heading2bgbrd1', 'testimonials_area', 'Heading 2 Border Color', '#9F9F9F');

addColorPalatOption($wp_customize, 'tessec_Heading2bxbrd', 'testimonials_area', 'Heading 2 Box Border Color', '#292B2A');


$TesimonialsSingleChoice[] = 'select';
if(!is_array($TesimonialsSingleChoice)){
    $wp_customize->add_setting('testimonials_area_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
    $wp_customize->add_control(
        new luzuk_Info_Text( 
            $wp_customize,
            'testimonials_area_lbl',
            array(
                'settings'      => 'testimonials_area_lbl',
                'section'       => 'testimonials_area',
                'label'         => __( 'Note:', 'luzuk Premium' ), 
                'description'   => __( '<strong>Changes will not reflect unless you select the Testimonials.</strong> <br/>Please add the Testimonials from "Testimonials menu" and then select Testimonial to show information.', 'luzuk Premium' ),
            )
        )
    );
}
$wp_customize->add_setting('luzuk_premium_testimonials_area_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_testimonials_area_lbl',
        array(
            'settings'      => 'luzuk_premium_testimonials_area_lbl',
            'section'       => 'testimonials_area',
            'label'         => __( 'Note:', 'luzuk Premium' ), 
            'description'   => __( 'Just place the shortcode "[TESTIMONIALS]" in your page to list the Testimonials in a page ', 'luzuk Premium' ),
        )
    )
);
//TESTIMONIALS PAGES
for( $i = 1; $i < 10; $i++ ){
    $wp_customize->add_setting(
        'luzuk_testimonials_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'luzuk_testimonials_heading'.$i,
            array(
                'settings'      => 'luzuk_testimonials_heading'.$i,
                'section'       => 'testimonials_area',
                'label'         => __( 'Testimonial ', 'luzuk Premium' ).$i,
            )
        )
    );
    $wp_customize->add_setting(
        'testimonials_page'.$i,
        array(
            'sanitize_callback' => 'absint'
        )
    );
    $wp_customize->add_control(
        'testimonials_page'.$i,
        array(
            'settings'      => 'testimonials_page'.$i,
            'section'       => 'testimonials_area',
            'type'=> 'select',
            'label'         => __( 'Select A Client Testimonial', 'luzuk Premium' ),
            'choices' => $TesimonialsSingleChoice,
        )
    );
}


lzCustomLable($wp_customize, 'clientcolor', 'testimonials_area', 'Testimonial Section Color');

addColorPalatOption($wp_customize, 'tes_secboxbgclr', 'testimonials_area', ' Section Box BG Color', '#484848');

addColorPalatOption($wp_customize, 'tes_secimgbrdclr1', 'testimonials_area', ' Image Border 1 Color', '#ffd14a');

addColorPalatOption($wp_customize, 'tes_secimgbrdclr2', 'testimonials_area', ' Image Border 2 Color', '#fe931f');

addColorPalatOption($wp_customize, 'tes_secimgbrdclr2hv', 'testimonials_area', ' Image Border 2 Hover Color', '#484848');

addColorPalatOption($wp_customize, 'tes_sectextclr', 'testimonials_area', ' Text Color', '#BEBDBD');

addColorPalatOption($wp_customize, 'tes_secNameclr', 'testimonials_area', 'Client Name Color', '#F9A300');

addColorPalatOption($wp_customize, 'tes_secdeginclr', 'testimonials_area', 'Client Designation Color', '#E7E6EB');


lzCustomLable($wp_customize, 'luzuk_secssbtnclr', 'testimonials_area', 'Slider Arrow Button Color');

addColorPalatOption($wp_customize, 'tes_slidebtnbrdclr', 'testimonials_area', 'Section Slider Button Border Color ', '#FDAF1B');

addColorPalatOption($wp_customize, 'tes_slidebtnbgclr', 'testimonials_area', 'Section Slider Button BG Color ', '#000');

addColorPalatOption($wp_customize, 'tes_slidebtnicnclr', 'testimonials_area', 'Section Slider Button Icon Color ', '#fff');


addColorPalatOption($wp_customize, 'tes_slidebtnicnhvclr', 'testimonials_area', 'Section Slider Button Icon Hover Color ', '#FDAF1B');