<?php
/**
 *
 * @package Slider Premium
 */
?>
<?php $showContent = get_theme_mod('slider_section_show_content', 'on'); ?>
<div class="slider_section" id="slider">

    <div class="owl-slider">
        <div id="carousel" class="owl-carousel">
            <?php
            $args = array( 'post_type' => 'slider', 'orderby'   => 'id', 'order' => 'DESC',);
            if(!empty($pageId)){
                $args['page_id'] = absint($pageId);

            }
            $text = '';
            $query = new WP_Query($args);
            if($query->have_posts()){
                while($query->have_posts()) : $query->the_post(); 
                

                if( get_theme_mod('slider_areaOpacity',true) ) {
                    $slider_areaOpacity = 'opacity:'.esc_attr(get_theme_mod('slider_areaOpacity')).';';
                }
                if( get_theme_mod('slider_Tfontsize',true) ) {
                    $slider_Tfontsize = 'font-size:'.esc_attr(get_theme_mod('slider_Tfontsize')).';';
                }

                $pageLink = '';
                $slider_btn_link = get_post_meta($post->ID,'slider_btn_link',false);
                $sliderBtnTxt = get_post_meta($post->ID,'sliderBtnTxt',false);
                if(!empty($slider_btn_link) && is_array($slider_btn_link)){
                    $pageLink = esc_url(get_permalink($slider_btn_link[0]));
                }
                if(!empty($sliderBtnTxt) && is_array($sliderBtnTxt)){
                    $pageLinkTxt = $sliderBtnTxt[0];
                }else{
                    $pageLinkTxt = 'Read More';
                }

                ?>
            <div class="item">
                <div class="imbx">
                    <?php 
                        if(has_post_thumbnail()){
                            $total_slider_image = wp_get_attachment_image_src(get_post_thumbnail_id(),'full');  
                            echo '<img class="slide-mainimg" alt="'. esc_html(get_the_title()) .'" src="'.esc_url($total_slider_image[0]).'">';
                    }?>
                    <div class="overlay"></div>
                    <?php
                    if($showContent == 'on'){
                        ?>
                    <div class="slider_content " data-wow-duration="1s">
                        <div class="title wow bounceInDown">
                            <?php echo (get_the_title()); ?>
                        </div>
                        <div class="sub-title wow bounceInLeft">
                            <?php echo (get_the_content()); ?>
                        </div>
                        <?php 
                        if(!empty($pageLink)){ ?>
                            <div class="slide-btna">
                                <div class="btn5">  
                                    <a href="<?php echo $pageLink; ?>">
                                        <?php echo($pageLinkTxt); ?> <i class="fa fa-long-arrow-right"></i>
                                    </a>
                                </div>
                            </div>
                        <?php }?>
                    </div>
                    <?php }?>

                    <div class="shape"></div>
                    <?php
                            $MS_phnum = get_theme_mod('MS_phnum', '(415) 555‑0132');
                        ?>
                    <?php if($MS_phnum ){ ?> 
                    <div class="ph-bx">
                        
                        <div class="row m-0">
                            <div class="col-md-4 col-sm-4 col-4">
                                <div class="ph-icnbx">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-phone-call" viewBox="0 0 24 24" stroke-width="0.5"   stroke-linecap="round" stroke-linejoin="round">
                                      <!-- <path stroke="none" d="M0 0h24v24H0z" fill="none"/> -->
                                      <path d="M5 4h4l2 5l-2.5 1.5a11 11 0 0 0 5 5l1.5 -2.5l5 2v4a2 2 0 0 1 -2 2a16 16 0 0 1 -15 -15a2 2 0 0 1 2 -2" />
                                      <path d="M15 7a2 2 0 0 1 2 2" />
                                      <path d="M15 3a6 6 0 0 1 6 6" />
                                    </svg>
                                </div>
                            </div>
                            <div class="col-md-8 col-sm-8 col-8 pd-0">
                                <div class="Ph-nobx">
                                    <a href="tel:<?php echo $MS_phnum;?>"><?php echo ($MS_phnum);  ?></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php }?>
                </div>
            </div>
                    <?php
                endwhile;
            }else{ 
                for($i=0;$i<6;$i++){?>
            <div class="item">
                <div class="imbx">
                    <?php echo '<img class="slide-mainimg" alt="Slider" src="'. esc_html(get_template_directory_uri()) .'/images/slider-banner.jpg">';?>
                    <div class="overlay"></div>
                    <?php if($showContent == 'on'){?>
                
                    <div class="slider_content" data-wow-duration="1s">
                        <div class="title wow bounceInDown">ENHANCING YOUR SPACE,ONE FIX AT A TIME.</div>
                        <div class="sub-title wow bounceInLeft">Nulla eget tellus arcu. Cras eu viverra purus. Nunc tincidunt vestibulum ultrices. Proin rutrum blandit elit. Praesent maximus tellus id risus.</div>
                        <div class="slide-btna ">
                            <div class="btn5">
                                <a href="#">
                                    <?php _e( 'Read More', 'luzuk-premium' ); ?> <i class="fa fa-long-arrow-right"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                    <?php }?>
                    <div class="shape"></div>
                    <?php
                            $MS_phnum = get_theme_mod('MS_phnum', '(415) 555‑0132');
                        ?>
                    <?php if($MS_phnum ){ ?> 
                    <div class="ph-bx">
                        
                        <div class="row m-0">
                            <div class="col-md-4 col-sm-4 col-4">
                                <div class="ph-icnbx">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-phone-call" viewBox="0 0 24 24" stroke-width="0.5"   stroke-linecap="round" stroke-linejoin="round">
                                      <!-- <path stroke="none" d="M0 0h24v24H0z" fill="none"/> -->
                                      <path d="M5 4h4l2 5l-2.5 1.5a11 11 0 0 0 5 5l1.5 -2.5l5 2v4a2 2 0 0 1 -2 2a16 16 0 0 1 -15 -15a2 2 0 0 1 2 -2" />
                                      <path d="M15 7a2 2 0 0 1 2 2" />
                                      <path d="M15 3a6 6 0 0 1 6 6" />
                                    </svg>
                                </div>
                            </div>
                            <div class="col-md-8 col-sm-8 col-8 pd-0">
                                <div class="Ph-nobx">
                                    <a href="tel:<?php echo $MS_phnum;?>"><?php echo ($MS_phnum);  ?></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php }?>
                </div>
            </div>
                <?php }
            }?>
        </div>
    </div>
</div>
<script>
        $(document).ready(function() {
          $('.slider_section .owl-carousel').owlCarousel({
            refreshClass: 'owl-refresh',
            autoplayTimeout:9000,
            loop: true,
            margin: 30,
            autoHeight: true,
            autoWidth: false,
            autoplay: true,
            // animateOut: 'lightSpeedOut',
            // animateOut: 'slideOutDown',
            // animateOut: 'fadeOutRight',
            animateIn: 'fadeInLeft',
            navText: [
                    '<i class="fa fa-long-arrow-left"></i> ',
                    '<i class="fa fa-long-arrow-right" ></i>'
                ],
            responsiveClass: true,

            responsive: {
              0: {
                items: 1,
                nav: true,
                margin: 40
              },
              600: {
                items:1,
                nav: true,
                margin: 50
              },
              1000: {
                items:1,
                nav: true,
                loop: true,
                margin: 100
              }
            }
          })
        })

</script>
