<?php   
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package luzuk Premium
 */
?>
<?php 
	if( get_theme_mod('sec_footerseTmargin',true) ) {
		$sec_footerseTmargin = 'padding-top:'.esc_attr(get_theme_mod('sec_footerseTmargin')).';';
	}
	if( get_theme_mod('sec_footersebottommargin',true) ) {
		$sec_footersebottommargin = 'padding-bottom:'.esc_attr(get_theme_mod('sec_footersebottommargin')).';';
	}
	if( get_theme_mod('sec_footersecopacity',true) ) {
		$sec_footersecopacity = 'opacity:'.esc_attr(get_theme_mod('sec_footersecopacity')).';';
	}

?>		

<footer class="footer-area" id="footer" style="<?php echo esc_attr($sec_footerseTmargin); ?>" "<?php echo esc_attr($sec_footersebottommargin); ?>" "<?php echo esc_attr($sec_footersecopacity); ?>">

	<?php if(is_active_sidebar('luzuk-footer1') || is_active_sidebar('luzuk-footer2') || is_active_sidebar('luzuk-footer3') || is_active_sidebar('luzuk-footer4') ){ ?>
		
		<?php
			$newsletter_title = get_theme_mod('newsletter_title', 'Subscribe To Our Newsletter');
			$luzuk_newsletter_shortcode = get_theme_mod('luzuk_newsletter_shortcode', '[Add Form shortcode]');
			$socialicn_title = get_theme_mod('socialicn_title', 'Join Us On Social Platforms');
			$footer_facebook = get_theme_mod('footer_facebook', '#');
			$footer_twitter = get_theme_mod('footer_twitter', '#');
			$footer_instagram = get_theme_mod('footer_instagram', '#');
			$footer_linkedin = get_theme_mod('footer_linkedin', '#');
		?>
	
	<div class="box-form">
		<div class="container">
			<div class="row">
				<div class="col-xl-5 col-lg-5 col-md-6 col-sm-12">
					<div class="newsletter-box">
						<div class="newstitle">
						    <?php if($newsletter_title ){ ?>
							    <h3><?php echo ($newsletter_title);  ?></h3> 
				            <?php }?>
						</div>
						<div class="subscribe_shortcode ">			
							<div class="ht-newsletter-member-wrap">										
								<?php echo do_shortcode($luzuk_newsletter_shortcode);?>
							</div>
						</div>
					</div>
				</div>
				<div class="col-xl-7 col-lg-7 col-md-6 col-sm-12">
					<div class="footer-sclicn">
						<div class="fsocil-title">
							<?php if($socialicn_title ){ ?>
							    <h3><?php echo ($socialicn_title);  ?></h3> 
				            <?php }?>
						</div>
						<?php if ($footer_facebook || $footer_twitter || $footer_instagram || $footer_linkedin) { ?>
		                    <div class="team-social-icon">
		                        <?php if ($footer_facebook) { ?>
		                            <li>
		                                <a target="_blank" href="<?php echo esc_url($footer_facebook) ?>">
		                                <i class="fa fa-facebook"></i></a>
		                            </li>
		                        <?php } ?>
		                        <?php if ($footer_instagram) { ?>
		                            <li>
		                                <a target="_blank" href="<?php echo esc_url($footer_instagram) ?>" ><i class="fa fa-instagram"></i></a> 
		                            </li>
		                        <?php } ?>
		                        <?php if ($footer_twitter) { ?>
		                            <li>
		                                <a target="_blank" href="<?php echo esc_url($footer_twitter) ?>" ><i class="fa-brands fa-x-twitter"></i></a>
		                            </li>
		                        <?php } ?>
	                           <?php if ($footer_linkedin) { ?>
	                                <li>
	                                    <a target="_blank" href="<?php echo esc_url($footer_linkedin) ?>"><i class="fa fa-linkedin"></i></a>
	                                </li>
	                            <?php } ?>
		                    </div>
                    	<?php } ?> 
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="fbox"> 
		<div class="container">
			<div class="row mr-0">
				<div class="s-footer col-lg-3 col-md-6 col-sm-6 col-xs-12 single-footer-1 ">
					<div class="single-footer wow zoomIn" data-wow-duration="1s" >
						<?php if(is_active_sidebar('luzuk-footer1')): 
							dynamic_sidebar('luzuk-footer1');
						endif;
						?>	
					</div>
				</div>

				<div class="s-footer col-lg-3 col-md-6 col-sm-6 col-xs-12 single-footer-2 ">
					<div class="single-footer wow zoomIn" data-wow-duration="1.5s" >
						<?php if(is_active_sidebar('luzuk-footer2')): 
							dynamic_sidebar('luzuk-footer2');
						endif;
						?>	
					</div>
				</div>

				<div class="s-footer col-lg-3 col-md-6 col-sm-6 col-xs-12 single-footer-3">
					<div class="single-footer wow zoomIn"  data-wow-duration="2s" >
						<?php if(is_active_sidebar('luzuk-footer3')): 
							dynamic_sidebar('luzuk-footer3');
						endif;
						?>	
					</div>
				</div>

				<div class="s-footer col-lg-3 col-md-6 col-sm-6 col-xs-12 single-footer-4" >
					<div class="single-footer wow zoomIn" data-wow-duration="2.5s" >
						<?php if(is_active_sidebar('luzuk-footer4')): 
							dynamic_sidebar('luzuk-footer4');
						endif;
						?>	
					</div>
				</div>
			</div>
		</div>
	</div>
		
	<?php } ?>

	<?php
		$footercopyright = get_theme_mod('footer_area_copyrighttext', 'Copyright @ 2023 Icecream Shop All Right Reserved');
	?>
	<?php 
		if( get_theme_mod('sec_bottomareaTmargin',true) ) {
			$sec_bottomareaTmargin = 'padding-top:'.esc_attr(get_theme_mod('sec_bottomareaTmargin')).';';
		}
		if( get_theme_mod('sec_bottomareabottommargin',true) ) {
			$sec_bottomareabottommargin = 'padding-bottom:'.esc_attr(get_theme_mod('sec_bottomareabottommargin')).';';
		}
	?>		
	<div class="bottom-area wow zoomIn" style="<?php echo esc_attr($sec_bottomareaTmargin); ?>" "<?php echo esc_attr($sec_bottomareabottommargin); ?>">
		<div class="container">
			<div class="col-md-12 col-sm-12 col-xs-12 pd-0">
				<div class="footer-text">
					<?php if($footercopyright){ ?>
							<?php echo $footercopyright;?>
					<?php } ?>
				</div>
			</div>
		</div>
	</div>
	<div class="clearfix"></div>
</footer>

<script type="text/javascript">
	if(jQuery(window).width() >= 1170){
		new WOW().init();
	}
</script>

<script>
	$(window).scroll(function() {
		var height = $(window).scrollTop();
		if (height > 100) {
			$('#back2Top').fadeIn();
		} else {
			$('#back2Top').fadeOut();
		}
	});
	$(document).ready(function() {
		$("#back2Top").click(function(event) {
			event.preventDefault();
			$("html, body").animate({ scrollTop: 0 }, "slow");
			return false;
		});

	});
</script> 

<?php wp_footer(); ?>

	<!-- <a id="back2Top" title="Back to top" href="#"> &#10148; </a> -->

<a id="back2Top" title="Back to top" href="#"> 
	<!-- <i class="fa fa-angle-double-up" aria-hidden="true"></i> -->
	 <div class="box-canvas">
	    <div class="cone"></div>
	    <div class="drip"></div>
	    <div class="scoop"></div>
  </div>
</a>

</body>
</html>
