<?php    
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package luzuk Premium
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Oleo+Script:wght@400;700&family=Roboto:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">

	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
	<script src="https://code.jquery.com/jquery-3.1.1.min.js" integrity="sha384-3ceskX3iaEnIogmQchP8opvBy3Mi7Ce34nWjpBIwVTHfGYWQS9jwHDVRnpKKHJg7" crossorigin="anonymous"></script>
	<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css
" rel="stylesheet">
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>

    <script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" type="text/javascript"  ></script>
   <script src="<?php echo get_template_directory_uri(); ?>/js/swiper.min.js" type="text/javascript"  ></script>
	<script type="text/javascript" src="https://code.jquery.com/jquery-1.12.0.min.js"></script>
   	<script type="text/javascript">
		$(document).ready(function(){
			$("#formButton").click(function(){
				$("#form1").toggle();
			});
		});
	 </script>

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<div class="main-container">
		<div id="loading-area"><div class="la-anim-10"></div></div>
		<header class="site-header header-transparent header header-seo">
			<div class="top-bar-head">
				<div class="top-header">
				<div class="container clearfix">
					<div class="row mr-0">
						<div class="header-left col-xl-2 col-lg-2 col-md-3 col-sm-3 col-xs-10 logo">
						<?php 
							if( get_theme_mod('pages_logoTopsetmaxwidth',true) ) {
								$pages_logoTopsetmaxwidth = 'max-width:'.esc_attr(get_theme_mod('pages_logoTopsetmaxwidth')).';';
							}
							?>
							<!-- website logo -->
							<div class="logo-header mostion">
								<?php 
								if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
									the_custom_logo();
							else : 
								if ( is_front_page() ) : ?>
									<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
									<?php else : ?>
										<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
									<?php endif; ?>
								<?php endif; ?>
								<?php if( get_theme_mod('head_tagline_display','show' ) == 'show') :?>	
							<p class="ht-site-description"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'description' ); ?></a></p> 
							<?php endif ?>  
							</div> 
							<!-- nav toggle button -->
							<div class="resp_header_logo">
								<?php 
								if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
									the_custom_logo();
							else : 
								if ( is_front_page() ) : ?>
									<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
									<?php else : ?>
										<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
									<?php endif; ?>
									<!-- <p class="ht-site-description"><a href="<?php //echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php //bloginfo( 'description' ); ?></a></p> -->
								<?php endif; ?>
							</div>
						</div>
						<div class="col-xl-6 col-lg-5 col-md-1 col-sm-2 col-xs-2 pd-0 head-menubx">
							<div class="head-menu">
								<div class="site-navigation ">
			                        <div class="nav-menus">                 
										<a class="js-nav-toggle">
												<span></span>
										</a>
									    <div class="nav-wrapper">
											<nav role="navigation">
												<div class="nav-toggle">
														<span class="nav-back"></span>
														<span class="nav-title">Menu</span>
														<span class="nav-close"></span>
												</div>
												<?php
			                                        if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
			                                            wp_nav_menu ( array(
			                                                'menu_class' => 'mainm ht-clearfix',
			                                                'container'=> 'ul',
			                                                'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
			                                                'theme_location' => 'primary',  
			                                            )); 
			                                        } else {
			                                            wp_nav_menu ( array(
			                                                'menu_class' => 'mainm ht-clearfix',
			                                                'container'=> 'ul',
			                                                'theme_location' => 'primary',  
			                                            )); 
			                                        }
			                                    ?>
											</nav>
										</div>
									</div>
			                        <nav class="navigation">
			                            <div class="overlaybg"></div><!--  /.overlaybg -->
			                            <!-- Main Menu -->
			                            <div class="menu-wrapper">
			                                <div class="menu-content">
			                                    <?php
			                                        if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
			                                            wp_nav_menu ( array(
			                                                'menu_class' => 'mainmenu ht-clearfix',
			                                                'container'=> 'ul',
			                                                'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
			                                                'theme_location' => 'primary',  
			                                            )); 
			                                        } else {
			                                            wp_nav_menu ( array(
			                                                'menu_class' => 'mainmenu ht-clearfix',
			                                                'container'=> 'ul',
			                                                'theme_location' => 'primary',  
			                                            )); 
			                                        }
			                                    ?>
			                                </div> <!-- /.hours-content-->
										<div class="clearfix"></div>

			                        </div><!-- /.menu-wrapper --> 
			                        </nav>
			                        <div class="clearfix"></div>
			                    </div><!--  /.site-navigation -->
							</div>  
							<div class="clearfix"></div>
						</div> 
						<div class="col-xl-4 col-lg-4 col-md-8 col-sm-7 col-7 header-rght">
							<div class="header-icons">
								<?php
									$headerwishlink = get_theme_mod('headerwishlink', '#'); 
								?>
								<li class="header-wish">
									<?php if( get_theme_mod('wishlist_button_display','show' ) == 'show') :?>
										<a href="<?php echo $headerwishlink; ?>">
											<i class="fa fa-heart-o" aria-hidden="true"></i>
										</a>
									<?php endif ?>	
								</li>
								<li class="top-form">
									<button type="button" id="formButton" class="pull-right"></button>
									<form id="form1">					
										<?php get_search_form(); ?>
									</form>	
								</li>
								<li>
									<?php if( get_theme_mod('shop_button_display','show' ) == 'show') :?>
										<div class="hshop "> 
										<?php if(function_exists ('wc_get_cart_url')){?>				
											<a href="<?php echo wc_get_cart_url();?>" class="">
												<i class="fa fa-shopping-cart"></i>
												<div class="count">
													<?php global $woocommerce; ?><?php echo WC()->cart->get_cart_contents_count(); ?>
												</div> 
											</a>
										<?php }?>
										</div>
									<?php endif ?>	
								</li>
								<li>
									<?php
						                $headerphone = get_theme_mod('headerphone', '+121 0909 879');
						            ?>
									<?php if( $headerphone){ ?>
									    <div class="header-phone ">
											<a href="tel:<?php echo $headerphone;?>"><i class="fa fa-phone" aria-hidden="true"></i>
												<span><?php echo ($headerphone);  ?></span>
												 <svg>
		                                            <path d="m44 0s-6 0-6 5.4 0 11.2 0 11.2 0.1 5.4-5.7 5.4-5.3-5.4-5.3-5.4 0-5.8 0-11.2-6.2-5.4-6.2-5.4"/>
		                                            <path d="m67.9 0s-5.9 0-5.9 5.4 0 31.6 0 31.6-0.1 6-5.9 6-6.1-6-6.1-6 0-26.2 0-31.6-5.7-5.4-5.7-5.4"/>
		                                            <path d="m122.1 0s-6.1 0-6.1 5.4 0 11.2 0 11.2 0.2 5.4-5.6 5.4-6.5-5.4-6.5-5.4 0-5.8 0-11.2c0.1-5.4-5.5-5.4-5.5-5.4"/>
		                                            <path d="m158.1 0s-6.1 0-6.1 5.4 0 24.8 0 24.8 0.3 6.8-5.5 6.8-5.5-6.8-5.5-6.8 0-19.4 0-24.8-6.1-5.4-6.1-5.4"/>
		                                            <path d="m180.3 0s-6.3 0-6.3 5.4 0 2.4 0 2.4 0.7 6.2-5.1 6.2-5.9-6.2-5.9-6.2 0 3.1 0-2.4c0-5.4-6-5.4-6-5.4"/>
		                                        </svg>
											</a>
											</div>
											<div class="header-phone-mbview">
												<i class="fa fa-phone" aria-hidden="true"></i>
												<span class="tooltiptext">
													<a href="tel:<?php echo $headerphone;?>"><?php echo ($headerphone);  ?></a>
												</span>
											</div>
						        	<?php }?>
								</li>
							</div>
						</div>
					</div>
					<div class="clearfix"></div>
				</div>
			</div>
			<div class="clearfix"></div>
			<div class="header-drip">
				<div class="header-drip1">
					<div class="header-drip2"></div>
				</div>
			</div>
		</div>
	</header>
</div>			
<div class="clearfix"></div>	