<?php

$wp_customize->add_panel(
	'luzuk_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'luzuk Premium')
	)
);

//STATIC FRONT PAGE
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'luzuk Premium'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
    'title' => __( 'Site Logo/Title/Tagline', 'luzuk Premium' ),
    'panel' => 'luzuk_general_panel',
) );

// $wp_customize->add_setting(
//     'pages_logoTopsetmaxwidth',
//     array(
//         'sanitize_callback' => 'luzuk_sanitize_text',
//         'default'           => __( '100', 'luzuk-premium' )
//     )
// );

// $wp_customize->add_control(
//     'pages_logoTopsetmaxwidth',
//     array(
//         'settings'      => 'pages_logoTopsetmaxwidth',
//         'section'       => 'title_tagline',
//         'type'          => 'text',
//         'label'         => __( 'Set Logo Max Width', 'luzuk-premium' )
//     )
// );

addColorPalatOption($wp_customize, 'header_SiteTitleClr', 'title_tagline', 'Title Color', '#F23C38');
addColorPalatOption($wp_customize, 'header_SiteTaglineClr', 'title_tagline', 'Tagline Color', '#3A3A3A');

$wp_customize->add_setting( 'head_tagline_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'head_tagline_display', array( 'label' => 'Tagline Display', 'section' => 'title_tagline', 'settings' => 'head_tagline_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show ', 'hide' => 'Hide ', ), ) ); 


//BACKGROUND IMAGE
$wp_customize->add_section( 'background_image', array(
	'title' => __( 'Background Image Setting', 'luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );

//Header IMAGE
$wp_customize->add_section( 'header_image', array(
	'title' => __( 'Header Image', 'luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );


//HEADER SETTINGS
$wp_customize->add_section(
	'header_settings',
	array(
		'title' => __( 'Header Settings', 'luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'stickyheader_view', 'header_settings', 'Sticky Header Settings');
    //ENABLE/DISABLE STICKY HEADER
$wp_customize->add_setting(
    'luzuk_sticky_header_enable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);

$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'luzuk_sticky_header_enable',
        array(
            'settings'      => 'luzuk_sticky_header_enable',
            'section'       => 'header_settings',
            'label'         => __( 'Sticky Header', 'luzuk Premium' ),
            'on_off_label'  => array(
                'on' => __( 'Enable', 'luzuk-premium' ),
                'off' => __( 'Disable', 'luzuk-premium' )
            )   
        )
    )
);


$sectionHeader = 'header_settings';


lzCustomLable($wp_customize, 'pages_logosetmaxwidth5', 'title_tagline', 'Set Logo Width & Height');

$wp_customize->add_setting(
    'pages_logoTopsetmaxwidth',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '100%', 'luzuk-premium' )

    )
);

// logo width

$wp_customize->add_control(
    'pages_logoTopsetmaxwidth',
    array(
        'settings'      => 'pages_logoTopsetmaxwidth',
        'section'       => 'title_tagline',
        'type'          => 'range',
        'label'         => __( 'Width', 'luzuk-premium' )
    )
);

// logo height

$wp_customize->add_setting(
    'pages_logoTopsetmaxheight',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoTopsetmaxheight',
    array(
        'settings'      => 'pages_logoTopsetmaxheight',
        'section'       => 'title_tagline',
        'type'          => 'text',
        'label'         => __( 'Height ', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'luzuk_headerlogo_margin', 'header_settings', 'Logo Margin');

$wp_customize->add_setting(
    'logo_logoTmargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'logo_logoTmargin',
    array(
        'settings'      => 'logo_logoTmargin',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'logo_logoRmargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'logo_logoRmargin',
    array(
        'settings'      => 'logo_logoRmargin',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Right', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'logo_logoBmargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'logo_logoBmargin',
    array(
        'settings'      => 'logo_logoBmargin',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'logo_logoLmargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'logo_logoLmargin',
    array(
        'settings'      => 'logo_logoLmargin',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Left', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'header_MenuColorssettings', $sectionHeader, 'Navigation Colors');

//addColorPalatOption($wp_customize, 'header_mainmenusbgClr', 'header_settings', 'Header Menu Bg Color', '#000');
addColorPalatOption($wp_customize, 'header_logobgClr', 'header_settings', 'Header BG Color', '#FCE097'); 

addColorPalatOption($wp_customize, 'header_logoshdwClr1', 'header_settings', 'Header Shadow  Color 1', '#E1C519');

addColorPalatOption($wp_customize, 'header_logoshdwClr2', 'header_settings', 'Header Shadow  Color 2', '#9d7d5b');

addColorPalatOption($wp_customize, 'header_innpagetopmenusClr', 'header_settings', 'Inner Page Menus Color', '#3A3A3A');

addColorPalatOption($wp_customize, 'header_topmenusColor', 'header_settings', 'Menus Color', '#3A3A3A');

addColorPalatOption($wp_customize, 'header_topmenushoverColor', 'header_settings', 'Menus Hover Color', '#F23C38');

addColorPalatOption($wp_customize, 'header_topmenusactiveColor', 'header_settings', 'Active Menus Color', '#F23C38');

addColorPalatOption($wp_customize, 'header_topsubmenusColor', 'header_settings', 'Header Sub Menus Color', '#3A3A3A');

addColorPalatOption($wp_customize, 'header_topsubmenusbrdclr', 'header_settings', 'Header Sub Menus Border Color', '#F23C38');

addColorPalatOption($wp_customize, 'header_topsubmenushvrColor', 'header_settings', 'Sub Menus Hover & Sub Menus Active Color', '#FCE097');

addColorPalatOption($wp_customize, 'header_topsubmenushvbgColor', 'header_settings', 'Sub Menus Hover & Sub Menus Active BG Color', '#F23C38');

addColorPalatOption($wp_customize, 'header_submenusbgsscColor', 'header_settings', 'Dropdown Box BG Color', '#F5EFD7');

addColorPalatOption($wp_customize, 'header_submenusbrdColor', 'header_settings', 'Dropdown Box Border Color', '#FCE097');

lzCustomLable($wp_customize, 'header_wishlistsettings', 'header_settings', 'Wishlist Setting');

$wp_customize->add_setting('headerwishlink',   array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('headerwishlink',
    array(
        'settings'      => 'headerwishlink',
        'section'       => 'header_settings',
        'type'          => 'url',
        'label'         => __( 'Add Link', 'luzuk-premium' )
    )
);

// to show & hide another button
$wp_customize->add_setting( 'wishlist_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'wishlist_button_display', array( 'label' => 'Wishlist Icon Display', 'section' => 'header_settings', 'settings' => 'wishlist_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show', 'hide' => 'Hide', ), ) ); 

lzCustomLable($wp_customize, 'header_contactdetailsettings', 'header_settings', 'Contact Details Setting');

$wp_customize->add_setting(
    'headerphone',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '+121 0909 879' )
    )
);
$wp_customize->add_control(
    'headerphone',
    array(
        'settings'      => 'headerphone',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Phone Number', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'header_iconsColor', 'header_settings', 'Header Icons Color');

addColorPalatOption($wp_customize, 'header_cntcticonsColor', 'header_settings', 'Header Icons Color', '#000');

addColorPalatOption($wp_customize, 'header_searchformbgColor', 'header_settings', 'Search Form BG Color', '#fff');

addColorPalatOption($wp_customize, 'header_searchformbrdColor', 'header_settings', 'Search Form Border Color', '#FC0000');

addColorPalatOption($wp_customize, 'header_searchformtxtColor', 'header_settings', 'Search Form Text Color', '#404040');

addColorPalatOption($wp_customize, 'header_searchformbtntxtColor', 'header_settings', 'Search Form Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'header_searchformbtnbgColor', 'header_settings', 'Search Form Button BG Color', '#F23C38');

addColorPalatOption($wp_customize, 'header_cartnmbrColor', 'header_settings', 'Header Cart Number Color', '#fff');

addColorPalatOption($wp_customize, 'header_cartnmbrbgColor', 'header_settings', 'Header Cart Number BG Color', '#F23C38');

addColorPalatOption($wp_customize, 'header_cntctnbrColor', 'header_settings', 'Header Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'header_cntctnbgColor', 'header_settings', 'Header Button BG Color', '#F23C38');

lzCustomLable($wp_customize, 'shop_button_displaylabel', 'header_settings', 'Shopping Cart Display Setting');
// to show & hide another button
$wp_customize->add_setting( 'shop_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'shop_button_display', array( 'label' => 'Shopping Cart Display', 'section' => 'header_settings', 'settings' => 'shop_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show', 'hide' => 'Hide', ), ) ); 
// end to show & hide button

lzCustomLable($wp_customize, 'header_colorsfortabandmobview', $sectionHeader, 'Responsive Header Settings');

addColorPalatOption($wp_customize, 'header_respnavtoggbarbgssColor', 'header_settings', 'Toggle Bar Color', '#000');

addColorPalatOption($wp_customize, 'header_respnavbsbgssColor', 'header_settings', ' Navigation Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'header_navigationrespnavbrssColor', 'header_settings', 'Menus Title Color', '#000');

addColorPalatOption($wp_customize, 'header_navigationrespnavmenuttlbgColor', 'header_settings', 'Menus Title BG Color', '#F23C38');

addColorPalatOption($wp_customize, 'header_navigationrespnavmenuColor', 'header_settings', 'Menus Color', '#000');

addColorPalatOption($wp_customize, 'header_navigationrespnavmenubgColor', 'header_settings', 'Menus BG Color', '#FCE097');


//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'luzuk Premium'),
	'panel' => 'luzuk_general_panel',
) );


    $wp_customize->add_setting('luzuk_premium_color_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_color_section_lbl',
        array(
            'settings'      => 'luzuk_premium_color_section_lbl',
            'section'       => 'colors',
            'label'         => __( 'Note:', 'luzuk-premium' ),  
            'description'   => __( '<b>This section available only for PRO version</b><br>If you want this section click on <b>Go Pro</b>', 'luzuk-premium' ),
        )
    )
);

//BREADCRUMB SETTINGS
$wp_customize->add_section(
	'luzuk_breadcrumb_settings',
	array(
		'title' => __( 'Breadcrumb Settings', 'luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

//for breadcrumb to show & hide button

$wp_customize->add_setting( 'breadcrumb_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'breadcrumb_button_display', array( 'label' => 'Breadcrumb Display', 'section' => 'luzuk_breadcrumb_settings', 'settings' => 'breadcrumb_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show', 'hide' => 'Hide', ), ) ); 

$wp_customize->add_setting(
        'luzuk_breadcrumbhometxt',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Home', 'luzuk' )
        )
    );
    $wp_customize->add_control(
        'luzuk_breadcrumbhometxt',
        array(
            'settings'      => 'luzuk_breadcrumbhometxt',
            'section'       => 'luzuk_breadcrumb_settings',
            'type'          => 'text',
            'label'         => __( 'Add Breadcrumb Text Here', 'luzuk' )
        )
    );

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbbgcolor', 'luzuk_breadcrumb_settings', 'Breadcrumb Box BG Color', '#FCE097');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbtitlecolor', 'luzuk_breadcrumb_settings', 'Breadcrumb Box Current Title Color', '#F5EFD7');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbtitlebgcolor', 'luzuk_breadcrumb_settings', 'Breadcrumb Box Current Title BG Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenttitlehovercolor', 'luzuk_breadcrumb_settings', 'Breadcrumb Box Title Hover Color', '#FCE097');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenttitlecolor', 'luzuk_breadcrumb_settings', 'Breadcrumb Box Title Color', '#F5EFD7');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenttitlebgcolor', 'luzuk_breadcrumb_settings', 'Breadcrumb Box Title BG Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenttitleicncolor', 'luzuk_breadcrumb_settings', 'Breadcrumb Box Title Icon Color', '#FCE097');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbarrowicncolor', 'luzuk_breadcrumb_settings', 'Breadcrumb Box Arrow Icon Color', '#000');


// end to show & hide button

//POSTPAGEDATE SETTINGS
$wp_customize->add_section(
	'luzuk_blogpage_settings',
	array(
		'title' => __( 'Inner Blog Page Settings', 'luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);


    $wp_customize->add_setting('luzuk_premium_blog_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_blog_section_lbl',
        array(
            'settings'      => 'luzuk_premium_blog_section_lbl',
            'section'       => 'luzuk_blogpage_settings',
            'label'         => __( 'Note:', 'luzuk-premium' ),  
            'description'   => __( '<b>This section available only for PRO version</b><br>If you want this section click on <b>Go Pro</b>', 'luzuk-premium' ),
        )
    )
);

//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
	'footer_area',
	array(
		'title' => __( 'Footer Settings', 'luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

backgroundManager($wp_customize, 'footer', 'footer_area', $color='#3A3A3A', get_template_directory_uri().'/images/default-graybg.png', 'img');

lzCustomLable($wp_customize, 'footer_areaPadding', 'footer_area', 'Footer Padding');

$wp_customize->add_setting(
    'sec_footerseTmargin', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1.9em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_footerseTmargin',
    array(
        'settings'      => 'sec_footerseTmargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'sec_footersebottommargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_footersebottommargin',
    array(
        'settings'      => 'sec_footersebottommargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'footer_areabottomfPadding', 'footer_area', 'Copyright Text Box Padding');

$wp_customize->add_setting(
    'sec_bottomareaTmargin', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2.2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_bottomareaTmargin',
    array(
        'settings'      => 'sec_bottomareaTmargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'sec_bottomareabottommargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1.6em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_bottomareabottommargin',
    array(
        'settings'      => 'sec_bottomareabottommargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'footer_copytext', 'footer_area', 'Footer Copyright Text');

$wp_customize->add_setting(
    'footer_area_copyrighttext',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Copyright @ 2023 Tea Shop All Right Reserved', 'luzuk Premium' )
    )
);
$wp_customize->add_control(
    'footer_area_copyrighttext',
    array(
        'settings'      => 'footer_area_copyrighttext',
        'section'       => 'footer_area',
        'type'          => 'textarea',
        'label'         => __( 'Footer Copyright Text', 'luzuk Premium' )
    )
);

lzCustomLable($wp_customize, 'newsletterbxbg', 'footer_area', 'Newsletter Box');

lzCustomLable($wp_customize, 'newsletter_Form_label', 'footer_area', 'Newsletter Form Shortcode');

lzAddElement($wp_customize, 'luzuk_newsletter_shortcode', 'footer_area', 'textarea', $label="Form Shortcode", 'luzuk_sanitize_text', '[your shortcode]');

$wp_customize->add_setting(
    'newsletter_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Subscribe To Our Newsletter', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newsletter_title',
    array(
        'settings'      => 'newsletter_title',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Form Title', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'socialicn_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Join Us On Social Platforms', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'socialicn_title',
    array(
        'settings'      => 'socialicn_title',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Social Icon Title', 'luzuk-premium' )
    )
);

$wp_customize->add_setting('footer_facebook',   array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('footer_facebook',
    array(
        'settings'      => 'footer_facebook',
        'section'       => 'footer_area',
        'type'          => 'url',
        'label'         => __( 'Facebook Url', 'luzuk-premium' )
    )
);

$wp_customize->add_setting('footer_instagram',   array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('footer_instagram',
    array(
        'settings'      => 'footer_instagram',
        'section'       => 'footer_area',
        'type'          => 'url',
        'label'         => __( 'Instagram Url', 'luzuk-premium' )
    )
);

$wp_customize->add_setting('footer_twitter',   array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('footer_twitter',
    array(
        'settings'      => 'footer_twitter',
        'section'       => 'footer_area',
        'type'          => 'url',
        'label'         => __( 'Twitter Url', 'luzuk-premium' )
    )
);

$wp_customize->add_setting('footer_linkedin',   array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('footer_linkedin',
    array(
        'settings'      => 'footer_linkedin',
        'section'       => 'footer_area',
        'type'          => 'url',
        'label'         => __( 'Linkedin Url', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'footerarea_fmtitleclr', 'footer_area', 'Newsletter And Social Icon Title Color', '#F5EFD7');

// Footer  Color
lzCustomLable($wp_customize, 'footer_allcolor', 'footer_area', 'Footer Color');

addColorPalatOption($wp_customize, 'footerarea_copyrightbrdclr', 'footer_area', 'Border Color', '#F5EFD7');

addColorPalatOption($wp_customize, 'footerarea_title_color', 'footer_area', 'Title Color', '#FCE097');

addColorPalatOption($wp_customize, 'footerarea_text_color', 'footer_area', 'Text Color', '#F5EFD7');

addColorPalatOption($wp_customize, 'footerarea_sicon_color', 'footer_area', 'Social Icon Color', '#F5EFD7');

addColorPalatOption($wp_customize, 'footerarea_siconhv_color', 'footer_area', 'Social Icon Hover Color', '#F23C38');

addColorPalatOption($wp_customize, 'footerarea_siconbg_color', 'footer_area', 'Social Icon BG Color', '#F23C38');

addColorPalatOption($wp_customize, 'footerarea_siconbghv_clr', 'footer_area', 'Social Icon BG Hover Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_menu_color', 'footer_area', 'Menu Color', '#F5EFD7');

addColorPalatOption($wp_customize, 'footerarea_menuhover_color', 'footer_area', 'Menu Hover Color', '#F23C38');

addColorPalatOption($wp_customize, 'footerarea_activemenu_color', 'footer_area', 'Active Menu Color', '#F23C38');

addColorPalatOption($wp_customize, 'footerarea_menuicon_color', 'footer_area', 'Menu Icon Color', '#F23C38');

addColorPalatOption($wp_customize, 'footerarea_datext_color', 'footer_area', 'Date Text Color', '#fff');

addColorPalatOption($wp_customize, 'FooterAreatabgColor', 'footer_area', 'Form Text BG Color', '#F5EFD7');

addColorPalatOption($wp_customize, 'FooterAreata_brdClr', 'footer_area', 'Form Border Color', '#3A3A3A');

addColorPalatOption($wp_customize, 'footerarea_formtextlabel_color', 'footer_area', 'Label Color', '#ababab');

addColorPalatOption($wp_customize, 'footerarea_formtext_color', 'footer_area', 'Form Text & Placeholder Text Color', '#707070');

addColorPalatOption($wp_customize, 'footerarea_formbuttontext_clr', 'footer_area', 'Form Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_formbtntxthv_clr', 'footer_area', 'Form Text Hover Color', '#F23C38');

addColorPalatOption($wp_customize, 'footerarea_formbuttonbg_clr', 'footer_area', 'Form Button BG Color', '#F23C38');

addColorPalatOption($wp_customize, 'footerarea_formbuttonbghv_clr', 'footer_area', 'Form Button BG Hover Color', '#FCE097');

//SHOP PAGE SIDEBAR SETTINGS
$wp_customize->add_section(
	'luzuk_shopsidebar_settings',
	array(
		'title' => __( 'Shop Page Sidebar Settings', 'luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

// to show & hide button
$wp_customize->add_setting( 'cd_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'cd_button_display', array( 'label' => 'Shop Sidebar Display', 'section' => 'luzuk_shopsidebar_settings', 'settings' => 'cd_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show', 'hide' => 'Hide', ), ) ); 
// end to show & hide button

$wp_customize->add_section(
	'luzuk_innerpageshortcode_page_settings',
	array(
		'title' => __( 'Color Setting For Shortcode Pages', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

    $wp_customize->add_setting('luzuk_premium_colorsetting_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_colorsetting_section_lbl',
        array(
            'settings'      => 'luzuk_premium_colorsetting_section_lbl',
            'section'       => 'luzuk_innerpageshortcode_page_settings',
            'label'         => __( 'Note:', 'luzuk-premium' ),  
            'description'   => __( '<b>This section available only for PRO version</b><br>If you want this section click on <b>Go Pro</b>', 'luzuk-premium' ),
        )
    )
);


$wp_customize->add_section(
	'luzuk_innerpagefont_settings',
	array(
		'title' => __( 'Inner Page Settings', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

 $wp_customize->add_setting('luzuk_premium_innerpage_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_innerpage_section_lbl',
        array(
            'settings'      => 'luzuk_premium_innerpage_section_lbl',
            'section'       => 'luzuk_innerpagefont_settings',
            'label'         => __( 'Note:', 'luzuk-premium' ),  
            'description'   => __( '<b>This section available only for PRO version</b><br>If you want this section click on <b>Go Pro</b>', 'luzuk-premium' ),
        )
    )
);
