<?php 
    $wp_customize->add_section(
        'about_area',
        array(
            'title' => __( 'About Us Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    $wp_customize->add_setting(
        'about_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'about_area_disable',
            array(
                'settings'      => 'about_area_disable',
                'section'       => 'about_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'aboutus', 'about_area', $color='#F5EFD7', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'aboutarea_padding', 'about_area', 'Section Padding');

$wp_customize->add_setting(
    'about_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_areaTpadding',
    array(
        'settings'      => 'about_areaTpadding',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'about_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_areaBpadding',
    array(
        'settings'      => 'about_areaBpadding',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'about_image_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_image_heading',
        array(
            'settings'      => 'about_image_heading',
            'section'       => 'about_area',
            'label'         => __( 'Section Image', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'about_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'about_image',
        array(
            'section' => 'about_area',
            'settings' => 'about_image',
            'description' => __('Recommended Image Size: 390X560px', 'luzuk-premium')
        )
    )
);

$wp_customize->add_setting(
    'about_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_title_heading',
        array(
            'settings'      => 'about_title_heading',
            'section'       => 'about_area',
            'label'         => __( ' Section Heading & text', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'about_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'The result is a smooth and semi-solid foam', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_title',
    array(
        'settings'      => 'about_title',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Heading', 'luzuk-premium' )
    )
);


$wp_customize->add_setting(
    'about_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Maecenas congue porta tellus a sollicitudin. Etiam sit amet ligula eu arcu ullamcorper eleifend. Sed aliquet ligula sapien, eu malesuada mi lobortis pulvinar. Maecenas feugiat est turpis, nec pretium libero volutpat dictum. Morbi ultrices elit vel nibh vehicula maximus. Pellentesque eget arcu eget justo tincidunt ultrices.' )
    )
);
$wp_customize->add_control(
    'about_text',
    array(
        'settings'      => 'about_text',
        'section'       => 'about_area',
        'type'          => 'textarea',
        'label'         => __( 'Text', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'abtbtn', 'about_area' , 'Section Button');

$wp_customize->add_setting(
    'abtbtntxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Show More' )
    )
);
$wp_customize->add_control(
    'abtbtntxt',
    array(
        'settings'      => 'abtbtntxt',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);
$wp_customize->add_setting('abtbtnlink',   array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('abtbtnlink',
    array(
        'settings'      => 'abtbtnlink',
        'section'       => 'about_area',
        'type'          => 'url',
        'label'         => __( 'Add Button Link', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'Sec_abtclor', 'about_area' , 'About Section Color');

addColorPalatOption($wp_customize, 'about_area_bxbg', 'about_area', 'About Box BG Color', '#FCE097');

addColorPalatOption($wp_customize, 'about_area_bxbrdclr', 'about_area', 'Image Border Color', '#F5EFD7');

addColorPalatOption($wp_customize, 'about_area_sectitle_clr', 'about_area', 'Heading Color ', '#F23C38');

addColorPalatOption($wp_customize, 'about_area_text', 'about_area', 'Text Color', '#3A3A3A');

addColorPalatOption($wp_customize, 'about_area_btntext', 'about_area', 'Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'about_area_btnbg', 'about_area', 'Button BG Color', '#F23C38');
