<?php
// START CONTACT SECTION 
$wp_customize->add_section(
	'appoi_section',
	array(
		'title'         => __( 'Appointment Section', 'Luzuk Premium' ), 
		'panel'   => 'luzuk_premium_home_panel',
	)
);
    //ENABLE/DISABLE CONTACT SECTION
$wp_customize->add_setting(
	'appoi_disable',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'appoi_disable',
		array(
			'settings'      => 'appoi_disable',
			'section'       => 'appoi_section',
			'label'         => __( 'Disable Section', 'Luzuk Premium' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'Luzuk Premium' ),
				'off' => __( 'No', 'Luzuk Premium' )
			)   
		)
	)
);


backgroundManager($wp_customize, 'appointment', 'appoi_section', $color='#F5EFD7', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'appoi_sectionnpadding', 'appoi_section', 'Section Padding ');

$wp_customize->add_setting(
    'appoinmentsection_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2.6em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'appoinmentsection_toppadding',
    array(
        'settings'      => 'appoinmentsection_toppadding',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Top ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'appoinmentsection_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'appoinmentsection_bottompadding',
    array(
        'settings'      => 'appoinmentsection_bottompadding',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Bottom ', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'app_detailbg', 'appoi_section', 'Section Left Box');

$wp_customize->add_setting(
    'appheading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Connect with Us Using Our Contact Form' )
    )
);
$wp_customize->add_control(
    'appheading',
    array(
        'settings'      => 'appheading',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Heading', 'Luzuk' )
    )
);

$wp_customize->add_setting(
    'appsubheading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Suspendisse varius, felis non ornare vulputate, ex lorem vestibulum tortor, in tempor eros est et enim. Vestibulum lobortis luctus purus, sit amet gravida nibh mattis ac.' )
    )
);
$wp_customize->add_control(
    'appsubheading',
    array(
        'settings'      => 'appsubheading',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Text', 'Luzuk' )
    )
);


$wp_customize->add_setting(
    'infphtxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '+111 6767 890' )
    )
);
$wp_customize->add_control(
    'infphtxt',
    array(
        'settings'      => 'infphtxt',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Phone Number 1', 'Luzuk' )
    )
);

$wp_customize->add_setting(
    'infphtx2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '+222 3456 892' )
    )
);
$wp_customize->add_control(
    'infphtx2',
    array(
        'settings'      => 'infphtx2',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Phone Number 2', 'Luzuk' )
    )
);


$wp_customize->add_setting(
    'infemiltxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'info@icecreammail.com' )
    )
);
$wp_customize->add_control(
    'infemiltxt',
    array(
        'settings'      => 'infemiltxt',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Email Id', 'Luzuk' )
    )
);

$wp_customize->add_setting(
    'inftxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '63 S Hamilton Pl Gilbert Arkansas 85233 United States' )
    )
);
$wp_customize->add_control(
    'inftxt',
    array(
        'settings'      => 'inftxt',
        'section'       => 'appoi_section',
        'type'          => 'textarea',
        'label'         => __( 'Address Text', 'Luzuk' )
    )
);

lzCustomLable($wp_customize, 'app_dlhsbcclr', 'appoi_section', 'Left Side Box Color');

addColorPalatOption($wp_customize, 'app_secheadingclr', 'appoi_section', 'Heading Color', '#3A3A3A');

addColorPalatOption($wp_customize, 'inquiry_lftboxsubheadingclr', 'appoi_section', 'Text Color', '#707070');

// phone
lzCustomLable($wp_customize, 'app_dlhsphclr', 'appoi_section', 'Field Color');

addColorPalatOption($wp_customize, 'inquiry_boxbgclr', 'appoi_section', 'Box BG Color', '#FCE097');

addColorPalatOption($wp_customize, 'inquiry_btntxticnclr', 'appoi_section', 'Icon Color', '#FCE097');

addColorPalatOption($wp_customize, 'inquiry_btntxticnbgclr', 'appoi_section', 'Icon BG Color', '#F23C38');

addColorPalatOption($wp_customize, 'inquiry_btntxtclr', 'appoi_section', 'Phone No, Email And Address Text Color', '#3A3A3A');

addColorPalatOption($wp_customize, 'inquiry_btntxthvclr', 'appoi_section', 'Phone No And Email Text Hover Color', '#F23C38');

lzCustomLable($wp_customize, 'app_detailrghtbg', 'appoi_section', 'Section Right Box');

lzCustomLable($wp_customize, 'app-secheading', 'appoi_section', 'Form Heading ');

$wp_customize->add_setting(
    'appform_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Contact Us', 'luzuk' )
    )
);
$wp_customize->add_control(
    'appform_maintitle',
    array(
        'settings'      => 'appform_maintitle',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Form Heading ', 'luzuk' )
    )
);

addColorPalatOption($wp_customize, 'inquiry_lftboxheadingclr', 'appoi_section', 'Form Heading Color', '#3A3A3A');

// ===========Form Section ==========//

lzCustomLable($wp_customize, 'contactf', 'appoi_section', 'Form Section');


lzCustomLable($wp_customize, 'appointmentright_Form_label', 'appoi_section', 'Contact Inquiry Form Shortcode');

lzAddElement($wp_customize, 'luzuk_inquiry_shortcode', 'appoi_section', 'textarea', $label="Form Shortcode", 'luzuk_sanitize_text', '[your shortcode]');

addColorPalatOption($wp_customize, 'inquiry_formbxbgClr', 'appoi_section', 'Right Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'inquiry_formbxbrdClr', 'appoi_section', 'Right Box Border Color', '#FCE097');

addColorPalatOption($wp_customize, 'inquiry_forminputtxtClr', 'appoi_section', 'Form Input Text / Placeholder Color', '#3A3A3A');

addColorPalatOption($wp_customize, 'inquiry_forminputtxbgtClr', 'appoi_section', 'Form Input Placeholder BG Color', '#FCE097');

addColorPalatOption($wp_customize, 'inquiry_forminputbgColor', 'appoi_section', 'Form Input Border Color', '#3A3A3A');

addColorPalatOption($wp_customize, 'inquiry_formlabelColor', 'appoi_section', 'Form Label Color', '#000');

addColorPalatOption($wp_customize, 'inquiry_formbuttontextColor', 'appoi_section', 'Form Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'inquiry_formbuttontexthoverColor', 'appoi_section', 'Form Button Text Hover Color', '#F23C38');

addColorPalatOption($wp_customize, 'inquiry_formbuttonbgColor', 'appoi_section', 'Form Button BG Color', '#F23C38');

addColorPalatOption($wp_customize, 'inquiry_formbuttonbghoverColor', 'appoi_section', 'Form Button BG Hover Color', '#3A3A3A');