<?php 
    $wp_customize->add_section(
        'features_area',
        array(
            'title' => __( 'Feature Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );

    $wp_customize->add_setting(
        'features_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'features_area_disable',
            array(
                'settings'      => 'features_area_disable',
                'section'       => 'features_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'featuresus', 'features_area', $color='#F5EFD7', get_template_directory_uri().'/images/default.png', 'img');

lzCustomLable($wp_customize, 'featuresarea_padding', 'features_area', 'Section Padding');

$wp_customize->add_setting(
    'features_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'features_areaTpadding',
    array(
        'settings'      => 'features_areaTpadding',
        'section'       => 'features_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'features_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'features_areaBpadding',
    array(
        'settings'      => 'features_areaBpadding',
        'section'       => 'features_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'fea_maintitle_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'fea_maintitle_subtitle_heading',
        array(
            'settings'      => 'fea_maintitle_subtitle_heading',
            'section'       => 'features_area',
            'label'         => __( 'Section Heading', 'luzuk' ),
        )
    )
);

$wp_customize->add_setting(
    'fea_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Explore the Exquisite Features of Our Ice Cream Collection', 'luzuk' )
    )
);
$wp_customize->add_control(
    'fea_maintitle',
    array(
        'settings'      => 'fea_maintitle',
        'section'       => 'features_area', 
        'type'          => 'text',
        'label'         => __( 'Heading', 'luzuk' )
    )
);

$wp_customize->add_setting(
    'fea_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Suspendisse consectetur nec urna et feugiat. Sed venenatis efficitur sem at suscipit. Nunc maximus semper gravida. Morbi ornare egestas aliquam.', 'luzuk' )
    )
);
$wp_customize->add_control(
    'fea_text',
    array(
        'settings'      => 'fea_text',
        'section'       => 'features_area', 
        'type'          => 'text',
        'label'         => __( 'Text', 'luzuk' )
    )
);

$wp_customize->add_setting(
    'fea_btn',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Show More', 'luzuk' )
    )
);
$wp_customize->add_control(
    'fea_btn',
    array(
        'settings'      => 'fea_btn',
        'section'       => 'features_area', 
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk' )
    )
);

$wp_customize->add_setting('feabtnlink',   array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('feabtnlink',
    array(
        'settings'      => 'feabtnlink',
        'section'       => 'features_area',
        'type'          => 'url',
        'label'         => __( 'Add Button Link', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'features_area_heading', 'features_area', 'Heading Color', '#3A3A3A');

addColorPalatOption($wp_customize, 'features_area_text', 'features_area', 'Text Color', '#707070');

addColorPalatOption($wp_customize, 'features_area_btntext', 'features_area', 'Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'features_area_btnbg', 'features_area', 'Button BG Color', '#F23C38');

addColorPalatOption($wp_customize, 'features_area_bxrghtbrdclr', 'features_area', 'Box Right Border Color', '#F23C38');

$wp_customize->add_setting('featuresus_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'featuresus_npp_heading',
        array(
            'settings'      => 'featuresus_npp_heading',
            'section'       => 'features_area',
            'label'         => __( 'Number Of Feature Box ', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('featuresus_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control(
    'featuresus_npp_count',
    array(
        'settings'      => 'featuresus_npp_count',
        'section'       => 'features_area',
        'type'          => 'select',
        'label'         => __( 'Number Of Feature Box To Show ', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8)
    )
);

//features PAGES
for( $i = 1; $i <= 8; $i++ ){
    $wp_customize->add_setting(
        'featuresus_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'featuresus_header'.$i,
            array(
                'settings'      => 'featuresus_header'.$i,
                'section'       => 'features_area',
                'label'         => __( 'Feature Box ', 'luzuk-premium' ).$i
            )
        )
    );

     $wp_customize->add_setting(
        'featuresus_page_icon'.$i,
        array(
            'default'           => 'fa fa-glass',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'featuresus_page_icon'.$i,
            array(
                'settings'      => 'featuresus_page_icon'.$i,
                'section'       => 'features_area',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'luzuk-premium' ),
            )
        )
    );

lzAddElement($wp_customize, 'featuresus_page_title'.$i, 'features_area', $type = 'text', $label="Title", $callback ='luzuk_sanitize_text', $default='Flavor Variety');

lzAddElement($wp_customize, 'featuresus_page_text'.$i, 'features_area', $type = 'textarea', $label="Text", $callback ='luzuk_sanitize_text', $default='Collect cream, milk, sugar, and flavorings (vanilla extract, cocoa, fruit, etc.).');

lzAddElement($wp_customize, 'luzuk_features_page_url_'.$i, 'features_area', $type = 'text', $label=" Link", $callback ='esc_url', $default='Add link here');

}

lzCustomLable($wp_customize, 'featuresarea_clr', 'features_area', 'Features Section Color');

// icon bg
addColorPalatOption($wp_customize, 'features_area_pageicon', 'features_area', 'Icon Color ', '#000');

addColorPalatOption($wp_customize, 'features_area_pageiconbg', 'features_area', 'Icon BG Color ', '#fff');

addColorPalatOption($wp_customize, 'features_area_pageiconbrd', 'features_area', 'Icon Border Color ', '#FCE097');

addColorPalatOption($wp_customize, 'features_area_pagenum', 'features_area', 'Number Color ', '#F23C38');

addColorPalatOption($wp_customize, 'features_area_pagetitle', 'features_area', 'Title Color', '#F23C38');

addColorPalatOption($wp_customize, 'features_textclr', 'features_area', 'Text Color', '#707070');