<?php
$wp_customize->add_section(
    'products_section',
    array(
        'title' => __( 'Feature Products Section', 'Luzuk' ), 
        'panel' => 'luzuk_premium_home_panel'
    )
);
$wp_customize->add_setting(
    'products_section_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);

$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'products_section_disable',
        array(
            'settings'      => 'products_section_disable',
            'section'       => 'products_section',
            'label'         => __( 'Disable Section', 'Luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'Luzuk' ), 
                'off' => __( 'No', 'Luzuk' )
            ),
        )
    )
);

backgroundManager($wp_customize, 'productsec', 'products_section', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'featureproductsection_padding', 'products_section', ' Section Padding');

$wp_customize->add_setting(
    'productssec_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3em', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'productssec_toppadding',
    array(
        'settings'      => 'productssec_toppadding',
        'section'       => 'products_section',
        'type'          => 'text',
        'label'         => __( 'Top', 'Luzuk' )
    )
);
$wp_customize->add_setting(
    'productssec_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1em', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'productssec_bottompadding',
    array(
        'settings'      => 'productssec_bottompadding',
        'section'       => 'products_section',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'Luzuk' )
    )
);

$wp_customize->add_setting('productssectionimgheight_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'productssectionimgheight_lbl',
        array(
            'settings'      => 'productssectionimgheight_lbl',
            'section'       => 'products_section',
            'label'         => __( 'Note:', 'Luzuk' ),  
            'description'   => __( 'Kindly Add Feature Products Images of Same Resolution', 'Luzuk' ),
        )
    )
);

$wp_customize->add_setting(
    'featured_product_title_sub_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'featured_product_title_sub_title_heading',
        array(
            'settings'      => 'featured_product_title_sub_title_heading',
            'section'       => 'products_section',
            'label'         => __( 'Section Heading', 'Luzuk' ),
        )
    )
);    

$wp_customize->add_setting(
    'product_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Indulge in Bliss with Our Featured Ice Cream Extravaganza', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'product_title',
    array(
        'settings'      => 'product_title',
        'section'       => 'products_section',
        'type'          => 'text',
        'label'         => __( 'Heading', 'Luzuk' )
    )
);


addColorPalatOption($wp_customize, 'products_subheadClr', 'products_section', 'Heading Color ', '#3A3A3A');

lzCustomLable($wp_customize, 'product_color', 'products_section', ' Section Color');

addColorPalatOption($wp_customize, 'products_bxbgclr', 'products_section', 'Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'products_bxborderclr', 'products_section', 'Box Border Color', '#FCE097');

addColorPalatOption($wp_customize, 'products_imghvclr', 'products_section', 'Image Hover Color', '#FCE097');

addColorPalatOption($wp_customize, 'products_bxbrdclr', 'products_section', 'Image Border Color', '#b1adad');

addColorPalatOption($wp_customize, 'products_titlclr', 'products_section', 'Product Title Color', '#3A3A3A');

addColorPalatOption($wp_customize, 'products_priceclr', 'products_section', 'Selling Price Color', '#000');

addColorPalatOption($wp_customize, 'products_carticonclr', 'products_section', 'Cart Icon Color', '#fff');

addColorPalatOption($wp_customize, 'products_carticonbgclr', 'products_section', 'Cart Icon BG Color', '#F23C38');
 