<?php 
    $wp_customize->add_section(
        'selling_area',
        array(
            'title' => __( 'Best Selling Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );

    $wp_customize->add_setting(
        'selling_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'selling_area_disable',
            array(
                'settings'      => 'selling_area_disable',
                'section'       => 'selling_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'sellingus', 'selling_area', $color='#F5EFD7', get_template_directory_uri().'/images/default.png', 'img');

lzCustomLable($wp_customize, 'sellingarea_padding', 'selling_area', 'Section Padding');

$wp_customize->add_setting(
    'selling_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'selling_areaTpadding',
    array(
        'settings'      => 'selling_areaTpadding',
        'section'       => 'selling_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'selling_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'selling_areaBpadding',
    array(
        'settings'      => 'selling_areaBpadding',
        'section'       => 'selling_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'feature_heading', 'selling_area', 'Section Heading');

$wp_customize->add_setting(
        'selling_title',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Best-Selling Ice Cream Delights That Never Fail to Impress', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'selling_title',
        array(
            'settings'      => 'selling_title',
            'section'       => 'selling_area',
            'type'          => 'text',
            'label'         => __( 'Heading', 'luzuk-premium' )
        )
    );

lzCustomLable($wp_customize, 'sellingarea_clr', 'selling_area', 'Selling Product Color Setting');

addColorPalatOption($wp_customize, 'selling_area_headingClr', 'selling_area', 'Heading Color', '#3A3A3A');

addColorPalatOption($wp_customize, 'selling_area_imghvClr', 'selling_area', 'Image Hover Color', '#fff');

addColorPalatOption($wp_customize, 'selling_area_pagetitle', 'selling_area', 'Product Title Color', '#3A3A3A');

addColorPalatOption($wp_customize, 'selling_area_priceClr', 'selling_area', 'Product Price And Cart Icon Color', '#3A3A3A');

addColorPalatOption($wp_customize, 'selling_area_pricebgClr', 'selling_area', 'Product Price And Cart Icon BG Color', '#FCE097');

addColorPalatOption($wp_customize, 'selling_area_carttxtClr', 'selling_area', 'Product Cart Button Text Color', '#F23C38');

addColorPalatOption($wp_customize, 'selling_area_carttxtbgClr', 'selling_area', 'Product Cart Button BG Color', '#fff');

addColorPalatOption($wp_customize, 'selling_area_arrowiconClr', 'selling_area', 'Slider Arrow Icon Color', '#F23C38');

addColorPalatOption($wp_customize, 'selling_area_arrowiconbgClr', 'selling_area', 'Slider Arrow Icon BG Color', '#fff');

addColorPalatOption($wp_customize, 'selling_area_arrowiconbrdClr', 'selling_area', 'Slider Arrow Hover Border Color', '#F23C38');