<?php 
	if(get_theme_mod('products_section_disable') != 'on' ){
?>
<?php 
	if( get_theme_mod('productssec_toppadding',true) ) {
		$productssec_toppadding = 'padding-top:'.esc_attr(get_theme_mod('productssec_toppadding')).';';
	}
	if( get_theme_mod('productssec_bottompadding',true) ) {
		$productssec_bottompadding = 'padding-bottom:'.esc_attr(get_theme_mod('productssec_bottompadding')).';';
	}

?>   
<section id="product-section" class="ht-section" style="<?php echo esc_attr($productssec_toppadding); ?>" "<?php echo esc_attr($productssec_bottompadding); ?>">
	<div class="container">
		<?php
			$showStatic = true;
			for( $i = 1; $i < 4; $i++ ){
				$luzuk_featured_page_id = get_theme_mod('luzuk_featured_page'.$i); 
				if(!empty($luzuk_featured_page_id)){
					$showStatic = false;
					break;
				}
			}
		?>
		<?php
			$product_title = get_theme_mod('product_title', 'Indulge in Bliss with Our Featured Ice Cream Extravaganza');	
		?>
		<?php if($product_title){ ?> 
	        <div class="section-title">
	            <h2><span><?php echo ($product_title);  ?></span></h2>
	        </div>
        <?php }?>
		<div class="row">
			<?php
				if(function_exists('woocommerce_template_loop_add_to_cart') && function_exists('WC')){
					$args = array( 'post_type' => 'product', 'stock' => 1, 'posts_per_page' => 4, 'orderby' =>'date','order' => 'DESC' );
					$meta_query   = WC()->query->get_meta_query();
					$tax_query   = WC()->query->get_tax_query();
					$tax_query[] = array(
						'taxonomy' => 'product_visibility',
						'field'    => 'name',
						'terms'    => 'featured',
						'operator' => 'IN',
					);
					$args = array(
						'post_type'   =>  'product',
						'stock'       =>  1,
						'posts_per_page' => -1, 
						'orderby'     =>  'date',
						'order'       =>  'DESC',
						'meta_query'  =>  $meta_query,
						'tax_query'   => $tax_query,
					);
					$loop = new WP_Query( $args );
					if($loop->post_count > 0){
					while ( $loop->have_posts() ) : $loop->the_post(); global $product; ?>

					<div class="col-xl-3 col-lg-3 col-md-4 col-sm-6 product-bx wow zoomIn"> 
						<div class="product-grid">
							<div class="product-cntbx">
								<a id="id-<?php the_id(); ?>" href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
									<div class="product-image">
										<div class="product-area">
											<div class="img-ovly"></div>
											<?php if (has_post_thumbnail( $loop->post->ID )) 
											echo get_the_post_thumbnail($loop->post->ID, 'shop_catalog');
											else
												echo '<img class="attachment-shop_catalog" src="'.get_template_directory_uri().'/images/default.png" alt="Placeholder"  />'; ?>
											<div class="meltbox">
												 <div class="melt"></div>
											</div>
										</div>
									</div>
								</a>
								<div class="product-content">
									<div class="products-title">
										<a class="add-to-cart" id="id-<?php the_id(); ?>" href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">	
											<h3 class="title inner-area-title"><?php the_title(); ?></h3>
										</a>
									</div>
									<div class="cart-button">
										<li>
											<?php echo $product->get_price_html(); ?>
										</li>
										<li>
											<?php
					    						$product->is_icon = true;
					    						woocommerce_template_loop_add_to_cart( $product );
					    					?>	
										</li>					
									</div>
									<div class="clearfix"></div>
								</div>
							</div>
						</div>
					</div>
				<?php
					endwhile; 
				}else{ ?>
					<div class="alert alert-warning text-center">
						<strong>Sorry, no featured products to show.</strong>
					</div>
					<?php } ?>
					<?php
						wp_reset_query(); 
					}else{ ?>
				<div class="alert alert-warning text-center">
					Kindly Install or Activate the WooCommerce plugin.
				</div>
			<?php
			}?>
		</div>
	</div>
	<div class="clearfix"></div>
</section>
<script>
        var maxHeight = -1,
        elems = document.querySelectorAll("#product-section .products-title");
        elems = [].slice.call(elems) // Now a true Array

        elems.forEach(function(e){
            maxHeight = Math.max(maxHeight, e.offsetHeight);
        });

        elems.forEach(function(e){
            e.style.height = maxHeight + "px";
        });

    </script>
<?php } 
