<?php
$wp_customize->add_section(
    'banner2_section',
    array(
        'title' => __( 'Banner Section', 'Luzuk' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);

$wp_customize->add_setting(
    'banner2_section_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'banner2_section_disable',
        array(
            'settings'      => 'banner2_section_disable',
            'section'       => 'banner2_section',
            'label'         => __( 'Disable/ Enable Section', 'Luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'Luzuk' ),
                'off' => __( 'No', 'Luzuk' )
            ),
        )
    )
);


BackgroundManager($wp_customize, 'banner2', 'banner2_section', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'sec_banner2padding', 'banner2_section', 'Section Padding');

$wp_customize->add_setting(
    'banner2_Tpadding', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'banner2_Tpadding',
    array(
        'settings'      => 'banner2_Tpadding',
        'section'       => 'banner2_section',
        'type'          => 'text',
        'label'         => __( 'Top', 'Luzuk' )
    )
);
$wp_customize->add_setting(
    'banner2_Bpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'banner2_Bpadding',
    array(
        'settings'      => 'banner2_Bpadding',
        'section'       => 'banner2_section',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'Luzuk' )
    )
);

lzCustomLable($wp_customize, 'sec_banner2innimg', 'banner2_section', 'Section Inside Box ');

addColorPalatOption($wp_customize, 'banner2_insbxbgclr', 'banner2_section', 'Inside Box BG Color', '#FFE8E8'); 

$wp_customize->add_setting(
    'banner2_lhsimage_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);

$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'banner2_lhsimage_heading',
        array(
            'settings'      => 'banner2_lhsimage_heading',
            'section'       => 'banner2_section',
            'label'         => __( 'Section Left Image', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'banner2_lhsimage',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'banner2_lhsimage',
        array(
            'section' => 'banner2_section',
            'settings' => 'banner2_lhsimage',
            'description' => __('Recommended Image Size: 330X270px', 'luzuk-premium')
        )
    )
);

$wp_customize->add_setting(
    'banner2_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'banner2_title_heading',
        array(
            'settings'      => 'banner2_title_heading',
            'section'       => 'banner2_section',
            'label'         => __( 'Section Sub Heading , Heading ', 'Luzuk' ),
        )
    )
);  


$wp_customize->add_setting(
    'banner2_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'New Furniture Design', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'banner2_subtitle',
    array(
        'settings'      => 'banner2_subtitle',
        'section'       => 'banner2_section',
        'type'          => 'text',
        'label'         => __( 'Section Sub Heading ', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'banner2_subheadclr', 'banner2_section', 'Sub Heading Color', '#010101'); 


$wp_customize->add_setting(
    'banner2_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'SPECIAL OFFER', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'banner2_title',
    array(
        'settings'      => 'banner2_title',
        'section'       => 'banner2_section',
        'type'          => 'text',
        'label'         => __( 'Section Heading ', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'banner2_headclr', 'banner2_section', 'Heading Color', '#010101'); 


$wp_customize->add_setting(
    'banner2_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Nullam nec magna ac sapien suscipit scelerisque ac rutrum erat. ', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'banner2_text',
    array(
        'settings'      => 'banner2_text',
        'section'       => 'banner2_section',
        'type'          => 'textarea',
        'label'         => __( 'Section Text ', 'Luzuk' )
    )
); 

addColorPalatOption($wp_customize, 'banner2_textclr', 'banner2_section', 'Text Color', '#707070'); 

$wp_customize->add_setting(
    'btn_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Shop Now', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'btn_text',
    array(
        'settings'      => 'btn_text',
        'section'       => 'banner2_section',
        'type'          => 'text',
        'label'         => __( 'Button Text ', 'Luzuk' )
    )
);

$wp_customize->add_setting('banner2_btnlink',   
    array('default'=> 'Add Link', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('banner2_btnlink',
    array(
        'settings'      => 'banner2_btnlink',
        'section'       => 'banner2_section',
        'type'          => 'url',
        'label'         => __( 'Button Link ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'banner2_btntxtclr', 'banner2_section', 'Button Text Color', '#B05D5D'); 

addColorPalatOption($wp_customize, 'banner2_btntxthvclr', 'banner2_section', 'Button Text Hover Color', '#fff'); 

addColorPalatOption($wp_customize, 'banner2_btnbgclr', 'banner2_section', 'Button BG Color', '#fff'); 

addColorPalatOption($wp_customize, 'banner2_btnbghvclr', 'banner2_section', 'Button BG Hover Color', '#B05D5D'); 

addColorPalatOption($wp_customize, 'banner2_btnbrdclr', 'banner2_section', 'Button BorderColor', '#B05D5D'); 


$wp_customize->add_setting(
    'banner2_rhsimage_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);

$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'banner2_rhsimage_heading',
        array(
            'settings'      => 'banner2_rhsimage_heading',
            'section'       => 'banner2_section',
            'label'         => __( 'Section Left Image', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'banner2_rhsimage',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'banner2_rhsimage',
        array(
            'section' => 'banner2_section',
            'settings' => 'banner2_rhsimage',
            'description' => __('Recommended Image Size: 330X420px', 'luzuk-premium')
        )
    )
);
