<?php 
    $wp_customize->add_section(
        'newarrival_area',
        array(
            'title' => __( 'New Arrival Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );

    $wp_customize->add_setting(
        'newarrival_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'newarrival_area_disable',
            array(
                'settings'      => 'newarrival_area_disable',
                'section'       => 'newarrival_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 


backgroundManager($wp_customize, 'newarrivalus', 'newarrival_area', $color='#fff', get_template_directory_uri().'/images/default.png', 'img');

lzCustomLable($wp_customize, 'newarrivalarea_padding', 'newarrival_area', 'Section Padding');

$wp_customize->add_setting(
    'newarrival_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newarrival_areaTpadding',
    array(
        'settings'      => 'newarrival_areaTpadding',
        'section'       => 'newarrival_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'newarrival_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newarrival_areaBpadding',
    array(
        'settings'      => 'newarrival_areaBpadding',
        'section'       => 'newarrival_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'newarrival_heading', 'newarrival_area', 'Section Heading');

$wp_customize->add_setting(
        'newarrival_title',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'New Arrival From Novart', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'newarrival_title',
        array(
            'settings'      => 'newarrival_title',
            'section'       => 'newarrival_area',
            'type'          => 'text',
            'label'         => __( 'Heading', 'luzuk-premium' )
        )
    );

addColorPalatOption($wp_customize, 'newarrival_area_headingClr', 'newarrival_area', 'Heading Color', '#010101');

lzCustomLable($wp_customize, 'newarrivalbtn', 'newarrival_area' , 'Section Top Button');

$wp_customize->add_setting(
    'narivlbtntxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'See All' )
    )
);
$wp_customize->add_control(
    'narivlbtntxt',
    array(
        'settings'      => 'narivlbtntxt',
        'section'       => 'newarrival_area',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);

$wp_customize->add_setting('narivlbtnlink',   array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('narivlbtnlink',
    array(
        'settings'      => 'narivlbtnlink',
        'section'       => 'newarrival_area',
        'type'          => 'url',
        'label'         => __( 'Button Link', 'luzuk-premium' )
    )
);
addColorPalatOption($wp_customize, 'narivl_tptxtClr', 'newarrival_area', 'Top Button Text Color', '#B05D5D');

addColorPalatOption($wp_customize, 'narivl_tptxthvClr', 'newarrival_area', 'Top Button Text Hover Color', '#fff');

addColorPalatOption($wp_customize, 'narivl_tpbtnbgClr', 'newarrival_area', 'Top Button BG Color', '#FFE8E8');

addColorPalatOption($wp_customize, 'narivl_tpbtnbghvClr', 'newarrival_area', 'Top Button BG Hover Color', '#b46463');

addColorPalatOption($wp_customize, 'narivl_tpbtntxtbrdClr', 'newarrival_area', 'Top Button Border Color', '#b46463');


lzCustomLable($wp_customize, 'newarrivalarea_clr', 'newarrival_area', 'Section Color');

addColorPalatOption($wp_customize, 'newarrival_area_pagetitle', 'newarrival_area', 'Product Title Color', '#010101');

addColorPalatOption($wp_customize, 'newarrival_area_salepriceClr', 'newarrival_area', 'Product Price Color ', '#B05D5D');
