<?php
$wp_customize->add_section(
    'newsletter_area',
    array(
        'title' => __('Newsletter Section', 'luzuk-premium' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);
$wp_customize->add_setting(
    'newsletter_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);

$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'newsletter_area_disable',
        array(
            'settings'      => 'newsletter_area_disable',
            'section'       => 'newsletter_area',
            'label'         => __( 'Disable Section', 'luzuk-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk-premium' ),
                'off' => __( 'No', 'luzuk-premium' )
            ),
        )
    )
);

backgroundManager($wp_customize, 'newsletter', 'newsletter_area', $color='#fff', get_template_directory_uri().'/images/newsbg.jpg', 'color');


lzCustomLable($wp_customize, 'newsletterarea_padding', 'newsletter_area', 'Section Padding');

$wp_customize->add_setting(
    'newsletter_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newsletter_areaTpadding',
    array(
        'settings'      => 'newsletter_areaTpadding',
        'section'       => 'newsletter_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'newsletter_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newsletter_areaBpadding',
    array(
        'settings'      => 'newsletter_areaBpadding',
        'section'       => 'newsletter_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'newsletterarea_overlay', 'newsletter_area', 'Section Overlay');

$wp_customize->add_setting(
    'newsletter_Opacity',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.76', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newsletter_Opacity',
    array(
        'settings'      => 'newsletter_Opacity',
        'section'       => 'newsletter_area',
        'type'          => 'text',
        'label'         => __( 'Opacity', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'newsletter_olyclr', 'newsletter_area', 'Image Overlay Color', '#B05D5D');

$wp_customize->add_setting(
    'news_lhsimage_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);

$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'news_lhsimage_heading',
        array(
            'settings'      => 'news_lhsimage_heading',
            'section'       => 'newsletter_area',
            'label'         => __( 'Section Left Image', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'news_lhsimage',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'news_lhsimage',
        array(
            'section' => 'newsletter_area',
            'settings' => 'news_lhsimage',
            'description' => __('Recommended Image Size: 520X230px', 'luzuk-premium')
        )
    )
);

$wp_customize->add_setting(
    'newsletter_page_maintitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'newsletter_page_maintitle_heading',
        array(
            'settings'      => 'newsletter_page_maintitle_heading',
            'section'       => 'newsletter_area',
            'label'         => __( 'Section Heading', 'luzuk-premium' ),
        )
    )
);    
 

$wp_customize->add_setting(
    'newsletter_page_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Subscribe To Our Newsletter', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newsletter_page_maintitle',
    array(
        'settings'      => 'newsletter_page_maintitle',
        'section'       => 'newsletter_area',
        'type'          => 'text',
        'label'         => __( 'Section Heading ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'newsletterarea_Headingclr', 'newsletter_area', 'Heading Color', '#fff');

addColorPalatOption($wp_customize, 'newsletterarea_Headingbrdclr', 'newsletter_area', 'Heading Border Color', '#fff');



lzCustomLable($wp_customize, 'newsletter_Form_label', 'newsletter_area', 'Newsletter Form Shortcode');

lzAddElement($wp_customize, 'newsletter_shortcode', 'newsletter_area', 'textarea', $label="Form Shortcode", 'luzuk_sanitize_text', '[your shortcode]');

addColorPalatOption($wp_customize, 'newsletter_forminputbgColor', 'newsletter_area', 'Form Input BG Color', '#fff');

addColorPalatOption($wp_customize, 'newsletter_forminputbrdClr', 'newsletter_area', 'Form Input Border Color', '#707070');

addColorPalatOption($wp_customize, 'newsletter_forminputtextColor', 'newsletter_area', 'Form Input Text / Placeholder Color', '#A4A0A0');

addColorPalatOption($wp_customize, 'newsletter_formlabelColor', 'newsletter_area', 'Form Label Color', '#101a37');

addColorPalatOption($wp_customize, 'newsletter_formbuttontextColor', 'newsletter_area', 'Form Button Text Color', '#B05D5D');

addColorPalatOption($wp_customize, 'newsletter_formbuttontexthvClr', 'newsletter_area', 'Form Button Text Hover Color', '#fff');

addColorPalatOption($wp_customize, 'newsletter_formbuttonbgColor', 'newsletter_area', 'Form Button BG Color', '#FFE8E8');

addColorPalatOption($wp_customize, 'newsletter_formbuttonbgHVColor', 'newsletter_area', 'Form Button BG Hover Color', '#B05D5D');

$wp_customize->add_setting(
    'news_rhsimage_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);

$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'news_rhsimage_heading',
        array(
            'settings'      => 'news_rhsimage_heading',
            'section'       => 'newsletter_area',
            'label'         => __( 'Section Right Image', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'news_rhsimage',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'news_rhsimage',
        array(
            'section' => 'newsletter_area',
            'settings' => 'news_rhsimage',
            'description' => __('Recommended Image Size: 540X160px', 'luzuk-premium')
        )
    )
);