<?php 
    $wp_customize->add_section(
        'selling_area',
        array(
            'title' => __( 'Best Selling Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );

    $wp_customize->add_setting(
        'selling_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'selling_area_disable',
            array(
                'settings'      => 'selling_area_disable',
                'section'       => 'selling_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'sellingus', 'selling_area', $color='#fff', get_template_directory_uri().'/images/default.png', 'img');

lzCustomLable($wp_customize, 'sellingarea_padding', 'selling_area', 'Section Padding');

$wp_customize->add_setting(
    'selling_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'selling_areaTpadding',
    array(
        'settings'      => 'selling_areaTpadding',
        'section'       => 'selling_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'selling_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'selling_areaBpadding',
    array(
        'settings'      => 'selling_areaBpadding',
        'section'       => 'selling_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);
//
//lzCustomLable($wp_customize, 'feature_secwidth', 'selling_area', 'Section Width Option');

//--------------------------------theme-width-options------------------------------


lzCustomLable($wp_customize, 'feature_heading', 'selling_area', 'Section Heading');

$wp_customize->add_setting(
    'selling_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Best Sellers From Novart', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'selling_title',
    array(
        'settings'      => 'selling_title',
        'section'       => 'selling_area',
        'type'          => 'text',
        'label'         => __( 'Heading', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'selling_area_headingClr', 'selling_area', 'Heading Color', '#010101');

lzCustomLable($wp_customize, 'sellbtn', 'selling_area' , 'Section Top Button');

$wp_customize->add_setting(
    'sellbtntxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'See All' )
    )
);
$wp_customize->add_control(
    'sellbtntxt',
    array(
        'settings'      => 'sellbtntxt',
        'section'       => 'selling_area',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);

$wp_customize->add_setting('sellbtnlink',   array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('sellbtnlink',
    array(
        'settings'      => 'sellbtnlink',
        'section'       => 'selling_area',
        'type'          => 'url',
        'label'         => __( 'Button Link', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'selling_area_tptxtClr', 'selling_area', 'Top Button Text Color', '#B05D5D');

addColorPalatOption($wp_customize, 'selling_area_tptxthvClr', 'selling_area', 'Top Button Text Hover Color', '#fff');

addColorPalatOption($wp_customize, 'selling_area_tpbtnbgClr', 'selling_area', 'Top Button BG Color', '#FFE8E8');

addColorPalatOption($wp_customize, 'selling_area_tpbtnbghvClr', 'selling_area', 'Top Button BG Hover Color', '#b46463');

addColorPalatOption($wp_customize, 'selling_area_tpbtntxtbrdClr', 'selling_area', 'Top Button Border Color', '#b46463');


lzCustomLable($wp_customize, 'sellingarea_clr', 'selling_area', 'Section Color');

//addColorPalatOption($wp_customize, 'selling_area_imghvClr', 'selling_area', 'Image Hover Color', '#FCE097');

addColorPalatOption($wp_customize, 'selling_area_priceClr', 'selling_area', 'Product Price Color', '#fff');

addColorPalatOption($wp_customize, 'selling_area_pricebgClr', 'selling_area', 'Product Price BG Color', '#B05D5D');

addColorPalatOption($wp_customize, 'selingpricbgvornerClr', 'selling_area', 'Product Price BG Corner Color', '#853E3E');

addColorPalatOption($wp_customize, 'selling_area_pagetitle', 'selling_area', 'Product Title Color', '#010101');


addColorPalatOption($wp_customize, 'selling_area_arrowiconClr', 'selling_area', 'Slider Arrow Icon Color', '#fff');

addColorPalatOption($wp_customize, 'selling_area_arrowicnhvClr', 'selling_area', 'Slider Arrow Icon Hover Color', '#000');

addColorPalatOption($wp_customize, 'selling_area_arrowiconbgClr', 'selling_area', 'Slider Arrow Icon BG Color', '#b46463');
