<?php
/**
 * Customiser section for support
 **/
// Start Support section 
$wp_customize->add_section(
    'support_section',
    array(
        'title' => __('Support Section', 'luzuk-premium' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);
//ENABLE/DISABLE SUPPORT SECTION
$wp_customize->add_setting(
    'support_section_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'support_section_disable',
        array(
            'settings'      => 'support_section_disable',
            'section'       => 'support_section',
            'label'         => __( 'Disable Section', 'luzuk-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk-premium' ),
                'off' => __( 'No', 'luzuk-premium' )
            )   
        )
    )
);

backgroundManager($wp_customize, 'support', 'support_section', $color='#FFE8E8', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'supportsection_padding', 'support_section', ' Section Padding');

$wp_customize->add_setting(
    'support_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1.5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'support_toppadding',
    array(
        'settings'      => 'support_toppadding',
        'section'       => 'support_section',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'support_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'support_bottompadding',
    array(
        'settings'      => 'support_bottompadding',
        'section'       => 'support_section',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

$wp_customize->add_setting('support_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'support_npp_heading',
        array(
            'settings'      => 'support_npp_heading',
            'section'       => 'support_section',
            'label'         => __( 'Number Of Support Plans To Show', 'supermarket-ecommerce' ),
        )
    )
);    
$wp_customize->add_setting('support_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control(
    'support_npp_count',
    array(
        'settings'      => 'support_npp_count',
        'section'       => 'support_section',
        'type'          => 'select',
        'label'         => __( 'Number Of Support Plans To Show', 'supermarket-ecommerce' ),
        'choices'=>array(1,2,3,4,5,6,7,8)
    )
);

//support PAGES
for( $i = 1; $i <= 8; $i++ ){
    $wp_customize->add_setting(
        'support_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'support_header'.$i,
            array(
                'settings'      => 'support_header'.$i,
                'section'       => 'support_section',
                'label'         => __( 'Plan ', 'supermarket-ecommerce' ).$i
            )
        )
    );

    
    $wp_customize->add_setting(
        'support_page_icon'.$i,
        array(
            'default'           => 'fa fa-shield',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'support_page_icon'.$i,
            array(
                'settings'      => 'support_page_icon'.$i,
                'section'       => 'support_section',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'supermarket-ecommerce' ),
            )
        )
    ); 

    
    lzAddElement($wp_customize, 'support_page_title_'.$i, 'support_section', $type = 'text', $label="Title", $callback ='luzuk_sanitize_text', $default='Safe delivery');
  
 lzAddElement($wp_customize, 'support_page_desc_'.$i, 'support_section', $type = 'text', $label="Text", $callback ='luzuk_sanitize_text', $default='Praesent malesuada ornare.');
 
}

lzCustomLable($wp_customize, 'supportsection_Clrsetting', 'support_section', 'Section Color');

addColorPalatOption($wp_customize, 'support_IconColor', 'support_section', 'Icon Color', '#000');

addColorPalatOption($wp_customize, 'support_IconBGClr', 'support_section', 'Icon BG Color', '#FFF');

addColorPalatOption($wp_customize, 'support_IconBGhvClr', 'support_section', 'Icon BG Hover Color', '#b46463');

addColorPalatOption($wp_customize, 'support_titleClr', 'support_section', 'Title Color', '#353849');

addColorPalatOption($wp_customize, 'support_DescriptionClr', 'support_section', 'Text Color', '#707070');
