/*
 * Theme Name: Lz Software Company
*/

/*----------------------------------------------------
/* Responsive Navigation
/*--------------------------------------------------*/
jQuery(document).ready(function($){
    $('.primary-navigation').append('<div id="mobile-menu-overlay" />');

    $('.toggle-mobile-menu').click(function(e) {
        e.preventDefault();
        e.stopPropagation();
        $('body').toggleClass('mobile-menu-active');

        if ( $('body').hasClass('mobile-menu-active') ) {
            if ( $(document).height() > $(window).height() ) {
                var scrollTop = ( $('html').scrollTop() ) ? $('html').scrollTop() : $('body').scrollTop();
                $('html').addClass('noscroll').css( 'top', -scrollTop );
            }
            $('#mobile-menu-overlay').fadeIn();
        } else {
            var scrollTop = parseInt( $('html').css('top') );
            $('html').removeClass('noscroll');
            $('html,body').scrollTop( -scrollTop );
            $('#mobile-menu-overlay').fadeOut();
        }
    });
}).on('click', function(event) {

    var $target = jQuery(event.target);
    if ( ( $target.hasClass("publishable-icon") && $target.parent().hasClass("toggle-caret") ) ||  $target.hasClass("toggle-caret") ) {// allow clicking on menu toggles
        return;
    }
    jQuery('body').removeClass('mobile-menu-active');
    jQuery('html').removeClass('noscroll');
    jQuery('#mobile-menu-overlay').fadeOut();
});

/*----------------------------------------------------
/*  Dropdown menu
/* ------------------------------------------------- */
jQuery(document).ready(function($) {
    
    function mtsDropdownMenu() {
        var wWidth = $(window).width();
        if(wWidth > 865) {
            $('#navigation ul.sub-menu, #navigation ul.children').hide();
            var timer;
            var delay = 100;
            $('#navigation li').hover( 
              function() {
                var $this = $(this);
                timer = setTimeout(function() {
                    $this.children('ul.sub-menu, ul.children').slideDown('fast');
                }, delay);
                
              },
              function() {
                $(this).children('ul.sub-menu, ul.children').hide();
                clearTimeout(timer);
              }
            );
        } else {
            $('#navigation li').unbind('hover');
            $('#navigation li.active > ul.sub-menu, #navigation li.active > ul.children').show();
        }
    }

    mtsDropdownMenu();

    $(window).resize(function() {
        mtsDropdownMenu();
    });
});

/*---------------------------------------------------
/*  Vertical menus toggles
/* -------------------------------------------------*/
jQuery(document).ready(function($) {

    $('.widget_nav_menu, #navigation .menu').addClass('toggle-menu');
    $('.toggle-menu ul.sub-menu, .toggle-menu ul.children').addClass('toggle-submenu');
    $('.toggle-menu ul.sub-menu').parent().addClass('toggle-menu-item-parent');

    $('.toggle-menu .toggle-menu-item-parent').append('<span class="toggle-caret"><i class="publishable-icon icon-plus"></i></span>');

    $('.toggle-caret').click(function(e) {
        e.preventDefault();
        $(this).parent().toggleClass('active').children('.toggle-submenu').slideToggle('fast');
    });
});

/*----------------------------------------------------
/* Back to top smooth scrolling
/*--------------------------------------------------*/
jQuery(document).ready(function($) {
    jQuery('a[href=#top]').click(function(){
        jQuery('html, body').animate({scrollTop:0}, 'slow');
        return false;
    });
});

// Gallery 

Fancybox.bind("[data-fancybox]", {
    buttons: [
    "slideShow",
    "thumbs",
    "fullScreen",
    "close"
  ],
  loop: false,
  protect: true
}); 


document.addEventListener('DOMContentLoaded', function() {
    // Script for single product page button
    var reviewButton = document.getElementById('show-review-form');
    var reviewFormWrapper = document.getElementById('review_form_wrapper');

    console.log('reviewButton:', reviewButton);
    console.log('reviewFormWrapper:', reviewFormWrapper);

    if (reviewButton && reviewFormWrapper) {
        reviewButton.addEventListener('click', function() {
            console.log('Review button clicked');
            if (reviewFormWrapper.style.display === 'none' || reviewFormWrapper.style.display === '') {
                reviewFormWrapper.style.display = 'block';
            } else {
                reviewFormWrapper.style.display = 'none';
            }
        });
    }

    // Script to show rating text
    var reviewLink = document.querySelector('.woocommerce-review-link');
    console.log('reviewLink:', reviewLink);

    if (reviewLink) {
        // Get the review count
        var reviewCountMatch = reviewLink.textContent.match(/\d+/);
        console.log('reviewCountMatch:', reviewCountMatch);

        if (reviewCountMatch) {
            var reviewCount = parseInt(reviewCountMatch[0]);
            console.log('reviewCount:', reviewCount);

            // Update the desired text with the review count
            var newText = reviewCount + ' Rating ';
            // Replace the existing review link text with the new text
            reviewLink.textContent = newText;
        }
    }
});


// header sticky script

// var div_top = $('.site-header').offset().top;

// $(window).scroll(function() {
//     var window_top = $(window).scrollTop() - 0;
//     if (window_top > div_top) {
//         if (!$('.site-header').is('.sticky')) {
//             $('.site-header').addClass('sticky');
//         }
//     } else {
//         $('.site-header').removeClass('sticky');
//     }
// });