<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 /**
 * Template for displaying product archives.
 *
 * @version 9.2.0
 */
get_header(); ?>
<div class="clearfix"></div>
<?php $thumb = wp_get_attachment_image_src( get_post_thumbnail_id( wc_get_page_id( 'shop' ) ), 'full' );?>
<header class="page-main-header" <?php  if (!empty($thumb)) : ?> style="background: url('<?php echo $thumb['0']; ?>'); background-repeat: no-repeat; background-size:cover;"<?php endif ?> >     
	<div class="innheadpgimg"></div> 
    <div class="  container" >
        <div class="headinnbox">
            <!-- <h1 class="page-title ht-main-title wow zoomIn"></?php woocommerce_page_title(); ?></h1> -->
            <?php if( get_theme_mod('breadcrumb_button_display','show' ) == 'show') : ?>
            <div class="breadcrumbbox wow zoomIn">
                <div class='button'><?php luzuk_lite_the_breadcrumb(); ?></div>
                <div class="clearfix"></div>
            </div>
             <?php endif ?>
        </div>
    </div>
    <div class="clearfix"></div>
</header>	

<div class="single-productpage">
	<main id="innerpage-box">
		<?php
			//if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
			//get_header('shop'); ?>
			<div id="page" class="container" >
				<div class="inner_contentbox" >
				<article id="content" class="article">
					
					<div class="row mr-0">
					<div class="col-xl-3 col-lg-4 col-md-12 product-page">
						<?php if( get_theme_mod('cd_button_display','show' ) == 'show') :
					  		?>
					  		<div class='button'><?php get_sidebar( 'shop'); ?></div>
					  	<?php endif ?>
					</div>
					<div class="col-xl-9 col-lg-8 col-md-12">	
											
											
						<?php if ( have_posts() ) : ?>						
						<?php do_action( 'woocommerce_before_shop_loop' ); ?>
						<?php woocommerce_product_loop_start(); ?>
						<?php woocommerce_product_subcategories(); ?>
						<?php while ( have_posts() ) : the_post(); ?>
						<?php wc_get_template_part( 'content', 'product' ); ?>
						<?php endwhile; // end of the loop. ?>
						<?php woocommerce_product_loop_end(); ?>
						<?php do_action( 'woocommerce_after_shop_loop' ); ?>
						
						<?php elseif ( ! woocommerce_product_subcategories( array( 'before' => woocommerce_product_loop_start( false ), 'after' => woocommerce_product_loop_end( false ) ) ) ) : ?>

						<?php //woocommerce_get_template( 'loop/no-products-found.php' ); ?>

						<?php endif; ?>	
					
					<div class="clearfix"></div>
				</div>
				</article>
				<?php /*do_action('woocommerce_sidebar');*/ ?>
				<?php //get_sidebar(); ?>	
				<div class="clearfix"></div>
			</div>
				<div class="clearfix"></div>
			</div>	
	</main><!-- #main -->
</div>
<div class="clearfix"></div>
<?php 
  get_template_part('template-parts/section','support');
 ?>
 <?php 
  get_template_part('template-parts/section','newsletter');
 ?>
<?php get_footer(); ?>
