<?php
/**
 * Single Product Meta
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/meta.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     9.7.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $product;
?>
<div class="product_meta">

	<?php do_action( 'woocommerce_product_meta_start' ); ?>

        <?php echo wc_get_product_category_list( $product->get_id(), ', ', '<div class="posted_in"><div class="row mr-0"><div class="col-lg-2 til pd-0"> <span>' . _n( 'Category:', 'Categories :</div><div class="col-lg-10">', $product->get_category_ids() , 'woocommerce' ) . ' </span>', '</div></div></div>' ); ?>


    	<?php echo wc_get_product_tag_list( $product->get_id(), ', ', '<div class="tagged_as"><div class="row mr-0"><div class="col-lg-2 til pd-0"><span>' . _n( 'Tag :', 'Tags :</div><div class="col-lg-10">', count( $product->get_tag_ids() ), 'woocommerce' ) . '</span> ', '</div></div></div>' ); ?>


        <?php if ( wc_product_sku_enabled() && ( $product->get_sku() || $product->is_type( 'variable' ) ) ) : ?>
        <div class="posted_in">
            <div class="row mr-0">
                <div class="col-lg-2 pd-0">
                    <span class="sku_wrapper"><?php esc_html_e( 'SKU :', 'woocommerce' ); ?> </span>
                    <div class="clearfix"></div>
                </div>
                <div class="col-lg-10">
                  <span class="sku"><?php echo ( $sku = $product->get_sku() ) ? $sku : esc_html__( 'N/A', 'woocommerce' ); ?></span>
                </div>
            </div>
        </div>
        <?php endif; ?>

	<?php do_action( 'woocommerce_product_meta_end' ); ?>

</div>
