<?php    
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luzuk Premium
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>


		<!-- <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@100;300;400;500;700;900&display=swap" rel="stylesheet"> -->
	<link href="https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300;0,400;0,600;0,700;0,800;1,300;1,400;1,600;1,700;1,800&display=swap" rel="stylesheet">

	<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800&display=swap" rel="stylesheet">

	<!-- <script src="<?php //echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script> -->
	
	<!-- <script src="<?php //echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script> -->

	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.5.1/jquery.slim.min.js"></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>



	<link rel="stylesheet" type="text/css" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">

	<!-- <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css" 
  integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous"> -->

  
	<script
  src="https://code.jquery.com/jquery-3.3.1.js"
  integrity="sha256-2Kok7MbOyxpgUVvAk/HJ2jigOSYS2auK4Pfzbm7uH60="
  crossorigin="anonymous"></script>

 
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<div class="main-container">
		<header class="site-header header-transparent header mo-left header-seo">
			<div class="top-bar-head">
			<div class="container-fluid">
				<div class="row row-eq-height">
					<div class="logo col-md-3 col-sm-9 col-xs-10">
						<div class="inside-full-height">
							<?php 
							
								if( get_theme_mod('pages_logoTopsetmaxwidth',true) ) {
									$pages_logoTopsetmaxwidth = 'max-width:'.esc_attr(get_theme_mod('pages_logoTopsetmaxwidth')).';';
								}
								if( get_theme_mod('pages_logoTpadding',true) ) {
									$pages_logoTpadding = 'padding-top:'.esc_attr(get_theme_mod('pages_logoTpadding')).';';
								}
								if( get_theme_mod('pages_logoBpadding',true) ) {
									$pages_logoBpadding = 'padding-bottom:'.esc_attr(get_theme_mod('pages_logoBpadding')).';';
								}
								if( get_theme_mod('pages_logoLpadding',true) ) {
									$pages_logoLpadding = 'padding-left:'.esc_attr(get_theme_mod('pages_logoLpadding')).';';
								}
								if( get_theme_mod('pages_logoRpadding',true) ) {
									$pages_logoRpadding = 'padding-right:'.esc_attr(get_theme_mod('pages_logoRpadding')).';';
								}

							?>
								<!-- website logo -->
								<div class="logo-header mostion">
									<?php 
									if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
										the_custom_logo();
								else : 
									if ( is_front_page() ) : ?>
										<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
										<?php else : ?>
											<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
										<?php endif; ?>
									<?php endif; ?>
								</div> 
								<!-- <p class="ht-site-description"><a href="<?php //echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php //bloginfo( 'description' ); ?></a></p>   -->
							<!-- nav toggle button -->
							<div class="resp_header_logo">
								<?php 
								if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
									the_custom_logo();
							else : 
								if ( is_front_page() ) : ?>
									<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
									<?php else : ?>
										<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
									<?php endif; ?>
									<!-- <p class="ht-site-description"><a href="<?php //echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php //bloginfo( 'description' ); ?></a></p> -->
								<?php endif; ?>
							</div>
						</div>
					</div>
				<div class="col-md-7 col-sm-3 col-xs-2 ">			
					<div class="HeaderRbx pd-0">
						<div class="header-right">
							<div class="row ">
								<div class="head-menu ">
									<div class="inside-full-height">
										<div class="site-navigation ">
					                        <div class="hamburger-menus">
					                            <span></span>
					                            <span></span>
					                            <span></span>
					                            <span></span>
					                            <span></span>
					                            <span></span>
					                            <span></span>
					                            <span></span>
					                            <span></span>
					                        </div>
					                        <nav class="navigation">
					                            <div class="menu-wrapper">
					                                <div class="menu-content ">
					                                    <?php
					                                        if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
					                                            wp_nav_menu ( array(
					                                                'menu_class' => 'mainmenu ht-clearfix',
					                                                'container'=> 'ul',
					                                                'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
					                                                'theme_location' => 'primary',  
					                                            )); 
					                                        } else {
					                                            wp_nav_menu ( array(
					                                                'menu_class' => 'mainmenu ht-clearfix',
					                                                'container'=> 'ul',
					                                                'theme_location' => 'primary',  
					                                            )); 
					                                        }
					                                    ?>
					                                </div> <!-- /.hours-content-->
					                                
													<div class="clearfix"></div>
					                            </div><!-- /.menu-wrapper --> 
					                            <div class="clearfix"></div>
					                            <?php
										              $headerbutton = get_theme_mod('header_btn_txt', 'Contact Us'); 
										              $headerbtnlink = get_theme_mod('header_btnlink', '#');
							            		?> 
					            		<?php if($headerbutton ){ ?>
											
												<div class="mobvw1 ">
												<div class="header-btn">
													<a href="<?php echo ($headerbtnlink);?>">
														<?php echo ($headerbutton );  ?>
													</a>
												</div>
											
										</div>
										<?php }?>
			                        		</nav>
										 	<div class="clearfix"></div>
										</div><!--  /.site-navigation -->
									</div>
								</div>
							</div>
							<div class="clearfix"></div>
						</div>
					</div>
						<div class="clearfix"></div>
					</div>
					<?php
			              $headerbutton = get_theme_mod('header_btn_txt', 'Contact Us'); 
			              $headerbtnlink = get_theme_mod('header_btnlink', '#');
            		?> 
            		<?php if($headerbutton ){ ?>
						<div class=" col-md-2">
							<div class="mobvw ">
							<div class="header-btn">
								<a href="<?php echo ($headerbtnlink);?>">
									<?php echo ($headerbutton );  ?>
								</a>
							</div>
						</div>
					</div>
					<?php }?>
					<!-- <div class="col-md-1 lasthead"></div> -->
					</div>
				</div>
			</div>
			<div class="clearfix"></div>
		</header>
	</div>
