<?php

$wp_customize->add_panel(
	'luzuk_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'Luzuk Premium')
	)
);

//STATIC FRONT PAGE
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'Luzuk Premium'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
	'title' => __( 'Site Logo/Title/Tagline', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );
addColorPalatOption($wp_customize, 'header_SiteColor', 'title_tagline', 'Site Title Color', '#fdb1aa');
addColorPalatOption($wp_customize, 'header_SiteTaglineColor', 'title_tagline', 'Tagline Color', '#000');

lzCustomLable($wp_customize, 'pageslogosetmaxwidthl', 'title_tagline', 'Add Logo Max Width');

$wp_customize->add_setting(
    'pages_logoTopsetmaxwidth',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '100', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoTopsetmaxwidth',
    array(
        'settings'      => 'pages_logoTopsetmaxwidth',
        'section'       => 'title_tagline',
        'type'          => 'range',
        'label'         => __( 'Set Logo Max Width', 'luzuk-premium' )
    )
);


lzCustomLable($wp_customize, 'pageslogopaddingl', 'title_tagline', 'Add Logo Padding');

$wp_customize->add_setting(
    'pages_logoTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoTpadding',
    array(
        'settings'      => 'pages_logoTpadding',
        'section'       => 'title_tagline',
        'type'          => 'text',
        'label'         => __( 'Set Logo Top Padding', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'pages_logoBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoBpadding',
    array(
        'settings'      => 'pages_logoBpadding',
        'section'       => 'title_tagline',
        'type'          => 'text',
        'label'         => __( 'Set Logo Bottom Padding', 'luzuk-premium' )
    )
);


// $wp_customize->add_setting(
//     'pages_logoBBpadding',
//     array(
//         'sanitize_callback' => 'luzuk_sanitize_text',
//         'default'           => __( '0px', 'luzuk-premium' )
//     )
// );
// $wp_customize->add_control(
//     'pages_logoBBpadding',
//     array(
//         'settings'      => 'pages_logoBBpadding',
//         'section'       => 'title_tagline',
//         'type'          => 'text',
//         'label'         => __( 'Set Logo Bottom Padding', 'luzuk-premium' )
//     )
// );

$wp_customize->add_setting(
    'pages_logoLpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoLpadding',
    array(
        'settings'      => 'pages_logoLpadding',
        'section'       => 'title_tagline',
        'type'          => 'text',
        'label'         => __( 'Set Logo Left Padding', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'pages_logoRpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoRpadding',
    array(
        'settings'      => 'pages_logoRpadding',
        'section'       => 'title_tagline',
        'type'          => 'text',
        'label'         => __( 'Set Logo Right Padding', 'luzuk-premium' )
    )
);



//BACKGROUND IMAGE
$wp_customize->add_section( 'background_image', array(
	'title' => __( 'Background Image Setting', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );

//Header IMAGE
$wp_customize->add_section( 'header_image', array(
	'title' => __( 'Header Image', 'Luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );


//HEADER SETTINGS
$wp_customize->add_section(
	'header_settings',
	array(
		'title' => __( 'Header Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'stickyheader_view', 'header_settings', 'Sticky Header Setting');
    //ENABLE/DISABLE STICKY HEADER
$wp_customize->add_setting(
    'luzuk_sticky_header_enable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);

$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'luzuk_sticky_header_enable',
        array(
            'settings'      => 'luzuk_sticky_header_enable',
            'section'       => 'header_settings',
            'label'         => __( 'Sticky Header', 'Luzuk Themethemes Premium' ),
            'on_off_label'  => array(
                'on' => __( 'Enable', 'luzuk-premium' ),
                'off' => __( 'Disable', 'luzuk-premium' )
            )   
        )
    )
);


$sectionHeader = 'header_settings';

lzCustomLable($wp_customize, 'header_bgColorssettings', $sectionHeader, 'Header Setting');

lzCustomLable($wp_customize, 'header_MenuColorssettings', $sectionHeader, 'Navigation Colors');

addColorPalatOption($wp_customize, 'header_topmenusColor', 'header_settings', 'Main Menus Color', '#fff');

addColorPalatOption($wp_customize, 'header_topmenushoverColor', 'header_settings', 'Main Menus Hover Color', '#fdb1aa');

addColorPalatOption($wp_customize, 'header_topmenusactiveColor', 'header_settings', 'Active Menus Color', '#fdb1aa');

addColorPalatOption($wp_customize, 'header_topsubmenusColor', 'header_settings', 'Header Sub Menus Color', '#000');

addColorPalatOption($wp_customize, 'header_topsubmenushvColor', 'header_settings', 'Header Sub Menus Hover Color', '#fdb1aa');

//addColorPalatOption($wp_customize, 'header_topsubmenusbghvColor', 'header_settings', 'Header Sub Menus BG Hover Color', '#000');

addColorPalatOption($wp_customize, 'header_topsubmenusbrdClr', 'header_settings', 'Header Sub Menus Border Color', '#fdb1aa');

addColorPalatOption($wp_customize, 'header_submenusbgsscColor', 'header_settings', 'Dropdown BG Color', '#fff');

lzCustomLable($wp_customize, 'header_buttonsetting', $sectionHeader, 'Header Button Setting');

$wp_customize->add_setting(
    'header_btn_txt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Contact Us' )
    )
);
$wp_customize->add_control(
    'header_btn_txt',
    array(
        'settings'      => 'header_btn_txt',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);

$wp_customize->add_setting('header_btnlink',   array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('header_btnlink',
    array(
        'settings'      => 'header_btnlink',
        'section'       => 'header_settings',
        'type'          => 'url',
        'label'         => __( 'Add Button link here', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'header_buttoncolor', 'header_settings', 'Header Button Text Color', '#000');

addColorPalatOption($wp_customize, 'header_buttonhovercolor', 'header_settings', 'Header Button Text Hover Color', '#fdb1aa');

addColorPalatOption($wp_customize, 'header_buttonbgcolor', 'header_settings', 'Header Button BG Color', '#fdb1aa');

addColorPalatOption($wp_customize, 'header_buttonhoverbrdcolor', 'header_settings', 'Header Button Hover Border Color', '#fdb1aa');

lzCustomLable($wp_customize, 'header_colorsfortabandmobview', $sectionHeader, 'Responsive Header Setting');

addColorPalatOption($wp_customize, 'header_tmainheadbgClr', 'header_settings', 'Header BG Color', '#fcf5f4');

addColorPalatOption($wp_customize, 'header_topsubmenuiconColor', 'header_settings', 'Header Menus Dropdown Icon Color', '#fff');

addColorPalatOption($wp_customize, 'header_respnavtoggbarbgssColor', 'header_settings', 'Toggle Bar Color', '#fdb1aa');

addColorPalatOption($wp_customize, 'header_respnavbsbgssColor', 'header_settings', ' Navigation Box BG Color', '#000');

addColorPalatOption($wp_customize, 'header_navigationrespnavbrssColor', 'header_settings', 'Navigation Box Border Color', '#fdb1aa');

//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'Luzuk Premium'),
	'panel' => 'luzuk_general_panel',
) );

    $wp_customize->add_setting('luzuk_premium_color_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_color_section_lbl',
        array(
            'settings'      => 'luzuk_premium_color_section_lbl',
            'section'       => 'colors',
            'label'         => __( 'Note:', 'luzuk-premium' ),  
            'description'   => __( '<b>This section available only for PRO version</b><br>If you want this section click on <b>Go Pro</b>', 'luzuk-premium' ),
        )
    )
);



//BREADCRUMB SETTINGS
$wp_customize->add_section(
	'luzuk_breadcrumb_settings',
	array(
		'title' => __( 'Breadcrumb Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

//for breadcrumb to show & hide button

$wp_customize->add_setting( 'breadcrumb_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'breadcrumb_button_display', array( 'label' => 'Breadcrumb Display', 'section' => 'luzuk_breadcrumb_settings', 'settings' => 'breadcrumb_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Breadcrumb', 'hide' => 'Hide Breadcrumb', ), ) ); 

$wp_customize->add_setting(
        'luzuk_breadcrumbhometxt',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Home', 'luzuk' )
        )
    );
    $wp_customize->add_control(
        'luzuk_breadcrumbhometxt',
        array(
            'settings'      => 'luzuk_breadcrumbhometxt',
            'section'       => 'luzuk_breadcrumb_settings',
            'type'          => 'text',
            'label'         => __( 'Add Breadcrumb Text Here', 'luzuk' )
        )
    );

//Inner page breadcrumbbox title color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbtitlecolor', 'luzuk_breadcrumb_settings', 'Inner Page Breadcrumb Box Title Color', '#fff');
//Inner page breadcrumbbox current title color
addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenttitlecolor', 'luzuk_breadcrumb_settings', 'Inner Page Breadcrumb Box Current Title Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenttitlehovercolor', 'luzuk_breadcrumb_settings', 'Inner Page Breadcrumb Box Current Title Hover Color', '#fdb1aa');

// end to show & hide button

//POSTPAGEDATE SETTINGS
$wp_customize->add_section(
	'luzuk_blogpage_settings',
	array(
		'title' => __( 'Inner Blog Page Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

    $wp_customize->add_setting('luzuk_premium_blog_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_blog_section_lbl',
        array(
            'settings'      => 'luzuk_premium_blog_section_lbl',
            'section'       => 'luzuk_blogpage_settings',
            'label'         => __( 'Note:', 'luzuk-premium' ),  
            'description'   => __( '<b>This section available only for PRO version</b><br>If you want this section click on <b>Go Pro</b>', 'luzuk-premium' ),
        )
    )
);


//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
	'footer_area',
	array(
		'title' => __( 'Footer Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

backgroundManager($wp_customize, 'footer', 'footer_area', $color='#1a1c20', get_template_directory_uri().'/images/footer1.jpg', 'color');

lzCustomLable($wp_customize, 'footer_areaPadding', 'footer_area', 'Footer Padding');

$wp_customize->add_setting(
    'sec_footerseTmargin', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5.8em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_footerseTmargin',
    array(
        'settings'      => 'sec_footerseTmargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'sec_footersebottommargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_footersebottommargin',
    array(
        'settings'      => 'sec_footersebottommargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'footer_fromsection', 'footer_area', 'Footer Section');

//addColorPalatOption($wp_customize, 'footerarea_formtbg_color', 'footer_area', 'Form BG Color', '#000');

addColorPalatOption($wp_customize, 'footerarea_formtextlabel_color', 'footer_area', 'Label Color', '#000');

addColorPalatOption($wp_customize, 'footerarea_formtext_color', 'footer_area', 'Form Text & Placeholder Text Color', '#585858');

addColorPalatOption($wp_customize, 'footerarea_formtxtbg_clr', 'footer_area', 'Form Text BG Color', '#f6f6f6');

//addColorPalatOption($wp_customize, 'footerareabutton_txt_color', 'footer_area', 'Button Arrow Color', '#000');

addColorPalatOption($wp_customize, 'footerareabutton_txt_color', 'footer_area', 'Button Text Color', '#000');

addColorPalatOption($wp_customize, 'footerareabutton_txt_hv_color', 'footer_area', 'Button Text Hover Color', '#fff');

addColorPalatOption($wp_customize, 'footerareabutton_bg_color', 'footer_area', 'Button BG Color', '#fdb1aa');

addColorPalatOption($wp_customize, 'footerareabutton_bghover_color', 'footer_area', 'Button BG Hover Color', '#000');


addColorPalatOption($wp_customize, 'footerarea_title_color', 'footer_area', 'Footer Title Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_text_color', 'footer_area', 'Footer Text Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_sicon_color', 'footer_area', 'Footer Social Icon Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_siconhover_color', 'footer_area', 'Footer Social Icon Hover Color', '#fdb1aa');

addColorPalatOption($wp_customize, 'footerarea_siconHvbrd_clr', 'footer_area', 'Footer Social Icon Hover Border Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_menu_color', 'footer_area', 'Footer Menu Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_menuhover_color', 'footer_area', 'Footer Menu Hover Color', '#fdb1aa');

addColorPalatOption($wp_customize, 'footerarea_activemenu_color', 'footer_area', 'Active Menu Color', '#fdb1aa');

addColorPalatOption($wp_customize, 'footerarea_datext_color', 'footer_area', 'Date Text Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_bottmborder_color', 'footer_area', 'Footer Bottom Border Color', '#fff');


lzCustomLable($wp_customize, 'footer_copytext', 'footer_area', 'Bottom Footer ');

// $wp_customize->add_setting(
//     'footerphonetext',
//     array(
//         'sanitize_callback' => 'luzuk_sanitize_text',
//         'default'           => __( 'Call - Or - SMS', 'Luzuk Premium' )
//     )
// );
// $wp_customize->add_control(
//     'footerphonetext',
//     array(
//         'settings'      => 'footerphonetext',
//         'section'       => 'footer_area',
//         'type'          => 'text',
//         'label'         => __( 'Footer Phone Text', 'Luzuk Premium' )
//     )
// );


// $wp_customize->add_setting(
//     'footerphone',
//     array(
//         'sanitize_callback' => 'luzuk_sanitize_text',
//         'default'           => __( '+91 800-6539-002', 'Luzuk Premium' )
//     )
// );
// $wp_customize->add_control(
//     'footerphone',
//     array(
//         'settings'      => 'footerphone',
//         'section'       => 'footer_area',
//         'type'          => 'text',
//         'label'         => __( 'Footer Phone No.', 'Luzuk Premium' )
//     )
// );


$wp_customize->add_setting(
    'footer_area_copyrighttext',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Copyright @ 2022 Nail Art All Right Reserved', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'footer_area_copyrighttext',
    array(
        'settings'      => 'footer_area_copyrighttext',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Footer Copyright Text', 'Luzuk Premium' )
    )
);


// Adding the Label
//lzCustomLable($wp_customize, 'footer_privtxt', 'footer_area', 'Add Terms & Condition Text & Its Url');
// $wp_customize->add_setting(
//     'footerTermsNdConText',
//     array(
//         'sanitize_callback' => 'luzuk_sanitize_text',
//         'default'           => __( 'Terms & Condition', 'Luzuk Premium' )
//     )
// );
// $wp_customize->add_control(
//     'footerTermsNdConText',
//     array(
//         'settings'      => 'footerTermsNdConText',
//         'section'       => 'footer_area',
//         'type'          => 'text',
//         'label'         => __( 'Add Text Here:', 'Luzuk Premium' )
//     )
// );

// $wp_customize->add_setting('footer_termsndondition',    array('default'=> '#', 'sanitize_callback' => 'esc_url_raw'));
// $wp_customize->add_control('footer_termsndondition',
//     array(
//         'settings'      => 'footer_termsndondition',
//         'section'       => 'footer_area',
//         'type'          => 'url',
//         'label'         => __( 'Add Url Here', 'Luzuk' )
//     )
// );
//lzCustomLable($wp_customize, 'footer_privtxts', 'footer_area', 'Add Privacy Policy Text & Its Url');

// $wp_customize->add_setting(
//     'footerprivtext',
//     array(
//         'sanitize_callback' => 'luzuk_sanitize_text',
//         'default'           => __( 'Privacy Policy', 'Luzuk Premium' )
//     )
// );
// $wp_customize->add_control(
//     'footerprivtext',
//     array(
//         'settings'      => 'footerprivtext',
//         'section'       => 'footer_area',
//         'type'          => 'text',
//         'label'         => __( 'Add Text Here:', 'Luzuk Premium' )
//     )
// );

// $wp_customize->add_setting('footer_privacytext',    array('default'=> '#', 'sanitize_callback' => 'esc_url_raw'));
// $wp_customize->add_control('footer_privacytext',
//     array(
//         'settings'      => 'footer_privacytext',
//         'section'       => 'footer_area',
//         'type'          => 'url',
//         'label'         => __( 'Add Url Here', 'Luzuk' )
//     )
// );


//addColorPalatOption($wp_customize, 'footerarea_phbgclr', 'footer_area', 'Footer Bottom Footer Phone BG Color', '#eb49b9');

//addColorPalatOption($wp_customize, 'footerarea_copyright_color', 'footer_area', 'Footer Bottom Phone Icon & Border & Text Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_copytxt_color', 'footer_area', 'Footer Bottom Footer Text Color', '#dfdbdd');

//addColorPalatOption($wp_customize, 'footerarea_copyrighticnhv_clr', 'footer_area', 'Footer Phone Hover Color', '#000');

//addColorPalatOption($wp_customize, 'footerarea_btmbgclr', 'footer_area', 'Bottom Footer BG Color', '#fff');

//SHOP PAGE SIDEBAR SETTINGS
$wp_customize->add_section(
	'luzuk_shopsidebar_settings',
	array(
		'title' => __( 'Shop Page Sidebar Settings', 'Luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);


// to show & hide button
$wp_customize->add_setting( 'cd_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'cd_button_display', array( 'label' => 'Shop Sidebar Display', 'section' => 'luzuk_shopsidebar_settings', 'settings' => 'cd_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Sidebar', 'hide' => 'Hide Sidebar', ), ) ); 
// end to show & hide button

$wp_customize->add_setting(
    'productpages_productheading2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '20px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'productpages_productheading2',
    array(
        'settings'      => 'productpages_productheading2',
        'section'       => 'luzuk_shopsidebar_settings',
        'type'          => 'text',
        'label'         => __( 'Product Heading Font Size', 'luzuk-premium' )
    )
);


$wp_customize->add_section(
	'luzuk_innerpageshortcode_page_settings',
	array(
		'title' => __( 'Color Setting For Shortcode Pages', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

    $wp_customize->add_setting('luzuk_premium_colorsetting_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_colorsetting_section_lbl',
        array(
            'settings'      => 'luzuk_premium_colorsetting_section_lbl',
            'section'       => 'luzuk_innerpageshortcode_page_settings',
            'label'         => __( 'Note:', 'luzuk-premium' ),  
            'description'   => __( '<b>This section available only for PRO version</b><br>If you want this section click on <b>Go Pro</b>', 'luzuk-premium' ),
        )
    )
);


$wp_customize->add_section(
	'luzuk_innerpagefont_settings',
	array(
		'title' => __( 'Inner Page Settings', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

   $wp_customize->add_setting('luzuk_premium_innerpage_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_innerpage_section_lbl',
        array(
            'settings'      => 'luzuk_premium_innerpage_section_lbl',
            'section'       => 'luzuk_innerpagefont_settings',
            'label'         => __( 'Note:', 'luzuk-premium' ),  
            'description'   => __( '<b>This section available only for PRO version</b><br>If you want this section click on <b>Go Pro</b>', 'luzuk-premium' ),
        )
    )
);


// CREATING A BLOG SECTION IN CUSTOMIZER FOR BLOG PAGES
$wp_customize->add_section(
    'premium_blog_area',
    array(
        'title' => __( 'Blog Page Settings', 'luzuk-premium' ),
        // 'panel' => 'luzuk_premium_home_panel'
        'priority' =>19
    )
);

$wp_customize->add_setting('blog_categories_settings', array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control('blog_categories_settings', array(
    'settings' => 'blog_categories_settings',
    'label'    => __('Posts on Blog Page', 'luzuk-premium'),
    'section'  => 'lpremium_blog_area',
    'type'     => 'radio',
    'choices'  => array(
        '0' => __('Excerpts','luzuk-premium'),
        '1' => __('Full Posts','luzuk-premium'),
    ),
));
