<?php 
    $wp_customize->add_section(
        'about_area',
        array(
            'title' => __( 'About Us Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    $wp_customize->add_setting(
        'luzuk_about_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'luzuk_about_area_disable',
            array(
                'settings'      => 'luzuk_about_area_disable',
                'section'       => 'about_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'about', 'about_area', $color='#f9f9f9', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'aboutarea_padding', 'about_area', 'Section Padding');

$wp_customize->add_setting(
    'about_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_areaTpadding',
    array(
        'settings'      => 'about_areaTpadding',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'about_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_areaBpadding',
    array(
        'settings'      => 'about_areaBpadding',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);


  $wp_customize->add_setting(
        'about_image_heading',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'about_image_heading',
            array(
                'settings'      => 'about_image_heading',
                'section'       => 'about_area',
                'label'         => __( 'Left Box', 'luzuk-premium' ),
            )
        )
    );

 $wp_customize->add_setting(
        'about_title_heading',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'about_title_heading',
            array(
                'settings'      => 'about_title_heading',
                'section'       => 'about_area',
                'label'         => __( 'Section Heading & Text', 'luzuk-premium' ),
            )
        )
    );    

    $wp_customize->add_setting(
        'about_title',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Innovative Technology & Nail Services', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'about_title',
        array(
            'settings'      => 'about_title',
            'section'       => 'about_area',
            'type'          => 'text',
            'label'         => __( 'Section Heading', 'luzuk-premium' )
        )
    );

addColorPalatOption($wp_customize, 'about_area_sectitle_color', 'about_area', 'Heading Color ', '#000');

    $wp_customize->add_setting(
        'about_text',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Be sure that you are in good hands with our team of nail specialist who have been in the profession.Cras egestas risus sit amet quam ullamcorper, vel auctor nibh placerat. elit sapien vestibulum magna, nec scelerisque urna enim at sapien', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'about_text',
        array(
            'settings'      => 'about_text',
            'section'       => 'about_area',
            'type'          => 'textarea',
            'label'         => __( 'Section Heading Text', 'luzuk-premium' )
        )
    );

addColorPalatOption($wp_customize, 'about_area_text', 'about_area', 'Section Heading Text color', '#7a7878');

lzCustomLable($wp_customize, 'about_area_hideshow', 'about_area' , 'About Box Hide / Show Setting');

// to show & hide another button
$wp_customize->add_setting( 'about_box_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'about_box_display', array( 'label' => 'About Box Display', 'section' => 'about_area', 'settings' => 'about_box_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Box', 'hide' => 'Hide Box', ), ) ); 


$wp_customize->add_setting('aboutus_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'aboutus_npp_heading',
        array(
            'settings'      => 'aboutus_npp_heading',
            'section'       => 'about_area',
            'label'         => __( 'Number Of About Box To Show ', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('aboutus_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control(
    'aboutus_npp_count',
    array(
        'settings'      => 'aboutus_npp_count',
        'section'       => 'about_area',
        'type'          => 'select',
        'label'         => __( 'Number Of About Box To Show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4,5,6)
    )
);

//ABOUT PAGES
for( $i = 1; $i <= 6; $i++ ){
    $wp_customize->add_setting(
        'aboutus_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'aboutus_header'.$i,
            array(
                'settings'      => 'aboutus_header'.$i,
                'section'       => 'about_area',
                'label'         => __( 'About Box ', 'luzuk-premium' ).$i
            )
        )
    );

lzAddElement($wp_customize, 'aboutus_page_title'.$i, 'about_area', $type = 'text', $label="Title", $callback ='luzuk_sanitize_text', $default='Acrylic overlays and extensions.');  

}

lzCustomLable($wp_customize, 'about_colors', 'about_area', 'Section Color Setting');

addColorPalatOption($wp_customize, 'about_area_pageicon', 'about_area', 'Section List Number Color', '#020202');

addColorPalatOption($wp_customize, 'about_area_pageiconHvClr', 'about_area', 'Section List Number Hover Color', '#fdb1aa');

addColorPalatOption($wp_customize, 'about_area_numberbg', 'about_area', 'Section List Number BG Color', '#fdb1aa');

addColorPalatOption($wp_customize, 'about_area_numberbgHvClr', 'about_area', 'Section List Number BG Hover Color', '#353535');

addColorPalatOption($wp_customize, 'about_area_pagetitle', 'about_area', 'Section List Color', '#353535');

addColorPalatOption($wp_customize, 'about_area_pagetitlehv', 'about_area', 'Section List Hover Color', '#fdb1aa');

lzCustomLable($wp_customize, 'about_btnclr', 'about_area', 'Section Button Setting');


$wp_customize->add_setting(
    'about_btn_txt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Read More' )
    )
);
$wp_customize->add_control(
    'about_btn_txt',
    array(
        'settings'      => 'about_btn_txt',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);
$wp_customize->add_setting('about_btnlink',   array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('about_btnlink',
    array(
        'settings'      => 'about_btnlink',
        'section'       => 'about_area',
        'type'          => 'url',
        'label'         => __( 'Add Button link here', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_abtntext', 'about_area', 'Section Button Text Color', '#000');

addColorPalatOption($wp_customize, 'about_abtntexthv', 'about_area', 'Section Button Text Hover Color', '#fdb1aa');

addColorPalatOption($wp_customize, 'about_abtntextbg', 'about_area', 'Section Button BG Color', '#fdb1aa');

addColorPalatOption($wp_customize, 'about_abtntextbghv', 'about_area', 'Section Button Hover Border Color', '#fdb1aa');

lzCustomLable($wp_customize, 'aboutarea_rhssec', 'about_area', 'Right Box Image Setting ');

lzCustomLable($wp_customize, 'aboutarea_fristimg', 'about_area', 'Image 1');

$wp_customize->add_setting(
'about_image_1',
array(
    'sanitize_callback' => 'esc_url_raw'
)
);
$wp_customize->add_control(
new WP_Customize_Image_Control(
    $wp_customize,
    'about_image_1',
    array(
        'section' => 'about_area',
        'settings' => 'about_image_1',
        'description' => __('Recommended Image Size: 300X300px', 'luzuk-premium')
    )
)
);

lzCustomLable($wp_customize, 'aboutarea_secondimg', 'about_area', 'Image 2');

$wp_customize->add_setting(
'about_image_2',
array(
    'sanitize_callback' => 'esc_url_raw'
)
);
$wp_customize->add_control(
new WP_Customize_Image_Control(
    $wp_customize,
    'about_image_2',
    array(
        'section' => 'about_area',
        'settings' => 'about_image_2',
        'description' => __('Recommended Image Size: 300X300px', 'luzuk-premium')
    )
)
);

lzCustomLable($wp_customize, 'aboutarea_thirdimg', 'about_area', 'Image 3');

$wp_customize->add_setting(
'about_image_3',
array(
    'sanitize_callback' => 'esc_url_raw'
)
);
$wp_customize->add_control(
new WP_Customize_Image_Control(
    $wp_customize,
    'about_image_3',
    array(
        'section' => 'about_area',
        'settings' => 'about_image_3',
        'description' => __('Recommended Image Size: 300X300px', 'luzuk-premium')
    )
)
);

lzCustomLable($wp_customize, 'aboutarea_forthimg', 'about_area', 'Image 4');

$wp_customize->add_setting(
'about_image_4',
array(
    'sanitize_callback' => 'esc_url_raw'
)
);
$wp_customize->add_control(
new WP_Customize_Image_Control(
    $wp_customize,
    'about_image_4',
    array(
        'section' => 'about_area',
        'settings' => 'about_image_4',
        'description' => __('Recommended Image Size: 300X300px', 'luzuk-premium')
    )
)
);

   