<?php
// START CONTACT SECTION 
$wp_customize->add_section(
	'appoi_section',
	array(
		'title'         => __( 'Appointment Section', 'Luzuk Premium' ), 
		'panel'   => 'luzuk_premium_home_panel',
	)
);
    //ENABLE/DISABLE CONTACT SECTION
$wp_customize->add_setting(
	'appoi_disable',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'appoi_disable',
		array(
			'settings'      => 'appoi_disable',
			'section'       => 'appoi_section',
			'label'         => __( 'Disable Section', 'Luzuk Premium' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'Luzuk Premium' ),
				'off' => __( 'No', 'Luzuk Premium' )
			)   
		)
	)
);

backgroundManager($wp_customize, 'appointment', 'appoi_section', $color='#fff', get_template_directory_uri().'/images/default-gray.jpg', 'img');

lzCustomLable($wp_customize, 'appoi_sectionnpadding', 'appoi_section', 'Section Padding');

$wp_customize->add_setting(
    'contactsection_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '7em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'contactsection_toppadding',
    array(
        'settings'      => 'contactsection_toppadding',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'contactsection_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '7em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'contactsection_bottompadding',
    array(
        'settings'      => 'contactsection_bottompadding',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'appoi_bgimage', 'appoi_section', 'Section BG Image');

$wp_customize->add_setting(
'app_image',
array(
    'sanitize_callback' => 'esc_url_raw'
)
);
$wp_customize->add_control(
new WP_Customize_Image_Control(
    $wp_customize,
    'app_image',
    array(
        'section' => 'appoi_section',
        'settings' => 'app_image',
        'description' => __('Recommended Image Size: 300X300px', 'luzuk-premium')
    )
)
);

lzCustomLable($wp_customize, 'app_rhsOverlay', 'appoi_section', 'Section Box Setting');

addColorPalatOption($wp_customize, 'inquiry_rhsolyColor', 'appoi_section', 'Section Box Overlay Color', '#fdb1aa');

addColorPalatOption($wp_customize, 'inquiry_rhsBGColor', 'appoi_section', 'Section Box BG Color', '#fff');

lzCustomLable($wp_customize, 'app-secheading', 'appoi_section', 'Section Heading Setting');

$wp_customize->add_setting(
    'appform_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Contact Form', 'luzuk' )
    )
);
$wp_customize->add_control(
    'appform_maintitle',
    array(
        'settings'      => 'appform_maintitle',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Section Heading', 'luzuk' )
    )
);

addColorPalatOption($wp_customize, 'app_secheadingclr', 'appoi_section', 'Section Heading Color', '#000');

lzCustomLable($wp_customize, 'contactf', 'appoi_section', 'Form Section');


lzCustomLable($wp_customize, 'appointmentright_Form_label', 'appoi_section', 'Contact Form Shortcode');

lzAddElement($wp_customize, 'luzuk_inquiry_shortcode', 'appoi_section', 'textarea', $label="Form Shortcode", 'luzuk_sanitize_text', '[your shortcode]');

//form input text / placeholder color
addColorPalatOption($wp_customize, 'inquiry_forminputtxtClr', 'appoi_section', 'Form Input Text / Placeholder Color', '#8b8989');

addColorPalatOption($wp_customize, 'inquiry_forminputbgColor', 'appoi_section', 'Form Input Border Color', '#8b8989');

//form label color
addColorPalatOption($wp_customize, 'inquiry_formlabelColor', 'appoi_section', 'Form Label Color', '#fff');

//form button text color
addColorPalatOption($wp_customize, 'inquiry_formbuttontextColor', 'appoi_section', 'Form Button Text Color', '#000');

//form button text color
addColorPalatOption($wp_customize, 'inquiry_formbuttontexthoverColor', 'appoi_section', 'Form Button Text Hover Color', '#fff');

//form button background color
addColorPalatOption($wp_customize, 'inquiry_formbuttonbgColor', 'appoi_section', 'Form Button BG Color', '#fdb1aa');

//form button background color
addColorPalatOption($wp_customize, 'inquiry_formbuttonbghoverColor', 'appoi_section', 'Form Button BG Hover Color', '#000');

lzCustomLable($wp_customize, 'appointmentright_contact_section', 'appoi_section', 'Contact Section');

$wp_customize->add_setting(
    'infphtxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '+91 333 7777 222' )
    )
);
$wp_customize->add_control(
    'infphtxt',
    array(
        'settings'      => 'infphtxt',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Section Box Phone Number', 'Luzuk' )
    )
);

$wp_customize->add_setting(
    'infemiltxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'yourmailhere@gmail.com' )
    )
);
$wp_customize->add_control(
    'infemiltxt',
    array(
        'settings'      => 'infemiltxt',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Section Box Email', 'Luzuk' )
    )
);


$wp_customize->add_setting(
    'inftxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '380 St Kilda Road, Melbourne, Australia' )
    )
);
$wp_customize->add_control(
    'inftxt',
    array(
        'settings'      => 'inftxt',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Section Box Address', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'inquiry_phemicnclr', 'appoi_section', 'Section Box Phone, Email & Address Icon Color', '#fdb1aa');

addColorPalatOption($wp_customize, 'inquiry_btntxtclr', 'appoi_section', 'Section Box Phone, Email & Address Text Color', '#030303');

addColorPalatOption($wp_customize, 'inquiry_btntxtphemclr', 'appoi_section', 'Section Box Phone & Email Hover Color', '#fdb1aa');

// ===========Form Section ==========//