<?php
/**
 * Createing a bog pannel for customizer
 *
 *
 */
$categories = get_categories(array('hide_empty' => 0));
foreach ($categories as $category) {
	$cat[$category->term_id] = $category->cat_name;
}
/****************************/
// START BLOG SECTION FOR HOME PAGE
/*============BLOG PANEL============*/
$wp_customize->add_section(
	'blog_area',
	array(
		'title' => __( 'Blog Section', 'luzuk-premium' ),
		'panel' => 'luzuk_premium_home_panel',
     	//'priority' => '50',
	)
);
//ENABLE/DISABLE BLOG SECTION
$wp_customize->add_setting(
	'blog_area_disable',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'blog_area_disable',
		array(
			'settings'      => 'blog_area_disable',
			'section'       => 'blog_area',
			'label'         => __( 'Disable Section', 'luzuk-premium' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'luzuk-premium' ),
				'off' => __( 'No', 'luzuk-premium' )
			)   
		)
	)
);

backgroundManager($wp_customize, 'blog', 'blog_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');


lzCustomLable($wp_customize, 'blog_area_blogsectionpadding', 'blog_area', 'Section Padding');

$wp_customize->add_setting(
    'blog_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blog_areaTpadding',
    array(
        'settings'      => 'blog_areaTpadding',
        'section'       => 'blog_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'blog_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blog_areaBpadding',
    array(
        'settings'      => 'blog_areaBpadding',
        'section'       => 'blog_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
	'blog_title_subtitle_heading',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text'
	)
);
$wp_customize->add_control(
	new luzuk_Customize_Heading(
		$wp_customize,
		'blog_title_subtitle_heading',
		array(
			'settings'      => 'blog_title_subtitle_heading',
			'section'       => 'blog_area',
			'label'         => __( 'Section Heading', 'luzuk-premium' ),
		)
	)
);

$wp_customize->add_setting(
	'blog_title_title',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'Beauty Blog', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'blog_title_title',
	array(
		'settings'      => 'blog_title_title',
		'section'       => 'blog_area',
		'type'          => 'text',
		'label'         => __( 'Section Heading', 'luzuk-premium' )
	)
);

addColorPalatOption($wp_customize, 'blogarea_sectitle_color', 'blog_area', 'Section Heading Color', '#000');

$wp_customize->add_setting(
	'blog_text',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec interdum, magna vel mattis molestie, mi felis placerat quam', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'blog_text',
	array(
		'settings'      => 'blog_text',
		'section'       => 'blog_area',
		'type'          => 'textarea',
		'label'         => __( 'Section text', 'luzuk-premium' )
	)
);

addColorPalatOption($wp_customize, 'blog_textclr', 'blog_area', 'Section Text Color', '#000');

lzCustomLable($wp_customize, 'blogpostsetting', 'blog_area', 'Number Of Post To Show');

//BLOG SETTINGS
$wp_customize->add_setting(
	'blog_post_count',
	array(
		'default'           => '3',
		'sanitize_callback' => 'luzuk_sanitize_choices'
	)
);
$wp_customize->add_control(
	new luzuk_Dropdown_Chooser(
		$wp_customize,
		'blog_post_count',
		array(
			'settings'      => 'blog_post_count',
			'section'       => 'blog_area',
			'label'         => __( 'Number Of Post To Show', 'luzuk-premium' ),
			'choices'       => $luzuk_post_count_choice
		)
	)
);

$wp_customize->add_setting('luzuk_blog_categories', array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Customize_Checkbox_Multiple(
		$wp_customize,
		'luzuk_blog_categories',
		array(
			'label' => __('Exclude Category from Blog Posts', 'luzuk-premium'),
			'section' => 'premium_blog_area',
			'settings' => 'luzuk_blog_categories',
			'choices' => $luzuk_cat
		)
	)
);
lzCustomLable($wp_customize, 'blogcolor', 'blog_area', 'Section Color');

addColorPalatOption($wp_customize, 'blogarea_imghv1_clr', 'blog_area', 'Blog Image Hover Color', '#fdb1aa');

addColorPalatOption($wp_customize, 'blogarea_blgbxbg_color', 'blog_area', 'Blog Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'blogarea_datetext_color', 'blog_area', 'Blog Date & Icon Color', '#000');

addColorPalatOption($wp_customize, 'blogarea_Title_color', 'blog_area', 'Blog Title Color', '#000');

addColorPalatOption($wp_customize, 'blogarea_Txt_color', 'blog_area', 'Blog Text Color', '#000');

// button
lzCustomLable($wp_customize, 'buttontexts', 'blog_area', 'Section Button Setting');

$wp_customize->add_setting(
        'blog_button',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Read More', 'Luzuk' )
        )
    );
    $wp_customize->add_control(
        'blog_button',
        array(
            'settings'      => 'blog_button',
            'section'       => 'blog_area',
            'type'          => 'text',
            'label'         => __( 'Add Button Text', 'Luzuk' )
        )
    ); 


addColorPalatOption($wp_customize, 'blog_btntxtclr', 'blog_area', 'Section Button Text Color', '#000');

addColorPalatOption($wp_customize, 'blog_btntxtBGclr', 'blog_area', 'Section Button BG Color', '#fdb1aa');

addColorPalatOption($wp_customize, 'blog_btntxthvclr', 'blog_area', 'Section Button Text Hover Color', '#000');

addColorPalatOption($wp_customize, 'blog_btnHvBrdclr', 'blog_area', 'Section Button Hover Border Color', '#000');
