<?php
/**
 * Createing an Our Pets pannel for customizer
 */

// START ABOUT SECTION 
$wp_customize->add_section(
    'features_section',
    array(
        'title' => __( 'Features Section', 'luzuk-premium' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);
    // ENABLE/DISABLE FEATURED SECTION
$wp_customize->add_setting(
    'features_section_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'features_section_disable',
        array(
            'settings'      => 'features_section_disable',
            'section'       => 'features_section',
            'label'         => __( 'Disable Section', 'luzuk-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk-premium' ),
                'off' => __( 'No', 'luzuk-premium' )
            ),
        )
    )
);

backgroundManager($wp_customize, 'features', 'features_section', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');


lzCustomLable($wp_customize, 'luzuk_featuressectionpadding', 'features_section', 'Section Padding');

$wp_customize->add_setting(
    'sec_featuresTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk' )
    )
);
$wp_customize->add_control(
    'sec_featuresTpadding',
    array(
        'settings'      => 'sec_featuresTpadding',
        'section'       => 'features_section',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk' )
    )
);
$wp_customize->add_setting(
    'sec_featuresBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk' )
    )
);
$wp_customize->add_control(
    'sec_featuresBpadding',
    array(
        'settings'      => 'sec_featuresBpadding',
        'section'       => 'features_section',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk' )
    )
);

$wp_customize->add_setting('luzuk_features_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'luzuk_features_npp_heading',
        array(
            'settings'      => 'luzuk_features_npp_heading',
            'section'       => 'features_section',
            'label'         => __( 'Number Of Features To Show', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('luzuk_features_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control(
    'luzuk_features_npp_count',
    array(
        'settings'      => 'luzuk_features_npp_count',
        'section'       => 'features_section',
        'type'          => 'select',
        'label'         => __( 'Number Of Features Box To Show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
    )
);

//about PAGES
for( $i = 1; $i <= 12; $i++ ){
    $wp_customize->add_setting(
        'luzuk_features_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'luzuk_features_header'.$i,
            array(
                'settings'      => 'luzuk_features_header'.$i,
                'section'       => 'features_section',
                'label'         => __( 'Section Box ', 'luzuk-premium' ).$i
            )
        )
    );
$wp_customize->add_setting(
        'features_page_icon1'.$i,
        array(
            'default'           => 'fa fa-scissors',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'features_page_icon1'.$i,
            array(
                'settings'      => 'features_page_icon1'.$i,
                'section'       => 'features_section',
                'type'          => 'icon',
                'label'         => __( 'Font Awesome Icon', 'Luzuk' ),
            )
        )
    );

lzAddElement($wp_customize, 'features_page_title_'.$i, 'features_section', $type = 'text', $label="Section Title", $callback ='luzuk_sanitize_text', $default='Gel Overlay');

lzAddElement($wp_customize, 'features_page_text_'.$i, 'features_section', $type = 'text', $label="Section Text", $callback ='luzuk_sanitize_text', $default='Be sure that you are in good hands with our team of nail specialist who have been in the profession.');

lzAddElement($wp_customize, 'luzuk_features_page_url_'.$i, 'features_section', $type = 'text', $label="Featured Page Link", $callback ='esc_url', $default='Add link here');

}
  
lzCustomLable($wp_customize, 'featurescolor', 'features_section', 'Section Colors');

addColorPalatOption($wp_customize, 'membe_boxBgColor', 'features_section', 'Feature Box BG Color ', '#fcfbfa');

addColorPalatOption($wp_customize, 'membe_boxtopbrdColor', 'features_section', 'Feature Box Top Border & BG Hover Color ', '#fdb1aa');

addColorPalatOption($wp_customize, 'membe_boxiconColor', 'features_section', 'Section Icon Color ', '#fdb1aa');

addColorPalatOption($wp_customize, 'membe_boxiconBGColor', 'features_section', 'Section Icon BG Color ', '#fcf5f4');

addColorPalatOption($wp_customize, 'membe_pagettl', 'features_section', 'Section Title Color ', '#000');

addColorPalatOption($wp_customize, 'membe_pagettlhv', 'features_section', 'Section Title Hover Color ', '#000');

addColorPalatOption($wp_customize, 'membe_pagetextclr', 'features_section', 'Section Text Color ', '#6e6d6d');

addColorPalatOption($wp_customize, 'membe_pagetexthvclr', 'features_section', 'Section Text Hover Color ', '#6e6d6d');

