<?php
$wp_customize->add_section(
    'newsletter_area',
    array(
        'title' => __('Newsletter Section', 'luzuk-premium' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);
$wp_customize->add_setting(
    'newsletter_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);

$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'newsletter_area_disable',
        array(
            'settings'      => 'newsletter_area_disable',
            'section'       => 'newsletter_area',
            'label'         => __( 'Disable Section', 'luzuk-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk-premium' ),
                'off' => __( 'No', 'luzuk-premium' )
            ),
        )
    )
);

backgroundManager($wp_customize, 'newsletter', 'newsletter_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');


lzCustomLable($wp_customize, 'newsletterarea_padding', 'newsletter_area', 'Section Padding');

$wp_customize->add_setting(
    'newsletter_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newsletter_areaTpadding',
    array(
        'settings'      => 'newsletter_areaTpadding',
        'section'       => 'newsletter_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'newsletterr_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '7em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newsletterr_areaBpadding',
    array(
        'settings'      => 'newsletterr_areaBpadding',
        'section'       => 'newsletter_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'newsletter_Box', 'newsletter_area', 'Newsletter Box Setting');

addColorPalatOption($wp_customize, 'newsletterarea_boxBGcolor', 'newsletter_area', 'Newsletter Box BG Color', '#fdb1aa');

$wp_customize->add_setting(
    'newsletter_page_maintitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'newsletter_page_maintitle_heading',
        array(
            'settings'      => 'newsletter_page_maintitle_heading',
            'section'       => 'newsletter_area',
            'label'         => __( 'Section Heading', 'luzuk-premium' ),
        )
    )
);    
 

$wp_customize->add_setting(
    'newsletter_page_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Subscribe To Our Newsletter', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newsletter_page_maintitle',
    array(
        'settings'      => 'newsletter_page_maintitle',
        'section'       => 'newsletter_area',
        'type'          => 'text',
        'label'         => __( 'Section Heading ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'newsletterarea_title_color', 'newsletter_area', 'Section Heading Color', '#000');


lzCustomLable($wp_customize, 'newsletter_Form_label', 'newsletter_area', 'Newsletter Form Shortcode');

lzAddElement($wp_customize, 'luzuk_newsletter_shortcode', 'newsletter_area', 'textarea', $label="Form Shortcode", 'luzuk_sanitize_text', '[your shortcode]');

addColorPalatOption($wp_customize, 'newsletter_forminputbgColor', 'newsletter_area', 'Form Input BG Color', '#fff');

addColorPalatOption($wp_customize, 'newsletter_forminputtextColor', 'newsletter_area', 'Form Input Text / Placeholder Color', '#63636387');

addColorPalatOption($wp_customize, 'newsletter_formlabelColor', 'newsletter_area', 'Form Label Color', '#101a37');

addColorPalatOption($wp_customize, 'newsletter_formbuttontextColor', 'newsletter_area', 'Form Button Text Color', '#000');

addColorPalatOption($wp_customize, 'newsletter_formbuttontexthoverColor', 'newsletter_area', 'Form Button Text Hover Color', '#fff');

addColorPalatOption($wp_customize, 'newsletter_formbuttonbgColor', 'newsletter_area', 'Form Button BG Color', '#fff');

addColorPalatOption($wp_customize, 'newsletter_formbuttonbgHVColor', 'newsletter_area', 'Form Button BG Hover Color', '#000');
