<?php 
$wp_customize->add_section(
    'service_area',
    array(
        'title'         => __( 'Services Section', 'Luzuk' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);
$wp_customize->add_setting(
    'service_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'service_area_disable',
        array(
            'settings'      => 'service_area_disable',
            'section'       => 'service_area',
            'label'         => __( 'Disable Section', 'Luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'Luzuk' ),
                'off' => __( 'No', 'Luzuk' )
            )   
        )
    )
);

backgroundManager($wp_customize, 'service', 'service_area', $color='#fdf5f4', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'luzuk_sec_servicessectionpadding', 'service_area', 'Section Padding');

$wp_customize->add_setting(
    'service_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaTpadding',
    array(
        'settings'      => 'service_areaTpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'service_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '9em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaBpadding',
    array(
        'settings'      => 'service_areaBpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);


lzCustomLable($wp_customize, 'Service_bgimage', 'service_area', 'Section BG Image');

$wp_customize->add_setting(
'service_image',
array(
    'sanitize_callback' => 'esc_url_raw'
)
);
$wp_customize->add_control(
new WP_Customize_Image_Control(
    $wp_customize,
    'service_image',
    array(
        'section' => 'service_area',
        'settings' => 'service_image',
        'description' => __('Recommended Image Size: 300X300px', 'luzuk-premium')
    )
)
);


$wp_customize->add_setting(
    'ser_title_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'ser_title_subtitle_heading',
        array(
            'settings'      => 'ser_title_subtitle_heading',
            'section'       => 'service_area',
            'label'         => __( 'Section Heading ', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'ser_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Our Service', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'ser_title',
    array(
        'settings'      => 'ser_title',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Section Heading', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'services_titleclr', 'service_area', 'Section Heading Color ', '#fff');

$wp_customize->add_setting(
    'ser_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec aliquam nisi. Suspendisse diam massa, vestibulum ut magna nec, lobortis suscipit nisi. Ut dolor turpis', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'ser_text',
    array(
        'settings'      => 'ser_text',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Section Text', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'services_titlebrdclr', 'service_area', 'Section Text Color ', '#fff');

$wp_customize->add_setting('service_area_lbl2', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'service_area_lbl2',
        array(
            'settings'      => 'service_area_lbl2',
            'section'       => 'service_area',
            'label'         => __( 'Note:', 'Luzuk' ),  
            'description'   => __( '{a} Use Shortcode [SERVICES] to show all services in a page.
             {b} Image use same height(350px*300px)', 'Luzuk' ),
        )
    )
);



lzCustomLable($wp_customize, 'luzuk_Services_Numbershow', 'service_area', 'Number Of Services To Show');

$wp_customize->add_setting('service_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control(
    'service_npp_count',
    array(
        'settings'      => 'service_npp_count',
        'section'       => 'service_area',
        'type'          => 'select',
        'label'         => __( 'Number Of Services To Show', 'Luzuk' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10)
    )
);

$ServicesSingleChoice[] = 'Select';
for( $i = 1; $i <= 9; $i++ ){
    $wp_customize->add_setting(
        'services_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'services_heading'.$i,
            array(
                'settings'      => 'services_heading'.$i,
                'section'       => 'service_area',
                'label'         => __( 'Service Box ', 'Luzuk' ).$i,
            )
        )
    );
    if(is_array($ServicesSingleChoice)){
        $wp_customize->add_setting(
            'services_page'.$i,
            array(
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(
            'services_page'.$i,
            array(
                'settings'      => 'services_page'.$i,
                'section'       => 'service_area',
                'type'=> 'select',
                'label'         => __( 'Select A Service Page ', 'Luzuk' ),
                'choices' => $ServicesSingleChoice,
            )
        );

        $wp_customize->add_setting(
                'services_page_icon1'.$i,
                array(
                    'default'           => 'fa fa-eye',
                    'sanitize_callback' => 'luzuk_sanitize_text'
                )
            );        
            $wp_customize->add_control(
                new luzuk_Fontawesome_Icon_Chooser(
                    $wp_customize,
                    'services_page_icon1'.$i,
                    array(
                        'settings'      => 'services_page_icon1'.$i,
                        'section'       => 'service_area',
                        'type'          => 'icon',
                        'label'         => __( 'Font Awesome Icon', 'Luzuk' ),
                    )
                )
            );

    }else{
        $wp_customize->add_setting('service_area_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
        $wp_customize->add_control(
            new luzuk_Info_Text( 
                $wp_customize,
                'service_area_lbl'.$i,
                array(
                    'settings'      => 'service_area_lbl'.$i,
                    'section'       => 'service_area',
                    'label'         => __( 'Note:', 'Luzuk' ),    
                    'description'   => __( '<strong>Changes will not reflect unless you select the Service Page.</strong> <br/>Please add the Services from "Services menu" and then select Services to show information.', 'Luzuk' ),
                )
            )
        );
    }
 
}

lzCustomLable($wp_customize, 'services_bxclr', 'service_area', 'Section Color');

addColorPalatOption($wp_customize, 'services_Sericnbxbgclr', 'service_area', 'Section Box BG Color ', '#fcfbfa');

addColorPalatOption($wp_customize, 'services_ServicePageTitleColor', 'service_area', 'Section Title Color ', '#030303');

addColorPalatOption($wp_customize, 'services_ServicePageTitlehvColor', 'service_area', 'Section Title Hover Color ', '#fff');

addColorPalatOption($wp_customize, 'services_ServicePageIconColor', 'service_area', 'Section Icon Color ', '#fdb1a9');

addColorPalatOption($wp_customize, 'services_ServicePageIconHvColor', 'service_area', 'Section Icon Hover Color ', '#fff');

addColorPalatOption($wp_customize, 'services_textClr', 'service_area', 'Section Text Color ', '#706e6e');

addColorPalatOption($wp_customize, 'services_btntextClr', 'service_area', 'Section Arrow Icon Color ', '#000');

addColorPalatOption($wp_customize, 'services_btntexthvClr', 'service_area', 'Section Arrow Icon Hover Color ', '#fff');

addColorPalatOption($wp_customize, 'services_Sericnimgclr', 'service_area', 'Section Arrow BG Color ', '#fdb1aa');

lzCustomLable($wp_customize, 'services_button', 'service_area', 'Section Button');

$wp_customize->add_setting(
    'ser_button',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Read More', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'ser_button',
    array(
        'settings'      => 'ser_button',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Section Button Text', 'luzuk-premium' )
    )
);

$wp_customize->add_setting('service_btnlink',   array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('service_btnlink',
    array(
        'settings'      => 'service_btnlink',
        'section'       => 'service_area',
        'type'          => 'url',
        'label'         => __( 'Add Button link here', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'services_button_txtclr', 'service_area', 'Section Button Text Color ', '#000');

addColorPalatOption($wp_customize, 'services_button_txtHVclr', 'service_area', 'Section Button Text Hover Color ', '#000');

addColorPalatOption($wp_customize, 'services_button_BGclr', 'service_area', 'Section Button BG Color ', '#fdb1aa');

addColorPalatOption($wp_customize, 'services_button_HVBrdclr', 'service_area', 'Section Button Hover Border Color ', '#fdb1aa');

