<?php  

$luzukSliderSingleChoice = getFitnessPostsType('slider');
$wp_customize->add_section(
	'slider_section',
	array(
		'title' => __( 'Slider Section', 'Luzuk' ),
        'panel' => 'luzuk_premium_home_panel',
		'priority' =>18
	)
);
$wp_customize->add_setting(
	'slider_section_show_content',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'slider_section_show_content',
		array(
			'settings'      => 'slider_section_show_content',
			'section'       => 'slider_section',
			'label'         => __( 'Hide Slider Content', 'Luzuk' ),
			'on_off_label'  => array(
				'on' => __( 'No', 'Luzuk' ),
				'off' => __( 'Yes', 'Luzuk' )
			),
		)
	)
);
$wp_customize->add_setting('slider_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Info_Text( 
		$wp_customize,
		'slider_section_lbl',
		array(
			'settings'		=> 'slider_section_lbl',
			'section'		=> 'slider_section',
			'label'			=> __( 'Note:', 'Luzuk' ),	
			'description'	=> __( 'The page featured image works as a banner and the title & content work as a slider caption. You can add this from the Slider menu. <br/> Recommended Image Size: 1140X950', 'Luzuk' ),
		)
	)
);

lzCustomLable($wp_customize, 'slidersarea_Backgrouond', 'slider_section', 'Set Background');

addColorPalatOption($wp_customize, 'slider_BG_color', 'slider_section', 'Slider BG Color', '#fff');

lzCustomLable($wp_customize, 'slidersarea_Overlay', 'slider_section', 'Set Overlay');

$wp_customize->add_setting(
    'slider_areaOpacity',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.5', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'slider_areaOpacity',
    array(
        'settings'      => 'slider_areaOpacity',
        'section'       => 'slider_section',
        'type'          => 'text',
        'label'         => __( 'Opacity', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'slider_olybg_clr', 'slider_section', 'Slider Overlay Color', '#000');

lzCustomLable($wp_customize, 'luzuk_sliderotherclrs', 'slider_section', 'Slider Color Setting');

addColorPalatOption($wp_customize, 'slider_titlehighlightColor', 'slider_section', 'Title Highlight Color', '#fdb1aa');

addColorPalatOption($wp_customize, 'slider_titleColor', 'slider_section', 'Title Color', '#fff');

addColorPalatOption($wp_customize, 'slider_SubtitleColor', 'slider_section', 'Text Color', '#fff');

addColorPalatOption($wp_customize, 'slider_ButtontextColor', 'slider_section', 'Button Text Color', '#000');

addColorPalatOption($wp_customize, 'slider_ButtontexthoverColor', 'slider_section', 'Button Text Hover Color', '#fdb1aa');

addColorPalatOption($wp_customize, 'slider_Buttonibrd', 'slider_section', 'Button BG Color', '#fdb1aa');

addColorPalatOption($wp_customize, 'slider_Buttonihv', 'slider_section', 'Button Hover Border Color', '#fdb1aa');

addColorPalatOption($wp_customize, 'slider_arrowcolor', 'slider_section', 'Slider Arrow Color', '#fff');

addColorPalatOption($wp_customize, 'slider_arrowHVcolor', 'slider_section', 'Slider Arrow Hover Color', '#fdb1aa');


