<?php  
// TESTIMONIALS SECTION START HERE 

$wp_customize->add_section(
    'testimonials_area',
    array(
        'title'         => __( 'Testimonials Section', 'Luzuk Premium' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);
    //ENABLE/DISABLE TESTIMONIALS SECTION
$wp_customize->add_setting(
    'testimonials_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'testimonials_area_disable',
        array(
            'settings'      => 'testimonials_area_disable',
            'section'       => 'testimonials_area',
            'label'         => __( 'Disable Section', 'Luzuk Premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'Luzuk Premium' ),
                'off' => __( 'No', 'Luzuk Premium' )
            )   
        ) 
    )
);
 
backgroundManager($wp_customize, 'testimonials', 'testimonials_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'luzuk_sec_blogsectionpadding', 'testimonials_area', 'Section Padding');

$wp_customize->add_setting(
    'testimonials_areaTpadding', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '7em', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'testimonials_areaTpadding',
    array(
        'settings'      => 'testimonials_areaTpadding',
        'section'       => 'testimonials_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'Luzuk Premium' )
    )
);
$wp_customize->add_setting(
    'testimonials_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5em', 'Luzuk Premium' )
    )
);
$wp_customize->add_control(
    'testimonials_areaBpadding',
    array(
        'settings'      => 'testimonials_areaBpadding',
        'section'       => 'testimonials_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'Luzuk Premium' )
    )
);

$TesimonialsSingleChoice[] = 'select';
if(!is_array($TesimonialsSingleChoice)){
    $wp_customize->add_setting('testimonials_area_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
    $wp_customize->add_control(
        new luzuk_Info_Text( 
            $wp_customize,
            'testimonials_area_lbl',
            array(
                'settings'      => 'testimonials_area_lbl',
                'section'       => 'testimonials_area',
                'label'         => __( 'Note:', 'Luzuk Premium' ), 
                'description'   => __( '<strong>Changes will not reflect unless you select the Testimonials.</strong> <br/>Please add the Testimonials from "Testimonials menu" and then select Testimonial to show information.', 'Luzuk Premium' ),
            )
        )
    );
}
$wp_customize->add_setting('luzuk_premium_testimonials_area_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_testimonials_area_lbl',
        array(
            'settings'      => 'luzuk_premium_testimonials_area_lbl',
            'section'       => 'testimonials_area',
            'label'         => __( 'Note:', 'Luzuk Premium' ), 
            'description'   => __( 'Just place the shortcode "[TESTIMONIALS]" in your page to list the Testimonials in a page ', 'Luzuk Premium' ),
        )
    )
);
//TESTIMONIALS PAGES
for( $i = 1; $i < 10; $i++ ){
    $wp_customize->add_setting(
        'luzuk_testimonials_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'luzuk_testimonials_heading'.$i,
            array(
                'settings'      => 'luzuk_testimonials_heading'.$i,
                'section'       => 'testimonials_area',
                'label'         => __( 'Testimonial ', 'Luzuk Premium' ).$i,
            )
        )
    );
    $wp_customize->add_setting(
        'testimonials_page'.$i,
        array(
            'sanitize_callback' => 'absint'
        )
    );
    $wp_customize->add_control(
        'testimonials_page'.$i,
        array(
            'settings'      => 'testimonials_page'.$i,
            'section'       => 'testimonials_area',
            'type'=> 'select',
            'label'         => __( 'Select A Client Testimonial', 'Luzuk Premium' ),
            'choices' => $TesimonialsSingleChoice,
        )
    );
}

lzCustomLable($wp_customize, 'clientcolor', 'testimonials_area', 'Section Colors');

addColorPalatOption($wp_customize, 'luzuk_testimonials_icnclr', 'testimonials_area', 'Section Icon Color', '#dedddd');

addColorPalatOption($wp_customize, 'luzuk_testimonials_icnhvclr', 'testimonials_area', 'Section Icon Hover Color', '#fdb1a9');

addColorPalatOption($wp_customize, 'luzuk_testimonialscontent_textcolor', 'testimonials_area', ' Section Text Color', '#888787');

addColorPalatOption($wp_customize, 'luzuk_testimonials_Namecolor', 'testimonials_area', 'Section Client Name Color', '#020202');

addColorPalatOption($wp_customize, 'luzuk_testimonials_desiclr', 'testimonials_area', 'Section Client Designation Color', '#828080');

addColorPalatOption($wp_customize, 'luzuk_testimonials_imgHVbrdclr', 'testimonials_area', 'Section Image Hover Border Color', '#fdb1a9');

addColorPalatOption($wp_customize, 'testi_sliderdgclr', 'testimonials_area', 'Slider Arrow Color', '#acaaaa');

addColorPalatOption($wp_customize, 'testi_sliderdghvclr', 'testimonials_area', 'Slider Arrow Hover Color', '#000');

addColorPalatOption($wp_customize, 'testi_sliderdghvhvclr', 'testimonials_area', 'Slider Arrow BG Hover Color', '#fdb1a9');