<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package LZ Fitness Premium
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link href="https://fonts.googleapis.com/css?family=Raleway:600" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Raleway:300,400" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Aguafina+Script" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Poppins" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Anton|Passion+One" rel="stylesheet">

	<link href="https://fonts.googleapis.com/css?family=Bree+Serif" rel="stylesheet">
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>
	<!-- <script src="<?php echo get_template_directory_uri(); ?>/js/jquery.min.js" crossorigin="anonymous"></script> -->

	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>
	<?php wp_head(); ?>


</head>

<body <?php body_class(); ?>>
	<div class="main-container">
		<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'luzuk-premium' ); ?></a>
		<header id="ht-masthead" class="ht-site-header">
			<div class="main-header">
				<div class="container">
					<div class="col-md-8 col-sm-8">
						<?php 
						$email = get_theme_mod('lz_fitness_headermain_email', 'info@companyname.com');
						$location = get_theme_mod('lz_fitness_headermain_location', '9870 St Vinset Place,Glasgow, DC 45 Fr 45');
							//$time = get_theme_mod('lz_fitness_contactus_time', 'Mon-Sat 0900-1900');
						?>
						<div class="header-right-box">
							<div class="header-menu-box">
								
									
								<?php if($email){ ?>
								<i class="fa fa-envelope"></i>
								<a href="mailto:<?php echo $email;?>"><?php echo ($email);?></a>
								<?php } ?>									
							     
									<?php if($location){ ?>
										<i class="fa fa-map-marker"></i>
									<?php echo esc_html($location);  ?>
								<?php } ?>
									<!-- <i class="fa fa-map-marker"></i>
									<?php // echo $location;?> -->
							          

							</div>
							</div>
						</div>
						<div class="col-md-4 pull-right col-sm-4">
							<div class="col-sm-12 upper-header padding0">					
								<?php 
								$email = get_theme_mod('lz_fitness_headermain_email', 'info@companyname.com');
								$location = get_theme_mod('lz_fitness_headermain_location', '9870 St Vinset Place,Glasgow, DC 45 Fr 45');

								$facebook = get_theme_mod('lz_fitness_header_fb','Facebook');
								$twitter = get_theme_mod('lz_fitness_header_tw','Twitter');
								$instagram = get_theme_mod('lz_fitness_header_it','Instagram');
								$linkedIn = get_theme_mod('lz_fitness_header_in','Linked In');
								?>
								<div class="header-social-links">
									<?php if(!empty($facebook)){ ?>
									<a href="<?php echo $facebook ?>" target="_blank" title="Facebook"><span class="fa fa-facebook"></span></a>
									<?php }?>
									<?php if(!empty($twitter)){ ?>
									<a href="<?php echo $twitter ?>" target="_blank" title="Twitter"><span class="fa fa-twitter"></span></a>
									<?php }?>
									<?php if(!empty($linkedIn)){ ?>
									<a href="<?php echo $linkedIn ?>" target="_blank" title="Linked In"><span class="fa fa-linkedin"></span></a>
									<?php }?>
									<?php if(!empty($instagram)){ ?>
									<a href="<?php echo $instagram ?>" target="_blank" title="Instagram"><span class="fa fa-instagram"></span></a>
									<?php }?>
								</div>
							</div>
						</div>	
					</div>	
				</div>
				<div class="lower-header">
				<div class="container">	

					<div class="header-left col-md-3 col-sm-12 padding0">
						<?php 
							if( get_theme_mod('pages_logoTmargin',true) ) {
				                $pages_logoTmargin = 'margin-top:'.esc_attr(get_theme_mod('pages_logoTmargin')).';';
				            }
				            if( get_theme_mod('pages_logoBmargin',true) ) {
				                $pages_logoBmargin = 'margin-bottom:'.esc_attr(get_theme_mod('pages_logoBmargin')).';';
				            }
				            if( get_theme_mod('pages_logoLmargin',true) ) {
				                $pages_logoLmargin = 'margin-left:'.esc_attr(get_theme_mod('pages_logoLmargin')).';';
				            }
				            if( get_theme_mod('pages_logoRmargin',true) ) {
				                $pages_logoRmargin = 'margin-right:'.esc_attr(get_theme_mod('pages_logoRmargin')).';';
				            }
	 					?>
						<div class="logobox"  style="<?php echo esc_attr($pages_logoTmargin); ?>" "<?php echo esc_attr($pages_logoBmargin); ?>" "<?php echo esc_attr($pages_logoLmargin); ?>" "<?php echo esc_attr($pages_logoRmargin); ?>">
							<?php 
							if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
								the_custom_logo();
							else : 
								if ( is_front_page() ) : ?>
								<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
							<?php else : ?>
								<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
							<?php endif; ?>
							<p class="ht-site-description"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'description' ); ?></a></p>
						<?php endif; ?>
						<!-- .site-branding -->
					</div>
				</div>
				<div class="col-md-8 col-md-offset-1">
					<nav id="ht-site-navigation" class="ht-main-navigation">
						
						<div class="toggle-bar"><span><i class="fa fa-bars" aria-hidden="true"></i></span></div>
						<?php 
						wp_nav_menu( array( 
							'theme_location' => 'primary', 
							'container_class' => 'ht-menu clearfix' ,
							'menu_class' => 'ht-clearfix',
							'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
						) ); 
						?>

					</nav><!-- #ht-site-navigation -->
				</div>
			</div>
</div>
		</header><!-- #masthead -->
	</div>
