<?php



/**
 * Liting the team/trainer details 
 * @param : int $pageId default is null
 * @param : boolean $isCustomizer default is false, if set to true will get the data stored with customizer
 * @param : int $i default is null, it will used as a iteration for data with customizer, this will be used only if the $isCustomizer is set to true.
 * @return: Text $text
 */


/**
 * Use for the show the testimonials at home page and in testimonial page with shortcode
 * @param int $pageId default is null the id of a post
 * @param boolean $isCustomizer default is false if set to true it mean the output is set for the home page
 * @param int $i default null
 * @param boolean $showStaticVals default is false
 * @return string
 * @author Luzuk Premium <support@luzuk.com>
 * */

function testimonialShortCode($pageId = null, $isCustomizer = false, $i = null) {

    ob_start();

    $args = array('post_type' => 'our-testimonial');
    if (!empty($pageId)) {
        $args['page_id'] = absint($pageId);
    }
    $colCls = '';
    // if($isCustomizer == true){
    $cols = get_theme_mod('lz_fitness_test_npp_count', 2);
    $cols++;
    switch($cols){
        
            }
           $icons = array(1=>'heart', 2=>'star', 3=>'flash', 4=>'bell',5=>'heart', 6=>'star', 7=>'flash', 8=>'bell');     
    // }
    $text = '';
    $query = new WP_Query($args);
    if ($query->have_posts()):
        $postN = 0;

        while ($query->have_posts()) : $query->the_post();
            $lz_fitness_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'total-team-thumb');
            if ($isCustomizer === true) {
                $lz_fitness_test_designation = get_theme_mod('lz_fitness_test_designation' . $i);
            }
            $post = get_post();
            //designation
            $designation = get_post_meta($post->ID, 'designation', false);
            $lz_fitness_test_designation = !empty($designation[0]) ? $designation[0] : '';

            if (($postN % 3) == 0 && $isCustomizer == false) {
                ?>
                <div class="clearfix paddingBot20"></div>
            </div>
            <div class="row">
                <?php
            }
            ++$postN;
            ?>
            <div class="item col-md-4 col-sm-6 padding0">
                <div class="testimonial-content">
                              <p><?php
                                if (has_excerpt()) {
                                    echo get_the_excerpt();
                                } else {
                                    echo get_the_content();
                                }
                                ?>
                            </p>
                            <img src="<?php echo (!empty($lz_fitness_image[0])) ? $lz_fitness_image[0] : get_template_directory_uri() . '/images/team-thumb.png' ?>" class="img-responsive" alt="<?php the_title(); ?>" />
                             <h3 class="secondry-text"><?php the_title(); ?></h3>
                        </div>

                        <script>
                            jQuery.noConflict();
                            $(function(){
                                function testimonialcontentHeight(){
                                    var ht = 0;
                                    $('#innerpage-box .testimonial-content').each(function(i){
                                        var tHt = $(this).height();
                                        if(ht<tHt){
                                            ht=tHt;
                                        }
                                    });
                                    $('#innerpage-box .testimonial-content').height(ht+'px');
                                }
                                testimonialcontentHeight();
                            });
                            $( window ).resize(function(){
                                testimonialcontentHeight();
                            });
                        </script>           
            </div>
        <?php
    endwhile;
    $text = ob_get_contents();
    ob_clean();
endif;
wp_reset_postdata();
return $text;
}

add_shortcode('TESTIMONIALS', 'testimonialShortCode');



