<?php
/**
 * Customiser section for support
 **/
// Start Support section 
$wp_customize->add_section(
    'lz_fitness_facility_section',
    array(
        'title' => __( 'Facility Section', 'luzuk-premium' ),
        'panel' => 'lz_fitness_premium_home_panel'
    )
);
// ENABLE/DISABLE SUPPORT SECTION
$wp_customize->add_setting(
    'lz_fitness_facility_section_disable',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
    )
);
$wp_customize->add_control(
    new lz_fitness_Switch_Control(
        $wp_customize,
        'lz_fitness_facility_section_disable',
        array(
            'settings'      => 'lz_fitness_facility_section_disable',
            'section'       => 'lz_fitness_facility_section',
            'label'         => __( 'Disable Section', 'luzuk-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk-premium' ),
                'off' => __( 'No', 'luzuk-premium' )
            ),
        )
    )
);

// backgroundManager($wp_customize, 'facility', 'lz_fitness_facility_section', $color='#ffffff', get_template_directory_uri().'/images/aboutbanner.png', 'img');

backgroundManager($wp_customize, 'facility', 'lz_fitness_facility_section', $color='#ffffff', get_template_directory_uri().'/images/blogbs.png', 'color');



$wp_customize->add_setting(
    'lz_fitness_facility_title_sub_title_heading',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text'
    )
);
$wp_customize->add_control(
   new lz_fitness_Customize_Heading(
    $wp_customize,
        'lz_fitness_facility_title_sub_title_heading',
        array(
            'settings'      => 'lz_fitness_facility_title_sub_title_heading',
            'section'       => 'lz_fitness_facility_section',
            'label'         => __( 'Section Title & Sub Title', 'lz_fitness-premium' ),
        )
    )
);    
$wp_customize->add_setting(
   'lz_fitness_facility_title',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( 'OUR FACILITES', 'lz_fitness-premium' )
    )
);
$wp_customize->add_control(
    'lz_fitness_facility_title',
    array(
        'settings'      => 'lz_fitness_facility_title',
       'section'       => 'lz_fitness_facility_section',
       'type'          => 'text',
        'label'         => __( 'Title', 'lz_fitness-premium' )
    )
);
$wp_customize->add_setting(
    'lz_fitness_facility_sub_title',
    array(
        'sanitize_callback' => 'lz_fitness_sanitize_text',
        'default'           => __( 'Our teaching staff in Primary School are all well qualified early years teachers as are our assistants.', 'lz_fitness-premium' )
    )
);
$wp_customize->add_control(
    'lz_fitness_facility_sub_title',
    array(
        'settings'      => 'lz_fitness_facility_sub_title',
        'section'       => 'lz_fitness_facility_section',
        'type'          => 'textarea',
        'label'         => __( 'Sub Title', 'lz_fitness-premium' ),
    )
);
    
   

$wp_customize->add_setting('lz_fitness_facility_npp_heading',array('sanitize_callback' => 'lz_fitness_sanitize_text'));
$wp_customize->add_control(
    new lz_fitness_Customize_Heading(
        $wp_customize,
        'lz_fitness_facility_npp_heading',
        array(
            'settings'      => 'lz_fitness_facility_npp_heading',
            'section'       => 'lz_fitness_facility_section',
            'label'         => __( 'Number Of support Plans', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('lz_fitness_facility_npp_count',array('sanitize_callback' => 'lz_fitness_sanitize_text','default' => 5));
$wp_customize->add_control(
    'lz_fitness_facility_npp_count',
    array(
        'settings'      => 'lz_fitness_facility_npp_count',
        'section'       => 'lz_fitness_facility_section',
        'type'          => 'select',
        'label'         => __( 'Number of plan to show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
    )
);

//facility PAGES
for( $i = 1; $i <= 12; $i++ ){
    $wp_customize->add_setting(
        'lz_fitness_facility_header'.$i,
        array(
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new lz_fitness_Customize_Heading(
            $wp_customize,
            'lz_fitness_facility_header'.$i,
            array(
                'settings'      => 'lz_fitness_facility_header'.$i,
                'section'       => 'lz_fitness_facility_section',
                'label'         => __( 'facility Page ', 'luzuk-premium' ).$i
            )
        )
    );

    
    lzAddElement($wp_customize, 'lz_fitness_facility_page_title_'.$i, 'lz_fitness_facility_section', $type = 'text', $label="Title", $callback ='lz_fitness_sanitize_text', $default='Bus Services');
    lzAddElement($wp_customize, 'lz_fitness_facility_page_desc_'.$i, 'lz_fitness_facility_section', $type = 'textarea', $label="Description", $callback ='lz_fitness_sanitize_text', $default='Lorem Ipsum is simply dummy text of the printing typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since.');
  /*$wp_customize->add_setting(
        'theme_eye_support_page'.$i,
        array(
            'sanitize_callback' => 'absint'
        )
    );
    $wp_customize->add_control(
        'theme_eye_support_page'.$i,
        array(
            'settings'      => 'theme_eye_support_page'.$i,
            'section'       => 'theme_eye_support_section',
            'type'          => 'dropdown-pages',
            'label'         => __( 'Select a Page', 'theme-eye-premium' )
        )
    );*/
    $wp_customize->add_setting(
        'lz_fitness_facility_page_icon'.$i,
        array(
            'default'           => 'fa fa-bus',
            'sanitize_callback' => 'lz_fitness_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new lz_fitness_Fontawesome_Icon_Chooser(
            $wp_customize,
            'lz_fitness_facility_page_icon'.$i,
            array(
                'settings'      => 'lz_fitness_facility_page_icon'.$i,
                'section'       => 'lz_fitness_facility_section',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'luzuk-premium' ),
            )
        )
    );  
    
}
 // Heading color
    addColorPalatOption($wp_customize, 'lz_fitness_facility_HeadingColor', 'lz_fitness_facility_section', 'Heading color ', '#a556d4');
    
 // subheading color
    addColorPalatOption($wp_customize, 'lz_fitness_facility_TextColor', 'lz_fitness_facility_section', 'Text color ', '#474646');
 
 // subtext color
    addColorPalatOption($wp_customize, 'lz_fitness_facility_SubTextColor', 'lz_fitness_facility_section', 'Sub Text color ', '#474646');
       
 // icon color
    addColorPalatOption($wp_customize, 'lz_fitness_facility_IconColor', 'lz_fitness_facility_section', 'Icon color ', '#a556d4');
       
// End facility section 