<?php   
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package luzuk Premium
 */
?>
<?php 
	if( get_theme_mod('sec_footerseTmargin',true) ) {
		$sec_footerseTmargin = 'padding-top:'.esc_attr(get_theme_mod('sec_footerseTmargin')).';';
	}
	if( get_theme_mod('sec_footersebottommargin',true) ) {
		$sec_footersebottommargin = 'padding-bottom:'.esc_attr(get_theme_mod('sec_footersebottommargin')).';';
	}
	if( get_theme_mod('sec_footersecopacity',true) ) {
		$sec_footersecopacity = 'opacity:'.esc_attr(get_theme_mod('sec_footersecopacity')).';';
	}

?>		

<footer class="footer-area" id="footer" style="<?php echo esc_attr($sec_footerseTmargin); ?>" "<?php echo esc_attr($sec_footersebottommargin); ?>" "<?php echo esc_attr($sec_footersecopacity); ?>">
	<div class="footer-ovly"></div>
	<?php if(is_active_sidebar('luzuk-footer1') || is_active_sidebar('luzuk-footer2') || is_active_sidebar('luzuk-footer3') || is_active_sidebar('luzuk-footer4') ){ ?>
		
		<?php
			$newsletter_title = get_theme_mod('newsletter_title', 'Newsletter');
			$luzuk_newsletter_shortcode = get_theme_mod('luzuk_newsletter_shortcode', '[Add Form shortcode]');
			$luzuk_newsletter_text = get_theme_mod('luzuk_newsletter_text', 'Subscribe our newsletter to get our latest update & news.');
		?>
	<div class="box-form">
		<div class="container">
			<div class="newsletter-box">
				<div class="newstitle">
				    <?php if($newsletter_title ){ ?>
					    <h3><?php echo ($newsletter_title);  ?></h3> 
		            <?php }?>
				</div>
			</div>
			<div class="subscribe_shortcode ">			
				<div class="ht-newsletter-member-wrap">										
					<?php echo do_shortcode($luzuk_newsletter_shortcode);?>
				</div>
			</div>
			<div class="newsletter-desc">
				<p><?php echo ($luzuk_newsletter_text);  ?></p>
			</div>
		</div>
	</div>
	<div class="fbox"> 
		<div class="container">
			<div class="footer-widgets">
				<div class="row mr-0">
					<div class="s-footer col-lg-3 col-md-6 col-sm-6 col-xs-12 single-footer-1 ">
						<div class="single-footer wow zoomIn" data-wow-duration="1s" >
							<?php if(is_active_sidebar('luzuk-footer1')): 
								dynamic_sidebar('luzuk-footer1');
							endif;
							?>	
						</div>
					</div>

					<div class="s-footer col-lg-3 col-md-6 col-sm-6 col-xs-12 single-footer-2 ">
						<div class="single-footer wow zoomIn" data-wow-duration="1.5s" >
							<?php if(is_active_sidebar('luzuk-footer2')): 
								dynamic_sidebar('luzuk-footer2');
							endif;
							?>	
						</div>
					</div>

					<div class="s-footer col-lg-3 col-md-6 col-sm-6 col-xs-12 single-footer-3">
						<div class="single-footer wow zoomIn"  data-wow-duration="2s" >
							<?php if(is_active_sidebar('luzuk-footer3')): 
								dynamic_sidebar('luzuk-footer3');
							endif;
							?>	
						</div>
					</div>

					<div class="s-footer col-lg-3 col-md-6 col-sm-6 col-xs-12 single-footer-4" >
						<div class="single-footer wow zoomIn" data-wow-duration="2.5s" >
							<?php if(is_active_sidebar('luzuk-footer4')): 
								dynamic_sidebar('luzuk-footer4');
							endif;
							?>	
						</div>
					</div>
				</div>
			</div>
			<div class="s-footer single-footer-5" >
				<div class="single-footer wow zoomIn" data-wow-duration="2.5s" >
					<?php if(is_active_sidebar('luzuk-footer5')): 
						dynamic_sidebar('luzuk-footer5');
					endif;
					?>	
				</div>
			</div>
		</div>
	</div>
		
	<?php } ?>

	<?php
		$footercopyright = get_theme_mod('footer_area_copyrighttext', 'Copyright @ 2024 Real Estate Services All Right Reserved');
	?>
	<?php 
		if( get_theme_mod('sec_bottomareaTmargin',true) ) {
			$sec_bottomareaTmargin = 'padding-top:'.esc_attr(get_theme_mod('sec_bottomareaTmargin')).';';
		}
		if( get_theme_mod('sec_bottomareabottommargin',true) ) {
			$sec_bottomareabottommargin = 'padding-bottom:'.esc_attr(get_theme_mod('sec_bottomareabottommargin')).';';
		}
	?>		
	<div class="bottom-area wow zoomIn" style="<?php echo esc_attr($sec_bottomareaTmargin); ?>" "<?php echo esc_attr($sec_bottomareabottommargin); ?>">
		<div class="container">
			<div class="col-md-12 col-sm-12 col-xs-12 pd-0">
				<?php if($footercopyright){ ?>
					<div class="footer-text">
						<?php echo $footercopyright;?>
					</div>
				<?php } ?>
			</div>
		</div>
	</div>
	<div class="clearfix"></div>
</footer>

<script type="text/javascript">
	if(jQuery(window).width() >= 1170){
		new WOW().init();
	}
</script>

<script>
	$(window).scroll(function() {
		var height = $(window).scrollTop();
		if (height > 100) {
			$('#back2Top').fadeIn();
		} else {
			$('#back2Top').fadeOut();
		}
	});
	$(document).ready(function() {
		$("#back2Top").click(function(event) {
			event.preventDefault();
			$("html, body").animate({ scrollTop: 0 }, "slow");
			return false;
		});

	});
</script> 

<?php wp_footer(); ?>

	<!-- <a id="back2Top" title="Back to top" href="#"> &#10148; </a> -->

<a id="back2Top" title="Back to top" href="#"> 
	 <i class="fa fa-home" aria-hidden="true"></i>
</a>
</body>
</html>
