<?php    
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package luzuk Premium
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap" rel="stylesheet">
	<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css
" rel="stylesheet">
	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
	<script src="https://code.jquery.com/jquery-3.1.1.min.js" integrity="sha384-3ceskX3iaEnIogmQchP8opvBy3Mi7Ce34nWjpBIwVTHfGYWQS9jwHDVRnpKKHJg7" crossorigin="anonymous"></script>

	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>

    <script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" type="text/javascript"  ></script>
   <script src="<?php echo get_template_directory_uri(); ?>/js/swiper.min.js" type="text/javascript"  ></script>
   <script src="<?php echo get_template_directory_uri(); ?>/js/swiper-bundle.min.js" type="text/javascript"  ></script>
	<script type="text/javascript" src="https://code.jquery.com/jquery-1.12.0.min.js"></script>
   	<script type="text/javascript">
		$(document).ready(function(){
			$("#formButton").click(function(){
				$("#form1").toggle();
			});
		});
	 </script>

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<div class="main-container">
		<!-- <a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'luzuk' ); ?></a> -->
		<div id="loading-area"><div class="la-anim-10"></div></div>
		<!-- header -->
		<!-- #masthead -->
		<header class="site-header header-transparent header header-seo">
			<div class="top-bar-head">
				<div class="top-header">
				<div class="container clearfix">
					<div class="row mr-0">
						<div class="header-left col-xl-2 col-lg-2 col-md-2 col-sm-2 col-xs-10 col-3 logo">
							<?php 
								if( get_theme_mod('pages_logoTopsetmaxwidth',true) ) {
									$pages_logoTopsetmaxwidth = 'max-width:'.esc_attr(get_theme_mod('pages_logoTopsetmaxwidth')).';';
								}
							?>
							<!-- website logo -->
							<div class="logo-header mostion">
								<?php 
								if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
									the_custom_logo();
							else : 
								if ( is_front_page() ) : ?>
									<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
									<?php else : ?>
										<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
									<?php endif; ?>
								<?php endif; ?>
								<?php if( get_theme_mod('head_tagline_display','show' ) == 'show') :?>	
							<p class="ht-site-description"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'description' ); ?></a></p> 
							<?php endif ?>  
							</div> 

							<!-- nav toggle button -->
							<div class="resp_header_logo">
								<?php 
								if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
									the_custom_logo();
							else : 
								if ( is_front_page() ) : ?>
									<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
									<?php else : ?>
										<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
									<?php endif; ?>
								<?php endif; ?>
							</div>
						</div>
						<div class="header-right col-xl-10 col-lg-10 col-md-10 col-sm-10 col-xs-2 col-8">
							<?php
								$header_email = get_theme_mod('header_email', 'Info16271@Fakeinfo.Com');
								$facebook = get_theme_mod('header_fb', 'https://www.facebook.com/');
								$twitter = get_theme_mod('header_tw', 'https://www.twitter.com/');
								$linkedin = get_theme_mod('header_in', 'https://www.linkedin.com/');	
								$logintxt = get_theme_mod('header_logintxt', 'Login / Register');
								$loginlink = get_theme_mod('header_loginlink', '#');
							?>
							<div class="htop">
								<div class="row justify-content-end">
									<div class="hphone col-xl-7 col-lg-5 col-md-8 col-sm-7 col-2">
										<?php if( $header_email){ ?>
											<p>
												<i class="fa fa-envelope" aria-hidden="true"></i>
												<span class="tooltiptext">
													<a href="mailto:<?php echo $header_email;?>"><?php echo ($header_email);  ?></a>
												</span>
												<a href="mailto:<?php echo $header_email;?>" class="header-maintxt"><?php echo ($header_email);  ?></a>
											</p>
										<?php }?>
									</div>
									<?php if(!empty($facebook || $twitter || $linkedin)){ ?>
										<div class="col-xl-3 col-lg-4 col-md-3 col-sm-4 col-2 header-socials">
											<div class="share-btn">
												<ul>
													<?php if(!empty($facebook)){ ?>
														<li><a href="<?php echo $facebook ?>" title="Facebook" target="_blank"><i class="fa fa-facebook"></i></a></li>
													<?php }?>

													<?php if(!empty($twitter)){ ?>
														<li><a href="<?php echo $twitter ?>" title="Twitter" target="_blank"><i class="fa fa-twitter"></i></a></li>
													<?php }?>

													<?php if(!empty($linkedin)){ ?>
														<li><a href="<?php echo $linkedin ?>" title="linkedin" target="_blank"><i class="fa fa-linkedin" aria-hidden="true"></i></a></li>
													<?php }?>
													<li class="share-button"><a href="#" class="site-button sharp"><i class="fa fa-share-alt"></i></a></li>
													<div class="clearfix"></div>
												</ul>
											</div>
										</div>
									<?php }?>
									<div class="col-xl-2 col-lg-3 col-md-1 col-sm-1 col-2 header-user">
										<?php if(!empty($logintxt || $loginlink)){ ?>
											<div class="header-loginbtn">
												<i class="fa fa-user" aria-hidden="true"></i>
												<a href="<?php echo $loginlink; ?>">
													<span><?php echo $logintxt; ?></span>
												</a>
											</div>
										<?php }?>
									</div>
								</div>
							</div>
							<div class="hbottom">
								<div class="row">
									<div class="col-xl-9 col-lg-8 col-md-2 col-sm-2 col-xs-2 col-3 head-mnlft">
										<div class=" head-menubx">
											<div class="head-menu">
												<div class="site-navigation ">
							                       	<div class="nav-menus">                 
														<a href="#" class="js-nav-toggle">
																<span></span>
														</a>
													    <div class="nav-wrapper">
															<nav role="navigation">
																<div class="nav-toggle">
																		<span class="nav-back"></span>
																		<span class="nav-title">Menu</span>
																		<span class="nav-close"></span>
																</div>
																<?php
							                                        if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
							                                            wp_nav_menu ( array(
							                                                'menu_class' => 'mainm ht-clearfix',
							                                                'container'=> 'ul',
							                                                'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
							                                                'theme_location' => 'primary',  
							                                            )); 
							                                        } else {
							                                            wp_nav_menu ( array(
							                                                'menu_class' => 'mainm ht-clearfix',
							                                                'container'=> 'ul',
							                                                'theme_location' => 'primary',  
							                                            )); 
							                                        }
							                                    ?>
															</nav>
														</div>
													</div>
							                    <nav class="navigation">
							                            <div class="overlaybg"></div><!--  /.overlaybg -->
							                            <!-- Main Menu -->
							                            <div class="menu-wrapper">
							                                <div class="menu-content">
							                                    <?php
							                                        if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
							                                            wp_nav_menu ( array(
							                                                'menu_class' => 'mainmenu ht-clearfix',
							                                                'container'=> 'ul',
							                                                'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
							                                                'theme_location' => 'primary',  
							                                            )); 
							                                        } else {
							                                            wp_nav_menu ( array(
							                                                'menu_class' => 'mainmenu ht-clearfix',
							                                                'container'=> 'ul',
							                                                'theme_location' => 'primary',  
							                                            )); 
							                                        }
							                                    ?>
							                                </div> <!-- /.hours-content-->
														<div class="clearfix"></div>

							                        </div><!-- /.menu-wrapper --> 
							                    </nav>
							
							                        <div class="clearfix"></div>
							                    </div><!--  /.site-navigation -->

											</div>  
												<div class="clearfix"></div>
											<!-- </div> -->
										</div>
									</div>
									<div class="col-xl-3 col-lg-4 col-md-10 col-sm-10 col-xs-2 col-9 head-mnrght">
										<div class="header-rght">
											<?php
								                $headerphone = get_theme_mod('headerphone', 'Add Property');
								                $headerbtnlink = get_theme_mod('headerbtnlink', '#');
								            ?>
											<?php if( $headerphone){ ?>
											    <div class="header-phone ">
													<a href="<?php echo $headerbtnlink;?>">
														<span><?php echo ($headerphone);  ?></span>
														<i class="fa fa-long-arrow-up" aria-hidden="true"></i>
													</a>
									        	</div>
								        	<?php }?>
								        </div>
								    </div>
								</div>
							</div>
						</div>
						</div>
						<div class="clearfix"></div>
					</div>
				</div>
				<div class="clearfix"></div>
			</div>
		</header>
	</div>			
	<div class="clearfix"></div>	
<script type="text/javascript">
(function($) {
	this.MobileNav = function() {
		this.curItem,
			this.curLevel = 0,
			this.transitionEnd = _getTransitionEndEventName();
			var transitionTime = 0.2;

			var defaults = {
					initElem: ".main-menu",
					menuTitle: "Menu"
			}

			// Check if MobileNav was initialized with some options and assign them to the "defaults"
			if (arguments[0] && typeof arguments[0] === "object") {
					this.options = extendDefaults(defaults, arguments[0]);
			}

			// Add to the "defaults" ONLY if the key is already in the "defaults"
			function extendDefaults(source, extender) {
					for (option in extender) {
							if (source.hasOwnProperty(option)) {
									source[option] = extender[option];
							}
					}
			}

			MobileNav.prototype.getCurrentItem = function() {
					return this.curItem;
			};

			MobileNav.prototype.setMenuTitle = function(title) {
					defaults.menuTitle = title;
					_updateMenuTitle(this);
					return title;
			};

			// Init is an anonymous IIFE
			(function(MobileNav) {
					var initElem = ($(defaults.initElem).length) ? $(defaults.initElem) : false;

					if (initElem) {
							defaults.initElem = initElem;
							_clickHandlers(MobileNav);
							_updateMenuTitle(MobileNav);
					} else {
							console.log(defaults.initElem + " element doesn't exist, menu not initialized.");
					}
			}(this));

			function _getTransitionEndEventName() {
				var i,
						undefined,
						el = document.createElement('div'),
						transitions = {
								'transition': 'transitionend',
								'OTransition': 'otransitionend', // oTransitionEnd in very old Opera
								'MozTransition': 'transitionend',
								'WebkitTransition': 'webkitTransitionEnd'
						};

				for (i in transitions) {
						if (transitions.hasOwnProperty(i) && el.style[i] !== undefined) {
								return transitions[i];
						}
				}
			};

			function _clickHandlers(menu) {
				defaults.initElem.on('click', '.menu-item-has-children > a', function(e) {
						e.preventDefault();
						menu.curItem = $(this).parent();
						_updateActiveMenu(menu);
				});

				defaults.initElem.on('click', '.nav-toggle', function() {
						_updateActiveMenu(menu, 'back');
				});
			};

			// TODO: Make this DRY (deal with waiting for transitionend event)
			function _updateActiveMenu(menu, direction) {
				_slideMenu(menu, direction);
				if (direction === "back") {
						/*defaults.initElem.children('ul').one(menu.transitionEnd, function(e) {
								menu.curItem.removeClass('nav-dropdown-open nav-dropdown-active');
								menu.curItem = menu.curItem.parent().closest('li');
								menu.curItem.addClass('nav-dropdown-open nav-dropdown-active');
								_updateMenuTitle(menu);
						});*/

						menu.curItem.removeClass('nav-dropdown-open nav-dropdown-active');
						menu.curItem = menu.curItem.parent().closest('li');
						menu.curItem.addClass('nav-dropdown-open nav-dropdown-active');
						_updateMenuTitle(menu);
				} else {
						menu.curItem.addClass('nav-dropdown-open nav-dropdown-active');
						_updateMenuTitle(menu);
				}
			};

			// Update main menu title to be the text of the clicked menu item
			function _updateMenuTitle(menu) {
				var title = defaults.menuTitle;
				if (menu.curLevel > 0) {
						title = menu.curItem.children('a').text();
						defaults.initElem.find('.nav-toggle').addClass('back-visible');
				} else {
						defaults.initElem.find('.nav-toggle').removeClass('back-visible');
				}
				$('.nav-title').text(title);
			};

			// Slide the main menu based on current menu depth
			function _slideMenu(menu, direction) {
				if (direction === "back") {
						menu.curLevel = (menu.curLevel > 0) ? menu.curLevel - 1 : 0;
				} else {
						menu.curLevel += 1;
				}
				defaults.initElem.children('ul').css({
						"transform": "translateX(-" + (menu.curLevel * 100) + "%)",
						"transition": "transform " + transitionTime + "s ease" // Apply transition time here
				});

				// Assuming you're using the transitionEnd event to detect the end of the animation
            defaults.initElem.children('ul').one(menu.transitionEnd, function(e) {
                // Perform any actions needed after the transition ends
            });

			};
	}
}(jQuery));

$(document).ready(function() {
	$('.js-nav-toggle').on("click", function(e) {
	  e.preventDefault();
	  
	  $(this).toggleClass('nav-close');
	});

    var MobileMenu = new MobileNav({
        initElem: "nav",
        menuTitle: "Menus",
    });

    // Function to adjust the nav-wrapper height dynamically to include visible <ul> and nav-toggle
   function updateNavWrapperHeight() {
    var navWrapper = $('.nav-wrapper');
    if (navWrapper.hasClass('show-menu')) {
        var totalHeight = 0;

        // Iterate over visible <li> elements directly under <nav>
        $('nav > ul > li:visible').each(function() {
            totalHeight += $(this).outerHeight(true); // Includes margin
        });

        // Include the height of the .nav-toggle if it's visible
        if ($('.nav-toggle').is(':visible')) {
            var navToggleHeight = $('.nav-toggle').outerHeight(true); // Includes margin
            totalHeight += navToggleHeight; // Add nav-toggle height to total height
        }

        // Add extra 5 pixels
        totalHeight += 5;

        // Apply the calculated total height to the nav-wrapper
        navWrapper.height(totalHeight);
    } else {
        // Collapse the nav-wrapper when the menu is not shown
        navWrapper.height(0);
    }
}

	// Event handler for when a submenu item is clicked to show the next level
$('nav').on('click', 'li.menu-item-has-children > a', function(e) {
    e.preventDefault();
    setTimeout(updateNavWrapperHeight, 300); // Delay to account for CSS transitions/animations
});


    // Event handler for toggling the main menu
    $('.js-nav-toggle').on('click', function(e) {
        e.preventDefault();
        var navWrapper = $('.nav-wrapper');
        navWrapper.toggleClass('show-menu');
        updateNavWrapperHeight(); // Update height on initial click
    });

    

    // Update height when navigating back in the menu
    $('nav').on('click', '.nav-toggle', function() {
        setTimeout(updateNavWrapperHeight, 300); // Delay if your menu has a back button within nav-toggle
    });
});
</script>