<?php
// START CONTACT SECTION 
$wp_customize->add_section(
	'appoi_section',
	array(
		'title'         => __( 'Appointment Section', 'Luzuk Premium' ), 
		'panel'   => 'luzuk_premium_home_panel',
	)
);
    //ENABLE/DISABLE CONTACT SECTION
$wp_customize->add_setting(
	'appoi_disable',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'appoi_disable',
		array(
			'settings'      => 'appoi_disable',
			'section'       => 'appoi_section',
			'label'         => __( 'Disable Section', 'Luzuk Premium' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'Luzuk Premium' ),
				'off' => __( 'No', 'Luzuk Premium' )
			)   
		)
	)
);

backgroundManager($wp_customize, 'appointment', 'appoi_section', $color='#fff', get_template_directory_uri().'/images/appointment.jpg', 'color');

lzCustomLable($wp_customize, 'appoi_sectionnpadding', 'appoi_section', 'Section Padding ');

$wp_customize->add_setting(
    'appoinmentsection_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1.9em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'appoinmentsection_toppadding',
    array(
        'settings'      => 'appoinmentsection_toppadding',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Top ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'appoinmentsection_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2.7em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'appoinmentsection_bottompadding',
    array(
        'settings'      => 'appoinmentsection_bottompadding',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Bottom ', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'appoi_sectionopacity', 'appoi_section', 'Section Overlay ');

$wp_customize->add_setting(
    'appoinmentsection_opacity',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.5', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'appoinmentsection_opacity',
    array(
        'settings'      => 'appoinmentsection_opacity',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Opacity ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'app_opacityclr', 'appoi_section', 'Overlay Color', '#000');

lzCustomLable($wp_customize, 'app_secleftside', 'appoi_section', 'Section Left Side');

lzCustomLable($wp_customize, 'app_detailbg', 'appoi_section', 'Section Heading And Text');

$wp_customize->add_setting(
    'appheading1',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Contact' )
    )
);
$wp_customize->add_control(
    'appheading1',
    array(
        'settings'      => 'appheading1',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Heading 1', 'Luzuk' )
    )
);

$wp_customize->add_setting(
    'appheading2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Us' )
    )
);
$wp_customize->add_control(
    'appheading2',
    array(
        'settings'      => 'appheading2',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Heading 2', 'Luzuk' )
    )
);

$wp_customize->add_setting(
    'appsubheading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'We’ve More Than 745,000 Apartments, Place & Plot.' )
    )
);
$wp_customize->add_control(
    'appsubheading',
    array(
        'settings'      => 'appsubheading',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Text', 'Luzuk' )
    )
);

lzCustomLable($wp_customize, 'app_cntctdetail', 'appoi_section', 'Contact Details');

$wp_customize->add_setting(
    'app_infphtxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '+123 456 789' )
    )
);
$wp_customize->add_control(
    'app_infphtxt',
    array(
        'settings'      => 'app_infphtxt',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Phone Number', 'Luzuk' )
    )
);

$wp_customize->add_setting(
    'app_infemiltxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'info@youremailidhere.com' )
    )
);
$wp_customize->add_control(
    'app_infemiltxt',
    array(
        'settings'      => 'app_infemiltxt',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Email Id', 'Luzuk' )
    )
);

$wp_customize->add_setting(
    'app_inftxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Delanson, New York, 12053' )
    )
);
$wp_customize->add_control(
    'app_inftxt',
    array(
        'settings'      => 'app_inftxt',
        'section'       => 'appoi_section',
        'type'          => 'textarea',
        'label'         => __( 'Address Text', 'Luzuk' )
    )
);

lzCustomLable($wp_customize, 'app_sociallinks', 'appoi_section', 'Social Icon Links ');

// FACEBOOK
$wp_customize->add_setting('app_facebook', array('default'=> 'https://www.facebook.com/', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('app_facebook',
    array(
        'settings'      => 'app_facebook',
        'section'       => 'appoi_section',
        'type'          => 'url',
        'label'         => __( 'Facebook Url', 'luzuk-premium' )
    )
);

//Instagram
$wp_customize->add_setting('app_instagram',array('default'=> 'https://www.instagram.com/','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('app_instagram',
    array(
        'settings'      => 'app_instagram',
        'section'       => 'appoi_section',
        'type'          => 'url',
        'label'         => __( 'Instagram Url', 'luzuk-premium' )
    )
);

//  TWITTER
$wp_customize->add_setting('app_twitter', array('default'=> 'https://twitter.com/', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('app_twitter',
    array(
        'settings'      => 'app_twitter',
        'section'       => 'appoi_section',
        'type'          => 'url',
        'label'         => __( 'Twitter Url', 'luzuk-premium' )
    )
);

// WHATSAPP
$wp_customize->add_setting('app_pintrest', array('default'=> 'https://www.pinterest.com/', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('app_pintrest',
    array(
        'settings'      => 'app_pintrest',
        'section'       => 'appoi_section',
        'type'          => 'url',
        'label'         => __( 'Pinterest Url', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'app_secleftsideClr', 'appoi_section', 'Left Side Colors');

addColorPalatOption($wp_customize, 'app_secheadingclr', 'appoi_section', 'Heading Color', '#fff');

addColorPalatOption($wp_customize, 'inquiry_lftboxsubheadingclr', 'appoi_section', 'Text Color', '#fff');

addColorPalatOption($wp_customize, 'inquiry_cntctdtlicnclr', 'appoi_section', 'Contact Details Icon Color', '#DE0F00');

addColorPalatOption($wp_customize, 'inquiry_cntctdtlclr', 'appoi_section', 'Contact Details Text Color', '#fff');

addColorPalatOption($wp_customize, 'inquiry_btntxticnclr', 'appoi_section', 'Social Icon Color', '#000');

addColorPalatOption($wp_customize, 'inquiry_btntxticnhvclr', 'appoi_section', 'Social Icon Hover Color', '#000');

addColorPalatOption($wp_customize, 'inquiry_btntxticnbgclr', 'appoi_section', 'Social Icon BG Color', '#fff');

addColorPalatOption($wp_customize, 'inquiry_btntxticnbghvclr', 'appoi_section', 'Social Icon BG Hover Color', '#DE0F00');

lzCustomLable($wp_customize, 'app_secrightside', 'appoi_section', 'Section Right Side');

lzCustomLable($wp_customize, 'app_formhead', 'appoi_section', 'Form Heading');

$wp_customize->add_setting(
    'app_formtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Inquiry with us' )
    )
);
$wp_customize->add_control(
    'app_formtitle',
    array(
        'settings'      => 'app_formtitle',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Heading', 'Luzuk' )
    )
);

lzCustomLable($wp_customize, 'appointmentright_Form_label', 'appoi_section', 'Contact Inquiry Form Shortcode');

lzAddElement($wp_customize, 'luzuk_inquiry_shortcode', 'appoi_section', 'textarea', $label="Form Shortcode", 'luzuk_sanitize_text', '[your shortcode]'); 

lzCustomLable($wp_customize, 'app_dlhsbcclr', 'appoi_section', 'Right Side Colors');

addColorPalatOption($wp_customize, 'inquiry_formbgclr', 'appoi_section', 'Form BG Color', '#fff');

addColorPalatOption($wp_customize, 'inquiry_formtitleclr', 'appoi_section', 'Form Title Color', '#DE0F00');

addColorPalatOption($wp_customize, 'inquiry_forminputtxtClr', 'appoi_section', 'Form Input Text / Placeholder Color', '#070707 ');

addColorPalatOption($wp_customize, 'inquiry_forminputbgColor', 'appoi_section', 'Form Input Border Color', '#808080');

addColorPalatOption($wp_customize, 'inquiry_formlabelColor', 'appoi_section', 'Form Label Color', '#000');

addColorPalatOption($wp_customize, 'inquiry_formbuttontextColor', 'appoi_section', 'Form Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'inquiry_formbuttontexthoverColor', 'appoi_section', 'Form Button Text Hover Color', '#fff');

addColorPalatOption($wp_customize, 'inquiry_formbuttonbgColor', 'appoi_section', 'Form Button BG Color', '#DE0F00');

addColorPalatOption($wp_customize, 'inquiry_formbuttonbghoverColor', 'appoi_section', 'Form Button BG Hover Color', '#000');