<?php
$wp_customize->add_section(
    'banner_section',
    array(
        'title' => __( 'Banner Section', 'Luzuk' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);

$wp_customize->add_setting(
    'banner_section_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'banner_section_disable',
        array(
            'settings'      => 'banner_section_disable',
            'section'       => 'banner_section',
            'label'         => __( 'Disable Section', 'Luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'Luzuk' ),
                'off' => __( 'No', 'Luzuk' )
            ),
        )
    )
); 

BackgroundManager($wp_customize, 'banner', 'banner_section', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'sec_bannerpadding', 'banner_section', 'Section Padding');

$wp_customize->add_setting(
    'bannerTpadding', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2.25em', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'bannerTpadding',
    array(
        'settings'      => 'bannerTpadding',
        'section'       => 'banner_section',
        'type'          => 'text',
        'label'         => __( 'Top', 'Luzuk' )
    )
);

$wp_customize->add_setting(
    'bannerBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3em', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'bannerBpadding',
    array(
        'settings'      => 'bannerBpadding',
        'section'       => 'banner_section',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'Luzuk' )
    )
); 

lzCustomLable($wp_customize, 'about_rghtimg', 'banner_section' , 'Select Image');

$wp_customize->add_setting(
    'banner_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'banner_image',
        array(
            'section' => 'banner_section',
            'settings' => 'banner_image',
            'description' => __('Recommended Image Size: 390X447px', 'luzuk-premium')
        )
    )
);

lzCustomLable($wp_customize, 'sec_overlay', 'banner_section', 'Section Overlay');

$wp_customize->add_setting(
    'bannerOpacity', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.25', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'bannerOpacity',
    array(
        'settings'      => 'bannerOpacity',
        'section'       => 'banner_section',
        'type'          => 'text',
        'label'         => __( 'Opacity', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'banner_ovlyClr', 'banner_section', 'Overlay Color', '#000');

$wp_customize->add_setting(
    'banner_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'banner_title_heading',
        array(
            'settings'      => 'banner_title_heading',
            'section'       => 'banner_section',
            'label'         => __( 'Heading And Text', 'Luzuk' ),
        )
    )
);  

$wp_customize->add_setting(
    'banner_titlehigh',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Your Dream Home, Our Passion', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'banner_titlehigh',
    array(
        'settings'      => 'banner_titlehigh',
        'section'       => 'banner_section',
        'type'          => 'text',
        'label'         => __( 'Heading ', 'Luzuk' )
    )
);

$wp_customize->add_setting(
    'banner_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'We’ve More Than 745,000 Apartments, Place & Plot.', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'banner_text',
    array(
        'settings'      => 'banner_text',
        'section'       => 'banner_section',
        'type'          => 'text',
        'label'         => __( 'Text', 'Luzuk' )
    )
);

$wp_customize->add_setting(
    'banner_btntext',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Book Now', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'banner_btntext',
    array(
        'settings'      => 'banner_btntext',
        'section'       => 'banner_section',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'Luzuk' )
    )
);

$wp_customize->add_setting(
    'banner_btntextlink',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '#', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'banner_btntextlink',
    array(
        'settings'      => 'banner_btntextlink',
        'section'       => 'banner_section',
        'type'          => 'text',
        'label'         => __( 'Button Link', 'Luzuk' )
    )
);

lzCustomLable($wp_customize, 'sec_call_leftboxclr', 'banner_section', 'Section Color');

addColorPalatOption($wp_customize, 'banner_headclr', 'banner_section', 'Heading Color', '#fff'); 

addColorPalatOption($wp_customize, 'banner_subheadclr', 'banner_section', 'Text Color', '#fff'); 

addColorPalatOption($wp_customize, 'banner_btntxtclr', 'banner_section', 'Button Text Color', '#fff'); 

addColorPalatOption($wp_customize, 'banner_btntxthvclr', 'banner_section', 'Button Text Hover Color', '#fff'); 

addColorPalatOption($wp_customize, 'banner_btnbgclr', 'banner_section', 'Button BG Color', '#DE0F00'); 

addColorPalatOption($wp_customize, 'banner_btnbghvclr', 'banner_section', 'Button BG Hover Color', '#000'); 