<?php  

$wp_customize->add_section(
    'clientlogo_area',
    array(
        'title' => __('Client Logo Section', 'luzuk-premium' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);
  // ENABLE/DISABLE FEATURED SECTION
    $wp_customize->add_setting(
        'clientlogo_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'clientlogo_area_disable',
            array(
                'settings'      => 'clientlogo_area_disable',
                'section'       => 'clientlogo_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    );

backgroundManager($wp_customize, 'clientlogo', 'clientlogo_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'clientlogosection_padding', 'clientlogo_area', ' Section Padding ');

$wp_customize->add_setting(
    'clientlogos_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2.7em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'clientlogos_toppadding',
    array(
        'settings'      => 'clientlogos_toppadding',
        'section'       => 'clientlogo_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'clientlogo_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2.65em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'clientlogo_bottompadding',
    array(
        'settings'      => 'clientlogo_bottompadding',
        'section'       => 'clientlogo_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

$wp_customize->add_setting('clientlogo_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'clientlogo_npp_heading',
        array(
            'settings'      => 'clientlogo_npp_heading',
            'section'       => 'clientlogo_area',
            'label'         => __( 'Number Of Logo To Show', 'Luzuk Premium' ),
        )
    )
);    
$wp_customize->add_setting('clientlogo_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 5));
$wp_customize->add_control(
    'clientlogo_npp_count',
    array(
        'settings'      => 'clientlogo_npp_count',
        'section'       => 'clientlogo_area',
        'type'          => 'select',
        'label'         => __( 'Number Of Logo To Show', 'Luzuk Premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8)
    )
);

//FEATURED PAGES
for( $i = 1; $i <= 8; $i++ ){
    $wp_customize->add_setting(
        'clientlogo_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'clientlogo_header'.$i,
            array(
                'settings'      => 'clientlogo_header'.$i,
                'section'       => 'clientlogo_area',
                'label'         => __( 'Logo ', 'Luzuk Premium' ).$i
            )
        )
    );

    //     $wp_customize->add_setting(
    //     'clientlogo_page_icon'.$i,
    //     array(
    //         'default'           => 'fa fa-trophy',
    //         'sanitize_callback' => 'luzuk_sanitize_text'
    //     )
    // );        
    // $wp_customize->add_control(
    //     new luzuk_Fontawesome_Icon_Chooser(
    //         $wp_customize,
    //         'clientlogo_page_icon'.$i,
    //         array(
    //             'settings'      => 'clientlogo_page_icon'.$i,
    //             'section'       => 'clientlogo_area',
    //             'type'          => 'icon',
    //             'label'         => __( 'FontAwesome Icon', 'Luzuk Premium' ),
    //         )
    //     )
    // );

lzAddImageElement($wp_customize, 'clientlogo_page_icon'.$i, 'clientlogo_area', $label="Recommended Image Size: 280X168px");  
}