<?php  

$wp_customize->add_section(
    'counter_area',
    array(
        'title' => __('Counter Section', 'luzuk-premium' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);
  // ENABLE/DISABLE FEATURED SECTION
    $wp_customize->add_setting(
        'counter_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'counter_area_disable',
            array(
                'settings'      => 'counter_area_disable',
                'section'       => 'counter_area',
                'label'         => __( 'Counter Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    );

backgroundManager($wp_customize, 'counter', 'counter_area', $color='#fff', get_template_directory_uri().'/images/counterbg.jpg', 'color');

lzCustomLable($wp_customize, 'countersection_padding', 'counter_area', ' Section Padding');

$wp_customize->add_setting(
    'countersection_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1.54em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'countersection_toppadding',
    array(
        'settings'      => 'countersection_toppadding',
        'section'       => 'counter_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'countersection_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.57em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'countersection_bottompadding',
    array(
        'settings'      => 'countersection_bottompadding',
        'section'       => 'counter_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'countersection_overlay', 'counter_area', ' Section Overlay');

$wp_customize->add_setting(
    'countersection_overlay',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.81', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'countersection_overlay',
    array(
        'settings'      => 'countersection_overlay',
        'section'       => 'counter_area',
        'type'          => 'text',
        'label'         => __( 'Opacity', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'counter_ovlyColor', 'counter_area', 'Overlay Color', '#000');

$wp_customize->add_setting('counter_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'counter_npp_heading',
        array(
            'settings'      => 'counter_npp_heading',
            'section'       => 'counter_area',
            'label'         => __( 'Number Of Counter Box', 'Luzuk Premium' ),
        )
    )
);    
$wp_customize->add_setting('counter_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control(
    'counter_npp_count',
    array(
        'settings'      => 'counter_npp_count',
        'section'       => 'counter_area',
        'type'          => 'select',
        'label'         => __( 'Number Of Counter To Show', 'Luzuk Premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8)
    )
);

//FEATURED PAGES
for( $i = 1; $i <= 8; $i++ ){
    $wp_customize->add_setting(
        'counter_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'counter_header'.$i,
            array(
                'settings'      => 'counter_header'.$i,
                'section'       => 'counter_area',
                'label'         => __( 'Counter ', 'Luzuk Premium' ).$i
            )
        )
    );

    //     $wp_customize->add_setting(
    //     'counter_page_icon'.$i,
    //     array(
    //         'default'           => 'fa fa-users',
    //         'sanitize_callback' => 'luzuk_sanitize_text'
    //     )
    // );        
    // $wp_customize->add_control(
    //     new luzuk_Fontawesome_Icon_Chooser(
    //         $wp_customize,
    //         'counter_page_icon'.$i,
    //         array(
    //             'settings'      => 'counter_page_icon'.$i,
    //             'section'       => 'counter_area',
    //             'type'          => 'icon',
    //             'label'         => __( 'FontAwesome Icon', 'Luzuk Premium' ),
    //         )
    //     )
    // );
lzAddElement($wp_customize, 'counter_page_num'.$i, 'counter_area', $type = 'text', $label="Counter Number", $callback ='luzuk_sanitize_text', $default='341+');

lzAddElement($wp_customize, 'counter_page_title'.$i, 'counter_area', $type = 'text', $label="Counter Title", $callback ='luzuk_sanitize_text', $default='Screens Place');
    
}

lzCustomLable($wp_customize, 'counter_sectioncolor', 'counter_area', ' Counter Section Color');

addColorPalatOption($wp_customize, 'counter_conbxhvClr2', 'counter_area', 'Contain Box Border Hover Color', '#DE0F00');

addColorPalatOption($wp_customize, 'counter_titlenumColor', 'counter_area', 'Counter Number Color', '#fff');

addColorPalatOption($wp_customize, 'counter_titleColor', 'counter_area', 'Title Color', '#fff');
