<?php 
$wp_customize->add_section(
    'home_area',
    array(
        'title'         => __( 'Homes Section', 'luzuk' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);
$wp_customize->add_setting(
    'home_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'home_area_disable',
        array(
            'settings'      => 'home_area_disable',
            'section'       => 'home_area',
            'label'         => __( 'Disable Section', 'luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk' ),
                'off' => __( 'No', 'luzuk' )
            )   
        )
    )
);

backgroundManager($wp_customize, 'home', 'home_area', $color='#fff', get_template_directory_uri().'/images/homebg.png', 'color'); 

lzCustomLable($wp_customize, 'luzuk_sec_homessectionpadding', 'home_area', 'Section Padding');

$wp_customize->add_setting(
    'home_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3.35em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'home_areaTpadding',
    array(
        'settings'      => 'home_areaTpadding',
        'section'       => 'home_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'home_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1.7em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'home_areaBpadding',
    array(
        'settings'      => 'home_areaBpadding',
        'section'       => 'home_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'homes_maintitle_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'homes_maintitle_subtitle_heading',
        array(
            'settings'      => 'homes_maintitle_subtitle_heading',
            'section'       => 'home_area',
            'label'         => __( 'Section Heading', 'luzuk' ),
        )
    )
);

$wp_customize->add_setting(
    'home_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Popular', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'home_subtitle',
    array(
        'settings'      => 'home_subtitle',
        'section'       => 'home_area',
        'type'          => 'text',
        'label'         => __( 'Sub Heading', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'home_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Our Popular Homes', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'home_title',
    array(
        'settings'      => 'home_title',
        'section'       => 'home_area',
        'type'          => 'text',
        'label'         => __( 'Heading', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'homearea_heading_clr', 'home_area', 'Heading And Sub Heading Color ', '#000');

$wp_customize->add_setting('home_area_lbl2', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'home_area_lbl2',
        array(
            'settings'      => 'home_area_lbl2',
            'section'       => 'home_area',
            'label'         => __( 'Note 2 :', 'luzuk' ),  
            'description'   => __( 'Use Shortcode [homeS] to show all homes in a page', 'luzuk' ),
        )
    )
);

$wp_customize->add_setting('home_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'home_npp_heading',
        array(
            'settings'      => 'home_npp_heading',
            'section'       => 'home_area',
            'label'         => __( 'Number Of Homes To Show', 'luzuk' ),
        )
    )
);    
$wp_customize->add_setting('home_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 5));
$wp_customize->add_control(
    'home_npp_count',
    array(
        'settings'      => 'home_npp_count',
        'section'       => 'home_area',
        'type'          => 'select',
        'label'         => __( 'Number Of Homes To Show', 'luzuk' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9)
    )
);

$homesSingleChoice[] = 'Select';

for( $i = 1; $i <= 9; $i++ ){
    $wp_customize->add_setting(
        'homes_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'homes_heading'.$i,
            array(
                'settings'      => 'homes_heading'.$i,
                'section'       => 'home_area',
                'label'         => __( 'Home ', 'luzuk' ).$i,
            )
        )
    );
    if(is_array($homesSingleChoice)){
        $wp_customize->add_setting(
            'homes_page'.$i,
            array(
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(
            'homes_page'.$i,
            array(
                'settings'      => 'homes_page'.$i,
                'section'       => 'home_area',
                'type'=> 'select',
                'label'         => __( 'Select A Home Box ', 'luzuk' ),
                'choices' => $homesSingleChoice,
            )
        );

    }else{
        $wp_customize->add_setting('home_area_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
        $wp_customize->add_control(
            new luzuk_Info_Text( 
                $wp_customize,
                'home_area_lbl'.$i,
                array(
                    'settings'      => 'home_area_lbl'.$i,
                    'section'       => 'home_area',
                    'label'         => __( 'Note:', 'luzuk' ),    
                    'description'   => __( '<strong>Changes will not reflect unless you select the home Page.</strong> <br/>Please add the homes from "homes menu" and then select homes to show information.', 'luzuk' ),
                )
            )
        );
    }
}

lzCustomLable($wp_customize, 'luzuk_sec_homesclr', 'home_area', 'Home Section Color');

addColorPalatOption($wp_customize, 'homes_secbxbgClr', 'home_area', 'Box BG Color ', '#fff');

addColorPalatOption($wp_customize, 'homes_secbxbrdClr', 'home_area', 'Box Border Color ', '#dfdfdf');

addColorPalatOption($wp_customize, 'homes_secbxbrdhvrClr', 'home_area', 'Box Border Hover Color ', '#000');

addColorPalatOption($wp_customize, 'homes_secbxicnClr', 'home_area', 'Location Icon Color ', '#1D2636');

addColorPalatOption($wp_customize, 'homes_seclocationClr', 'home_area', 'Location Color ', '#000');

addColorPalatOption($wp_customize, 'homes_secTitleClr', 'home_area', 'Title Color ', '#000');

addColorPalatOption($wp_customize, 'homes_secAreainfoClr', 'home_area', 'Area Info Color ', '#4C4C4C');

addColorPalatOption($wp_customize, 'homes_secAreainfobrdClr', 'home_area', 'Area Info Border Color ', '#ebebeb');

addColorPalatOption($wp_customize, 'homes_secAreapriceClr', 'home_area', 'Price Color ', '#000');

addColorPalatOption($wp_customize, 'homes_btntxtClr', 'home_area', 'Button Text Color ', '#fff');

addColorPalatOption($wp_customize, 'homes_btntxthvClr', 'home_area', 'Button Text Hover Color ', '#000');

addColorPalatOption($wp_customize, 'homes_btnbgClr', 'home_area', 'Button BG Color ', '#000');

addColorPalatOption($wp_customize, 'homes_btnbghvClr', 'home_area', 'Button BG Hover Color', '#DE0F00');

addColorPalatOption($wp_customize, 'homes_sldrarrwClr', 'home_area', 'Slider Arrow Color ', '#000');

addColorPalatOption($wp_customize, 'homes_sldrarrwhvrClr', 'home_area', 'Slider Arrow Hover Color ', '#DE0F00');

addColorPalatOption($wp_customize, 'homes_sldrarrwbghvrClr', 'home_area', 'Slider Arrow BG Hover Color ', '#000');

lzCustomLable($wp_customize, 'luzuk_sec_sectionbtnsttng', 'home_area', 'Section Button Setting');

$wp_customize->add_setting(
    'home_btntxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Explore All', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'home_btntxt',
    array(
        'settings'      => 'home_btntxt',
        'section'       => 'home_area',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'home_btnlink',
    array(
        'sanitize_callback' => 'esc_url_raw',
        'default'           => __( '#', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'home_btnlink',
    array(
        'settings'      => 'home_btnlink',
        'section'       => 'home_area',
        'type'          => 'text',
        'label'         => __( 'Button Link', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'homearea_secbtntext', 'home_area', 'Section Button Text Color', '#000');

addColorPalatOption($wp_customize, 'homearea_secbtntexthv', 'home_area', 'Section Button Text Hover Color', '#fff');

addColorPalatOption($wp_customize, 'homearea_secbtntextbg', 'home_area', 'Section Button Text BG Color', '#fff');

addColorPalatOption($wp_customize, 'homearea_secbtntextbghv', 'home_area', 'Section Button Text BG Hover Color', '#000');

addColorPalatOption($wp_customize, 'homearea_secbtnbrd', 'home_area', 'Section Button Border Color', '#000');