<?php 
$wp_customize->add_section(
    'land_area',
    array(
        'title'         => __( 'Land Section', 'luzuk' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);
$wp_customize->add_setting(
    'land_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'land_area_disable',
        array(
            'settings'      => 'land_area_disable',
            'section'       => 'land_area',
            'label'         => __( 'Disable Section', 'luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk' ),
                'off' => __( 'No', 'luzuk' )
            )   
        )
    )
);

backgroundManager($wp_customize, 'land', 'land_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img'); 

lzCustomLable($wp_customize, 'luzuk_sec_landssectionpadding', 'land_area', 'Section Padding');

$wp_customize->add_setting(
    'land_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3.4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'land_areaTpadding',
    array(
        'settings'      => 'land_areaTpadding',
        'section'       => 'land_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'land_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1.9em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'land_areaBpadding',
    array(
        'settings'      => 'land_areaBpadding',
        'section'       => 'land_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'lands_maintitle_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'lands_maintitle_subtitle_heading',
        array(
            'settings'      => 'lands_maintitle_subtitle_heading',
            'section'       => 'land_area',
            'label'         => __( 'Section Heading', 'luzuk' ),
        )
    )
);

$wp_customize->add_setting(
    'land_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Land Sale Alert', 'luzuk' )
    )
);
$wp_customize->add_control(
    'land_subtitle',
    array(
        'settings'      => 'land_subtitle',
        'section'       => 'land_area', 
        'type'          => 'text',
        'label'         => __( 'Sub Heading', 'luzuk' )
    )
);

$wp_customize->add_setting(
    'land_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Your Ideal Plot Awaits – Act Now!"', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'land_title',
    array(
        'settings'      => 'land_title',
        'section'       => 'land_area',
        'type'          => 'text',
        'label'         => __( 'Heading', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'luzuk_sec_headingclr', 'land_area', 'land Heading Color');

addColorPalatOption($wp_customize, 'landarea_subheading_clr', 'land_area', 'Sub Heading Color ', '#000');

addColorPalatOption($wp_customize, 'landarea_heading_clr', 'land_area', 'Heading Color ', '#000');

lzCustomLable($wp_customize, 'luzuk_sec_landssectionbutton', 'land_area', 'Section Button');

$wp_customize->add_setting(
    'land_btntxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Explore All', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'land_btntxt',
    array(
        'settings'      => 'land_btntxt',
        'section'       => 'land_area',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'land_btnlink',
    array(
        'sanitize_callback' => 'esc_url_raw',
        'default'           => __( '#', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'land_btnlink',
    array(
        'settings'      => 'land_btnlink',
        'section'       => 'land_area',
        'type'          => 'text',
        'label'         => __( 'Button Link', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'landarea_buttontxt_clr', 'land_area', 'Button Text Color ', '#DE0F00');

addColorPalatOption($wp_customize, 'landarea_buttontxthvr_clr', 'land_area', 'Button Text Hover Color ', '#000');

$wp_customize->add_setting('land_area_lbl2', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'land_area_lbl2',
        array(
            'settings'      => 'land_area_lbl2',
            'section'       => 'land_area',
            'label'         => __( 'Note 2 :', 'luzuk' ),  
            'description'   => __( 'Use Shortcode [LANDS] to show all lands in a page', 'luzuk' ),
        )
    )
);

$wp_customize->add_setting('land_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'land_npp_heading',
        array(
            'settings'      => 'land_npp_heading',
            'section'       => 'land_area',
            'label'         => __( 'Number Of Lands To Show', 'luzuk' ),
        )
    )
);    
$wp_customize->add_setting('land_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 5));
$wp_customize->add_control(
    'land_npp_count',
    array(
        'settings'      => 'land_npp_count',
        'section'       => 'land_area',
        'type'          => 'select',
        'label'         => __( 'Number Of Lands To Show', 'luzuk' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9)
    )
);

$landsSingleChoice[] = 'Select';

for( $i = 1; $i <= 9; $i++ ){
    $wp_customize->add_setting(
        'lands_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'lands_heading'.$i,
            array(
                'settings'      => 'lands_heading'.$i,
                'section'       => 'land_area',
                'label'         => __( 'Land ', 'luzuk' ).$i,
            )
        )
    );
    if(is_array($landsSingleChoice)){
        $wp_customize->add_setting(
            'lands_page'.$i,
            array(
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(
            'lands_page'.$i,
            array(
                'settings'      => 'lands_page'.$i,
                'section'       => 'land_area',
                'type'=> 'select',
                'label'         => __( 'Select A Land Box ', 'luzuk' ),
                'choices' => $landsSingleChoice,
            )
        );

    }else{
        $wp_customize->add_setting('land_area_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
        $wp_customize->add_control(
            new luzuk_Info_Text( 
                $wp_customize,
                'land_area_lbl'.$i,
                array(
                    'settings'      => 'land_area_lbl'.$i,
                    'section'       => 'land_area',
                    'label'         => __( 'Note:', 'luzuk' ),    
                    'description'   => __( '<strong>Changes will not reflect unless you select the land Page.</strong> <br/>Please add the lands from "lands menu" and then select lands to show information.', 'luzuk' ),
                )
            )
        );
    }
}

lzCustomLable($wp_customize, 'luzuk_sec_landsclr', 'land_area', 'land Section Color');

addColorPalatOption($wp_customize, 'lands_secbxbgClr', 'land_area', 'Box BG Color ', '#fff');

addColorPalatOption($wp_customize, 'lands_secbxbrdClr', 'land_area', 'Box Border Color ', '#dfdfdf');

addColorPalatOption($wp_customize, 'lands_secbxbrdhvrClr', 'land_area', 'Box Border Hover Color ', '#000');

addColorPalatOption($wp_customize, 'lands_seclocationicnClr', 'land_area', 'Location Icon Color ', '#1D2636');

addColorPalatOption($wp_customize, 'lands_seclocationClr', 'land_area', 'Location Color ', '#000');

addColorPalatOption($wp_customize, 'lands_secTitleClr', 'land_area', 'Title Color ', '#000');

addColorPalatOption($wp_customize, 'lands_secAreainfoClr', 'land_area', 'Area Info Color ', '#4C4C4C');

addColorPalatOption($wp_customize, 'lands_secAreainfobrdClr', 'land_area', 'Area Info Border Color ', '#ebebeb');

addColorPalatOption($wp_customize, 'lands_secAreapriceClr', 'land_area', 'Price Color ', '#000');

addColorPalatOption($wp_customize, 'lands_btntxtClr', 'land_area', 'Button Text Color ', '#fff');

addColorPalatOption($wp_customize, 'lands_btntxthvClr', 'land_area', 'Button Text Hover Color ', '#000');

addColorPalatOption($wp_customize, 'lands_btnbgClr', 'land_area', 'Button BG Color ', '#000');

addColorPalatOption($wp_customize, 'lands_btnbghvClr', 'land_area', 'Button BG Hover Color', '#DE0F00');

addColorPalatOption($wp_customize, 'lands_sldrarrwClr', 'land_area', 'Slider Arrow Color ', '#1A1818');

addColorPalatOption($wp_customize, 'lands_sldrarrwhvrClr', 'land_area', 'Slider Arrow Hover Color ', '#fff');

addColorPalatOption($wp_customize, 'lands_sldrarrwbghvrClr', 'land_area', 'Slider Arrow BG Hover Color ', '#DE0F00');