<?php
/**
 * Createing an property pannel for customizer
 *
 */

// START Property SECTION 
    $wp_customize->add_section(
        'luzuk_premium_property',
        array(
            'title' => __( 'Property Section', 'luzuk premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    // ENABLE/DISABLE propertyD SECTION
    $wp_customize->add_setting(
        'luzuk_premium_property_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'luzuk_premium_property_disable',
            array(
                'settings'      => 'luzuk_premium_property_disable',
                'section'       => 'luzuk_premium_property',
                'label'         => __( 'Disable Section', 'luzuk premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk premium' ),
                    'off' => __( 'No', 'luzuk premium' )
                ),
            )
        )
    );

backgroundManager($wp_customize, 'property', 'luzuk_premium_property', $color='#fff', get_template_directory_uri().'/images/default.png', 'img');

lzCustomLable($wp_customize, 'luzuk_sec_propertysectionpadding', 'luzuk_premium_property', 'Section Padding');

$wp_customize->add_setting(
    'property_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5.7em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'property_areaTpadding',
    array(
        'settings'      => 'property_areaTpadding',
        'section'       => 'luzuk_premium_property',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'property_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1.8em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'property_areaBpadding',
    array(
        'settings'      => 'property_areaBpadding',
        'section'       => 'luzuk_premium_property',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'luzuk_propertyheading', 'luzuk_premium_property', ' Section Heading');

$wp_customize->add_setting(
    'property_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'We Are Where You Want To Live', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'property_title',
    array(
        'settings'      => 'property_title',
        'section'       => 'luzuk_premium_property',
        'type'          => 'text',
        'label'         => __( 'Heading', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'property_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Lorem Ipsum Is Simply Dummy Text Of The Printing And Typesetting Industry. Lorem Ipsum Has Been The Industrys Standard Dummy Text Ever Since', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'property_text',
    array(
        'settings'      => 'property_text',
        'section'       => 'luzuk_premium_property',
        'type'          => 'text',
        'label'         => __( 'Text', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'luzuk_propertyheadingclr', 'luzuk_premium_property', ' Section Heading Color');

addColorPalatOption($wp_customize, 'property_titleClr', 'luzuk_premium_property', 'Heading Color', '#000');

addColorPalatOption($wp_customize, 'property_textClr', 'luzuk_premium_property', 'Text Color', '#7f7f7f');

// New Customizer Option
//-----------------------------------------

// $wp_customize->add_setting('selected_post_type', array(
//     'sanitize_callback' => 'sanitize_key',
//     //'default' => 'our-services'
// ));

$landsSingleChoice[] = 'Select';
$homesSingleChoice[] = 'select';

for ($i = 1; $i <= 4; $i++) {

    $wp_customize->add_setting(
        'luzuk_property_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'luzuk_property_header'.$i,
            array(
                'settings'      => 'luzuk_property_header'.$i,
                'section'       => 'luzuk_premium_property',
                'label'         => __( 'Select Property  ', 'luzuk' ).$i
            )
        )
    );

    // Create unique IDs for each setting
    $selected_post_type_id = "selected_post_type_$i";
    $lands_options_id = "lands_options_$i";
    $homes_options_id = "homes_options_$i";

    // Add settings for selecting post type
    $wp_customize->add_setting($selected_post_type_id, array(
        'sanitize_callback' => 'sanitize_key',
        //'default' => 'our-lands' 
    ));
    $wp_customize->add_control($selected_post_type_id, array(
        'settings'      => $selected_post_type_id,
        'section'       => 'luzuk_premium_property',
        'type'          => 'radio',
        //'label'         => __("Select Prperty $i", 'luzuk'),
        'choices'       => array(
            'our-lands'    => __("Lands", 'luzuk'),
            'our-homes' => __("Homes", 'luzuk')
        )
    ));

    $wp_customize->add_setting($lands_options_id, array(
        'sanitize_callback' => 'absint'
    ));
    $wp_customize->add_control($lands_options_id, array(
        'settings'      => $lands_options_id,
        'section'       => 'luzuk_premium_property',
        'type'          => 'select',
        'label'         => __("Select A Land", 'luzuk Premium'),
        'choices'       => $landsSingleChoice,
        'active_callback' => function($control) use ($selected_post_type_id) {
            return $control->manager->get_setting($selected_post_type_id)->value() === 'our-lands';
        }
    ));

    $wp_customize->add_setting($homes_options_id, array(
        'sanitize_callback' => 'absint'
    ));
    $wp_customize->add_control($homes_options_id, array(
        'settings'      => $homes_options_id,
        'section'       => 'luzuk_premium_property',
        'type'          => 'select',
        'label'         => __("Select A Home", 'luzuk Premium'),
        'choices'       => $homesSingleChoice,
        'active_callback' => function($control) use ($selected_post_type_id) {
            return $control->manager->get_setting($selected_post_type_id)->value() === 'our-homes';
        }
    ));
}

lzCustomLable($wp_customize, 'luzuk_propertycolor', 'luzuk_premium_property', ' Section Color');

addColorPalatOption($wp_customize, 'property_innerbxbgClr', 'luzuk_premium_property', 'Box BG Color', '#000');

addColorPalatOption($wp_customize, 'property_innerbxtxtClr', 'luzuk_premium_property', 'Box All Text Color', '#fff');

addColorPalatOption($wp_customize, 'property_btntxtClr', 'luzuk_premium_property', 'Button Text Color', '#000');

addColorPalatOption($wp_customize, 'property_btntxtHvClr', 'luzuk_premium_property', 'Button Text Hover Color', '#fff');

addColorPalatOption($wp_customize, 'property_btnbgClr', 'luzuk_premium_property', 'Button BG Color', '#fff');

addColorPalatOption($wp_customize, 'property_btnbghvClr', 'luzuk_premium_property', 'Button BG Hover Color', '#DE0F00');