<?php 
$wp_customize->add_section(
    'service_area',
    array(
        'title'         => __( 'Services Section', 'luzuk' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);
$wp_customize->add_setting( 
    'service_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'service_area_disable',
        array(
            'settings'      => 'service_area_disable',
            'section'       => 'service_area',
            'label'         => __( 'Disable Section', 'luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk' ),
                'off' => __( 'No', 'luzuk' )
            )   
        )
    )
);

backgroundManager($wp_customize, 'service', 'service_area', $color='#fff', get_template_directory_uri().'/images/featurebg.jpg', 'color'); 

lzCustomLable($wp_customize, 'luzuk_sec_servicessectionpadding', 'service_area', 'Section Padding');

$wp_customize->add_setting(
    'service_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2.5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaTpadding',
    array(
        'settings'      => 'service_areaTpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'service_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3.2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaBpadding',
    array(
        'settings'      => 'service_areaBpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'servicearea_overlay', 'service_area', 'Section Overlay');

$wp_customize->add_setting(
    'service_areaOpacity',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.81', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaOpacity',
    array(
        'settings'      => 'service_areaOpacity',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Opacity', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'service_ovlyclr', 'service_area', 'Overlay Color ', '#000');

$wp_customize->add_setting('service_area_lbl2', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'service_area_lbl2',
        array(
            'settings'      => 'service_area_lbl2',
            'section'       => 'service_area',
            'label'         => __( 'Note 2 :', 'luzuk' ),  
            'description'   => __( 'Use Shortcode [SERVICES] to show all services in a page', 'luzuk' ),
        )
    )
);

$wp_customize->add_setting('service_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'service_npp_heading',
        array(
            'settings'      => 'service_npp_heading',
            'section'       => 'service_area',
            'label'         => __( 'Number Of Services To Show', 'luzuk' ),
        )
    )
);    
$wp_customize->add_setting('service_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 5));
$wp_customize->add_control(
    'service_npp_count',
    array(
        'settings'      => 'service_npp_count',
        'section'       => 'service_area',
        'type'          => 'select',
        'label'         => __( 'Number Of Services To Show', 'luzuk' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9)
    )
);

$ServicesSingleChoice[] = 'Select';

for( $i = 1; $i <= 9; $i++ ){
    $wp_customize->add_setting(
        'services_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'services_heading'.$i,
            array(
                'settings'      => 'services_heading'.$i,
                'section'       => 'service_area',
                'label'         => __( 'Service ', 'luzuk' ).$i,
            )
        )
    );
    if(is_array($ServicesSingleChoice)){
        $wp_customize->add_setting(
            'services_page'.$i,
            array(
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(
            'services_page'.$i,
            array(
                'settings'      => 'services_page'.$i,
                'section'       => 'service_area',
                'type'=> 'select',
                'label'         => __( 'Select A Service Box ', 'luzuk' ),
                'choices' => $ServicesSingleChoice,
            )
        );

        $wp_customize->add_setting(
        'services_page_icon1'.$i,
        array(
            'default'           => 'fa fa-money',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'services_page_icon1'.$i,
            array(
                'settings'      => 'services_page_icon1'.$i,
                'section'       => 'service_area',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'Luzuk' ),
            )
        )
    );

    }else{
        $wp_customize->add_setting('service_area_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
        $wp_customize->add_control(
            new luzuk_Info_Text( 
                $wp_customize,
                'service_area_lbl'.$i,
                array(
                    'settings'      => 'service_area_lbl'.$i,
                    'section'       => 'service_area',
                    'label'         => __( 'Note:', 'luzuk' ),    
                    'description'   => __( '<strong>Changes will not reflect unless you select the Service Page.</strong> <br/>Please add the Services from "Services menu" and then select Services to show information.', 'luzuk' ),
                )
            )
        );
    }
}

lzCustomLable($wp_customize, 'luzuk_sec_servicesclr', 'service_area', 'Service Section Color');

addColorPalatOption($wp_customize, 'services_secbxbgClr', 'service_area', 'Box BG Color ', '#fff');

addColorPalatOption($wp_customize, 'services_iconClr', 'service_area', 'Icon Color ', '#000');

addColorPalatOption($wp_customize, 'services_iconcrclClr', 'service_area', 'Icon Circle Color ', '#DE0F00');

addColorPalatOption($wp_customize, 'services_secTitleClr', 'service_area', 'Title Color ', '#000');

addColorPalatOption($wp_customize, 'services_brdClr', 'service_area', 'Border Color ', '#000');

addColorPalatOption($wp_customize, 'services_brdhvrClr', 'service_area', 'Border Hover Color', '#DE0F00');

addColorPalatOption($wp_customize, 'services_textclr', 'service_area', 'Text Color', '#7f7f7f');

addColorPalatOption($wp_customize, 'services_btntxtClr', 'service_area', 'Button Text Color ', '#000');

addColorPalatOption($wp_customize, 'services_btntxthvClr', 'service_area', 'Button Text Hover Color ', '#fff');

addColorPalatOption($wp_customize, 'services_btnbgClr', 'service_area', 'Button BG Color ', '#fff');

addColorPalatOption($wp_customize, 'services_btnbghvClr', 'service_area', 'Button BG Hover Color', '#DE0F00');

addColorPalatOption($wp_customize, 'services_btnbrdClr', 'service_area', 'Button Border Color', '#000');

addColorPalatOption($wp_customize, 'services_sldrarrwClr', 'service_area', 'Slider Arrow Color ', '#fff');

addColorPalatOption($wp_customize, 'services_sldrarrwbgClr', 'service_area', 'Slider Arrow BG Color ', '#DE0F00');

$wp_customize->add_setting(
    'services_maintitle_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'services_maintitle_subtitle_heading',
        array(
            'settings'      => 'services_maintitle_subtitle_heading',
            'section'       => 'service_area',
            'label'         => __( 'Section Heading', 'luzuk' ),
        )
    )
);

$wp_customize->add_setting(
    'service_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'What We Do ?', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_title',
    array(
        'settings'      => 'service_title',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Heading', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'service_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Lorem Ipsum Is Simply Dummy Text Of The Printing And Typesetting Industry. Lorem Ipsum Has Been The Industrys Standard Dummy Text Ever Since The 1500S, When An Unknown Printer Took A Galley Of Type And Scrambled It To Make A Type Specimen Book. It Has Survived Not Only Five Centuries, But Also The Leap Into Electronic Typesetting, Remaining Essentially Unchanged.', 'luzuk' )
    )
);
$wp_customize->add_control(
    'service_text',
    array(
        'settings'      => 'service_text',
        'section'       => 'service_area', 
        'type'          => 'text',
        'label'         => __( 'Text', 'luzuk' )
    )
);

$wp_customize->add_setting(
    'ser_btntxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Read Now', 'luzuk' )
    )
);
$wp_customize->add_control(
    'ser_btntxt',
    array(
        'settings'      => 'ser_btntxt',
        'section'       => 'service_area', 
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk' )
    )
);

$wp_customize->add_setting(
    'ser_btnlink',
    array(
        'sanitize_callback' => 'esc_url_raw',
        'default'           => __( '#', 'luzuk' )
    )
);
$wp_customize->add_control(
    'ser_btnlink',
    array(
        'settings'      => 'ser_btnlink',
        'section'       => 'service_area', 
        'type'          => 'text',
        'label'         => __( 'Button Link', 'luzuk' )
    )
);

lzCustomLable($wp_customize, 'luzuk_sec_headingclr', 'service_area', 'Service Heading Color');

addColorPalatOption($wp_customize, 'servicearea_heading_clr', 'service_area', 'Heading Color ', '#fff');

addColorPalatOption($wp_customize, 'servicearea_headingtxt_clr', 'service_area', 'Text Color ', '#959595');

addColorPalatOption($wp_customize, 'servicearea_secbtntext', 'service_area', 'Section Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'servicearea_secbtntexthv', 'service_area', 'Section Button Text Hover Color', '#fff');

addColorPalatOption($wp_customize, 'servicearea_secbtntextbg', 'service_area', 'Section Button Text BG Color', '#DE0F00');

addColorPalatOption($wp_customize, 'servicearea_secbtntextbghv', 'service_area', 'Section Button Text BG Hover Color', '#000');