<?php
/**
 * The template for displaying all single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package luzuk Premium
 */

get_header(); ?> 

<main id="innerpage-box">
    <div class="container">
        <div class="inner_contentbox">
            <div id="content-box" class="innerpage-whitebox">
                <article class="article">       
                    <?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>
                        <div id="post-<?php the_ID(); ?>" <?php post_class('post'); ?>>
                            <?php
                                $land_location = get_post_meta($post->ID, 'land_location', true);
                                $land_city = get_post_meta($post->ID, 'land_city', true);
                                $land_price = get_post_meta($post->ID, 'land_price', true);
                                $land_Propertysizeprice = get_post_meta($post->ID, 'land_Propertysizeprice', true);
                                $land_area = get_post_meta($post->ID, 'land_area', true);
                                $land_Dimension = get_post_meta($post->ID, 'land_Dimension', true);
                                $land_video_embed_code = get_post_meta(get_the_ID(), '_video_embed_code', true);
                                $map_embed_code = get_post_meta(get_the_ID(), '_custom_map_embed', true);
                                $luzuk_sinlehome_shortcode = get_theme_mod('luzuk_sinlehome_shortcode', '[Add Form shortcode]');
                                $single_home_call = get_theme_mod('single_home_call', '#');

                                $currencies = get_currency_options();
                                $currency_symbol = get_theme_mod('currency_symbol', 'USD');
                                $current_currency_symbol = $currencies[$currency_symbol];
                                
                             ?>
                            <div class="single-property-area">
                                <div class="row">
                                    <div class="col-xl-9 col-lg-8 col-md-7 col-sm-7">
                                        <div class="single-property-title">
                                             <h2><?php the_title(); ?></h2>
                                        </div>
                                        <?php
                                            if (!empty($land_location) || !empty($land_city)) {
                                        ?>
                                            <div class="single-property-address">
                                               <p> <i class="fa fa-map-marker" aria-hidden="true"></i>
                                                    <?php echo $land_location; ?> 
                                                    <?php echo $land_city; ?>
                                               </p>
                                            </div>
                                        <?php } ?>
                                        <div class="property-social-icon share-button sharer">
                                            <button type="button" class="btn share-btn"><i class="fa fa-paper-plane-o" aria-hidden="true"></i> Share</button>
                                            <div class="social networks-5 ">
                                                <a target="_blank" class="fbtn" href="https://www.facebook.com" class="wow fadeInDown" data-wow-duration="1s"><i class="fa fa-facebook"></i></a>
                                                <a target="_blank" class="fbtn" href="http://twitter.com" class="wow fadeInDown" data-wow-duration="1s"><i class="fa fa-twitter"></i></a>
                                                <a target="_blank" class="fbtn" href="http://instagram.com" class="wow fadeInDown" data-wow-duration="1s"><i class="fa fa-instagram"></i></a>
                                                <a target="_blank" class="fbtn" href="https://pinterest.com/" class="wow fadeInDown" data-wow-duration="1s"><i class="fa fa-pinterest-p" aria-hidden="true"></i></a>
                                                <a target="_blank" class="fbtn" href="https://www.linkedin.com/" class="wow fadeInDown" data-wow-duration="1s"><i class="fa fa-linkedin" aria-hidden="true"></i></a>
                                            </div>
                                            <div class="clearfix"></div>
                                        </div>
                                    </div>
                                     <div class="col-xl-3 col-lg-4 col-md-5 col-sm-5">
                                        <?php
                                             if (!empty($land_price) || !empty($land_Propertysizeprice)) {
                                        ?>
                                            <div class="single-property-pricearea">
                                                <p>Great Price</p>
                                                <h2><?php echo $current_currency_symbol,'',$land_price;?></h2>
                                                <p><?php echo $current_currency_symbol,'',$land_Propertysizeprice;?></p>
                                            </div>
                                        <?php } ?>
                                     </div>
                                </div>
                                <div class="single-property-img">
                                    <div id="big" class="owl-carousel">
                                        <div class="item">
                                             <?php  echo get_the_post_thumbnail(get_the_ID(),'larger');?>
                                        </div>
                                        <?php
                                            $gallery_data = get_post_meta(get_the_ID(), '_my_gallery_data', true);
                                            // Check if there is any gallery data
                                            if (!empty($gallery_data)) {
                                               
                                                foreach ($gallery_data as $image_url) {
                                                    echo '<div class="item">';
                                                    echo '<img src="' . esc_url($image_url) . '" alt="Gallery Image">';
                                                    echo '</div>';
                                                }
                                                
                                            }
                                        ?>
                                    </div>
                                    <div class="thumb-area">
                                        <div class="thumb-content">
                                            <div id="thumbs" class="owl-carousel owl-theme">
                                                <div class="item">
                                                    <div class="thumb-image">
                                                        <a href="#">
                                                            <?php  echo get_the_post_thumbnail(get_the_ID(),'larger');?>
                                                        </a>
                                                    </div>
                                                </div>
                                                <?php
                                                    $gallery_data = get_post_meta(get_the_ID(), '_my_gallery_data', true);
                                                    // Check if there is any gallery data
                                                    if (!empty($gallery_data)) {
                                                        foreach ($gallery_data as $image_url) {
                                                ?>
                                                    <div class="item">
                                                        <div class="thumb-image">
                                                            <a href="#">
                                                                <img src="<?php  echo esc_url($image_url); ?>" alt="Gallery Image">
                                                            </a>
                                                        </div>
                                                    </div>
                                                <?php } } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-xl-8 col-lg-8 rght-bx">
                                        <div class="single-property-desc">
                                            <h4>Description</h4>
                                            <?php the_content(); ?>
                                        </div>
                                        <?php if (!empty($land_location) || !empty($land_city) || !empty($land_price) || !empty($land_Propertysizeprice) || !empty($land_area) || !empty($land_Dimension) ) { ?>
                                            <div class="single-property-details">
                                                <h4>Details</h4>
                                                <div class="single-property-detailslist">
                                                    <div class="single-property-detailsclmn1">
                                                        <?php if (!empty($land_location)) { ?>
                                                            <div class="single-property-detailbox">
                                                                <span class="label"><i class="fa fa-map-marker" aria-hidden="true"></i>Address :</span>
                                                                <span><?php echo $land_location; ?></span>
                                                            </div>
                                                        <?php } ?>
                                                        <?php if (!empty($land_city)) { ?>
                                                            <div class="single-property-detailbox">
                                                                <span class="label"> <i class="fa fa-building" aria-hidden="true"></i>City :</span>
                                                                <span><?php echo $land_city; ?></span>
                                                            </div>
                                                        <?php } ?>
                                                    </div>
                                                    <div class="single-property-btn">
                                                        <a href="#mappop" >Open In Google Map</a>
                                                        <div id="mappop" class="video-overlay">
                                                            <div class="popup">
                                                                <a class="close" href="#">&times;</a>
                                                                <div class="custom-video-embed">
                                                                    <?php echo $map_embed_code; ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="single-property-detailsclmn2">
                                                        <?php if (!empty($land_price)) { ?>
                                                            <div class="single-property-detailbox">
                                                                <span class="label">Price :</span>
                                                                <span><?php echo $current_currency_symbol,'',$land_price;?></span>
                                                            </div>
                                                        <?php } ?>
                                                        <?php if (!empty($land_Propertysizeprice)) { ?>
                                                            <div class="single-property-detailbox">
                                                                <span class="label">Price Info :</span>
                                                                <span><?php echo $current_currency_symbol,'',$land_Propertysizeprice;?></span>
                                                            </div>
                                                        <?php } ?>
                                                        <?php if (!empty($land_Dimension)) { ?>
                                                            <div class="single-property-detailbox">
                                                                <span class="label">Property Size :</span>
                                                                <span><?php echo $land_Dimension; ?></span>
                                                            </div>
                                                        <?php } ?>
                                                        <?php if (!empty($land_area)) { ?>
                                                            <div class="single-property-detailbox">
                                                                <span class="label">Property Lot Size :</span>
                                                                <span><?php echo $land_area; ?></span>
                                                            </div>
                                                        <?php } ?>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php } ?>
                                    </div>
                                    <div class="col-xl-4 col-lg-4 rght-bx">
                                       <aside class="single-property-form ">
                                            <div class="single-property-formtitle">
                                                Inquiry with us
                                            </div>
                                            <?php echo do_shortcode($luzuk_sinlehome_shortcode);?>
                                            <?php if (!empty($single_home_call)) { ?>
                                                <div class="single-property-call">
                                                    <a class="" href="tel:<?php echo $single_home_call;?>">
                                                        <i class="fa fa-phone" ></i> Call
                                                    </a>
                                                </div>
                                            <?php } ?>
                                       </aside>
                                    </div>
                                </div>
                                <?php if (!empty($land_video_embed_code)) { ?>
                                    <div class="single-property-video">
                                        <h4>Video</h4>
                                        <a class="video" href="#vdpop">
                                            <div class="single-property-videoimg">
                                                <?php  echo get_the_post_thumbnail(get_the_ID(),'larger');?>
                                                <div class="video-icon">
                                                    <i class="fa fa-play" aria-hidden="true"></i>
                                                </div>
                                            </div>
                                        </a>
                                        <div id="vdpop" class="video-overlay">
                                            <div class="popup">
                                                <a class="close" href="#">&times;</a>
                                                <div class="custom-video-embed">
                                                    <?php echo $land_video_embed_code; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                                <?php
                                    if (!empty($map_embed_code)) {
                                ?>
                                    <div class="single-property-map">
                                        <h4>Map</h4>
                                        <div class="custom-map-embed">
                                            <?php echo $map_embed_code; ?>
                                        </div>
                                    </div>
                                <?php } ?>

                            </div>
                        </div>
                    <?php endwhile; ?>
                </article>
            </div>
        <div class="clearfix"></div>
    </div>
  <div class="clearfix"></div>
    </div>
<script type="text/javascript">
    $( document ).ready(function() {
     $( "#innerpage-box .share-btn" ).click(function(e) {
         $('#innerpage-box .networks-5').not($(this).next( "#innerpage-box .networks-5" )).each(function(){
            $(this).removeClass("active");
         });
     
            $(this).next( "#innerpage-box .networks-5" ).toggleClass( "active" );
    });   
});
</script>
</main>
<?php get_footer(); ?>