<?php
/**
*
* @package luzuk Premium
*/

if(get_theme_mod('luzuk_premium_property_disable') != 'on' ){ ?>
	<?php 
	if( get_theme_mod('property_areaTpadding',true) ) {
		$property_areaTpadding = 'padding-top:'.esc_attr(get_theme_mod('property_areaTpadding')).';';
	}
	if( get_theme_mod('property_areaBpadding',true) ) {
		$property_areaBpadding = 'padding-bottom:'.esc_attr(get_theme_mod('property_areaBpadding')).';';
	}
	if( get_theme_mod('property_areaLpadding',true) ) {
		$property_areaLpadding = 'padding-left:'.esc_attr(get_theme_mod('property_areaLpadding')).';';
	}
	if( get_theme_mod('property_areaRpadding',true) ) {
		$property_areaRpadding = 'padding-right:'.esc_attr(get_theme_mod('property_areaRpadding')).';';
	}
	
	?>	
<div id="property"> 
    <div class="container">
        <?php
            $property_title = get_theme_mod('property_title', 'We Are Where You Want To Live');
            $property_text = get_theme_mod('property_text', 'Lorem Ipsum Is Simply Dummy Text Of The Printing And Typesetting Industry. Lorem Ipsum Has Been The Industrys Standard Dummy Text Ever Since');
        ?>
        <div class="row">
            <?php if($property_title){ ?>
                <div class="col-xl-6 col-lg-6">
                    <div class="section-title">
                        <h4><span><?php echo ($property_title);  ?></span></h4>
                    </div>
                </div>
            <?php }?>
            <?php if($property_text){ ?>
                <div class="col-xl-6 col-lg-6">
                    <div class="section-text">
                        <?php echo ($property_text);  ?>
                    </div>
                </div>
            <?php }?>
        </div>
        <div class="property-post-wrap">
            <?php
                $showStatic = true; 
                for ($i = 1; $i <= 4; $i++) {
                    $selected_post_type = get_theme_mod("selected_post_type_$i");
                    $post_id = null;

                    // Determine the appropriate post ID based on the selected post type
                    if ($selected_post_type === 'our-lands') {
                        $post_id = get_theme_mod("lands_options_$i");
                    } elseif ($selected_post_type === 'our-homes') {
                        $post_id = get_theme_mod("homes_options_$i");
                    }
                   
                    if ($post_id) {
                        $showStatic = false; 
                        $post = get_post($post_id); 
                        if ($post) { 
                                if ($selected_post_type === 'our-lands') {
                                    $price = get_post_meta($post->ID, 'land_price', true);
                                } elseif ($selected_post_type === 'our-homes') {
                                    $price = get_post_meta($post->ID, 'home_price', true);
                                }

                                $home_bed = get_post_meta($post->ID, 'home_bed', true);

                                if ($selected_post_type === 'our-lands') {
                                    $dimension = get_post_meta($post->ID, 'land_Dimension', true);
                                } elseif ($selected_post_type === 'our-homes') {
                                    $dimension = get_post_meta($post->ID, 'home_Dimension', true);
                                }

                                if ($selected_post_type === 'our-lands') {
                                    $area = get_post_meta($post->ID, 'land_area', true);
                                } elseif ($selected_post_type === 'our-homes') {
                                    $area = get_post_meta($post->ID, 'home_area', true);
                                }

                                if ($selected_post_type === 'our-lands') {
                                    $location = get_post_meta($post->ID, 'land_location', true);
                                } elseif ($selected_post_type === 'our-homes') {
                                    $location = get_post_meta($post->ID, 'home_location', true);
                                }

                                if ($selected_post_type === 'our-lands') {
                                    $city = get_post_meta($post->ID, 'land_city', true);
                                } elseif ($selected_post_type === 'our-homes') {
                                    $city = get_post_meta($post->ID, 'home_city', true);
                                }

                                if ($selected_post_type === 'our-lands') {
                                    $buttontxt = get_post_meta($post->ID, 'land_buttontxt', true);
                                } elseif ($selected_post_type === 'our-homes') {
                                    $buttontxt = get_post_meta($post->ID, 'home_buttontxt', true);
                                }

                                if ($selected_post_type === 'our-lands') {
                                    $buttonlink = get_post_meta($post->ID, 'land_buttonlink', true);
                                } elseif ($selected_post_type === 'our-homes') {
                                    $buttonlink = get_post_meta($post->ID, 'home_buttonlink', true);
                                }

                                $currencies = get_currency_options();
                                $currency_symbol = get_theme_mod('currency_symbol', 'USD');
                                $current_currency_symbol = $currencies[$currency_symbol];
                            ?>
                        <div class="property-bx">
                            <div class="property-post">
                                <div class="image-bx">
                                    <div class="property-icon">
                                        <a href="<?php echo get_permalink($post_id); ?>">
                                            <?php if (has_post_thumbnail($post_id)) : ?>
                                                <img class="img-responsive" src="<?php echo get_the_post_thumbnail_url($post_id, 'large'); ?>" alt="property Image">
                                            <?php endif; ?>
                                        </a>
                                    </div>
                                    <div class="details-bx">
                                        <div class="details-topbx">
                                            <?php if (!empty($price)) { ?>
                                                <div class="property-price">
                                                    <?php echo $current_currency_symbol,'',$price;?>
                                                </div>
                                            <?php } ?>
                                            <div class="property-details">
                                                <?php if (!empty($home_bed)) { ?>
                                                    <span>
                                                        <i class="fa fa-bed" aria-hidden="true"></i>
                                                        <?php echo $home_bed; ?> 
                                                    </span>
                                                <?php } ?>
                                                <?php if (!empty($dimension)) { ?>
                                                    <span>
                                                        <i class="fa fa-square-o" aria-hidden="true"></i>
                                                        <?php echo $dimension; ?>
                                                    </span>
                                                <?php } ?>
                                                <?php if (!empty($area)) { ?>
                                                    <span>
                                                        <i class="fa fa-line-chart" aria-hidden="true"></i><?php echo $area; ?>
                                                    </span>
                                                <?php } ?>
                                            </div>
                                        </div>
                                        <div class="details-bottombx">
                                            <?php
                                                if (!empty($location) || !empty($city)) {
                                            ?>
                                                <div class="property-address">
                                                    <i class="fa fa-map-marker" aria-hidden="true"></i>
                                                    <?php echo $location; ?><br>
                                                    <?php echo $city; ?>
                                                </div>
                                            <?php } ?>
                                            <div class="sec-btn">
                                                <?php
                                                    if (!empty($buttonlink)) {
                                                ?>
                                                    <a href="<?php echo $buttonlink; ?>">
                                                        <span><?php echo $buttontxt; ?></span>
                                                    </a>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php }
                  }
                }
                if ($showStatic) { 
                    for ($i = 1; $i <= 4; $i++) { ?>
                        <div class="property-bx">
                            <div class="property-post">
                                <div class="image-bx">
                                    <div class="property-icon">
                                        <a href="#">
                                            <img class="img-responsive" src="<?php echo esc_url(get_template_directory_uri().'/images/property.jpg');?>" alt="property" />
                                        </a>
                                    </div>
                                    <div class="details-bx">
                                        <div class="details-topbx">
                                            <div class="property-price">
                                                $ 412,0000
                                            </div>
                                            <div class="property-details">
                                                <span>
                                                    <i class="fa fa-bed" aria-hidden="true"></i>
                                                    3 bed
                                                </span>
                                                <span>
                                                    <i class="fa fa-square-o" aria-hidden="true"></i>
                                                    10x10m
                                                </span>
                                                <span>
                                                    <i class="fa fa-line-chart" aria-hidden="true"></i>1600 m
                                                </span>
                                            </div>
                                        </div>
                                        <div class="details-bottombx">
                                            <div class="property-address">
                                                <i class="fa fa-map-marker" aria-hidden="true"></i>
                                                Crestview Manor ndianapolis, <br> Lorem Ipsum is simply
                                            </div>
                                            <div class="sec-btn">
                                                <a href="#"><span>Book Now</span></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php }
                } ?>
        </div>
    </div>
</div>

<?php } 