<?php   
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package luzuk Premium
 */
?>
<?php 
	if( get_theme_mod('sec_footerseTmargin',true) ) {
		$sec_footerseTmargin = 'padding-top:'.esc_attr(get_theme_mod('sec_footerseTmargin')).';';
	}
	if( get_theme_mod('sec_footersebottommargin',true) ) {
		$sec_footersebottommargin = 'padding-bottom:'.esc_attr(get_theme_mod('sec_footersebottommargin')).';';
	}
	if( get_theme_mod('sec_footersecopacity',true) ) {
		$sec_footersecopacity = 'opacity:'.esc_attr(get_theme_mod('sec_footersecopacity')).';';
	}

?>		

<footer class="footer-area" id="footer" style="<?php echo esc_attr($sec_footerseTmargin); ?>" "<?php echo esc_attr($sec_footersebottommargin); ?>" "<?php echo esc_attr($sec_footersecopacity); ?>">

	<?php if(is_active_sidebar('luzuk-footer1') || is_active_sidebar('luzuk-footer2') || is_active_sidebar('luzuk-footer3') || is_active_sidebar('luzuk-footer4') ){ ?>
	<div class="fbox"> 
		<div class="container">
			<div class="row mr-0">
				<div class="s-footer col-lg-3 col-md-6 col-sm-6 col-xs-12 single-footer-1">
					<div class="single-footer wow zoomIn" data-wow-duration="1s" >
						<?php if(is_active_sidebar('luzuk-footer1')): 
							dynamic_sidebar('luzuk-footer1');
						endif;
						?>	
					</div>
				</div>

				<div class="s-footer col-lg-3 col-md-6 col-sm-6 col-xs-12 single-footer-2">
					<div class="single-footer wow zoomIn" data-wow-duration="1.5s" >
						<?php if(is_active_sidebar('luzuk-footer2')): 
							dynamic_sidebar('luzuk-footer2');
						endif;
						?>	
					</div>
				</div>

				<div class="s-footer col-lg-3 col-md-6 col-sm-6 col-xs-12 single-footer-3">
					<div class="single-footer wow zoomIn"  data-wow-duration="2s" >
						<?php if(is_active_sidebar('luzuk-footer3')): 
							dynamic_sidebar('luzuk-footer3');
						endif;
						?>	
					</div>
				</div>

				<div class="s-footer col-lg-3 col-md-6 col-sm-6 col-xs-12 single-footer-4">
					<div class="single-footer wow zoomIn" data-wow-duration="2.5s" >
						<?php if(is_active_sidebar('luzuk-footer4')): 
							dynamic_sidebar('luzuk-footer4');
						endif;
						?>	
					</div>
				</div>
			</div>			
		</div>
	</div>
	<?php } ?>
	<?php
        $news_maintitle = get_theme_mod('news_maintitle', 'Get Our Latest Update !');
        $shortcode = get_theme_mod('luzuk_footerfm_shortcode', 'Add your form shortcode');
    ?>
  	<?php if($news_maintitle || $shortcode){ ?>
	<div class="newsletterbx">         
		<div class="container">     
			<div class="newsbxinn">           
	        	<h2><?php echo ($news_maintitle);  ?></h2>
	        	<div class="ftfm"><?php echo do_shortcode($shortcode);?></div>
	        </div>
    	</div>
    	<div class="clearfix"></div>
    </div>
    <?php } ?>
	
	<?php
		$footercopyright = get_theme_mod('footer_area_copyrighttext', 'Copyright @ 2024 All Rights Reserved');
	?>
	<?php 
		if( get_theme_mod('sec_bottomareaTmargin',true) ) {
			$sec_bottomareaTmargin = 'padding-top:'.esc_attr(get_theme_mod('sec_bottomareaTmargin')).';';
		}
		if( get_theme_mod('sec_bottomareabottommargin',true) ) {
			$sec_bottomareabottommargin = 'padding-bottom:'.esc_attr(get_theme_mod('sec_bottomareabottommargin')).';';
		}
	?>		
	<div class="bottom-area " style="<?php echo esc_attr($sec_bottomareaTmargin); ?>" "<?php echo esc_attr($sec_bottomareabottommargin); ?>">
		<!-- <div class="container"> -->
			<?php if($footercopyright){ ?>
			<div class="footer-text">			
				<?php echo $footercopyright;?>
			</div>
			<?php } ?>
		<!-- </div> -->
	</div>
	<div class="clearfix"></div>
</footer>

<script type="text/javascript">
	if(jQuery(window).width() >= 1170){
		new WOW().init();
	}
</script>
<!-- woocommerce Gallery -->
<script type="text/javascript">
    jQuery(document).ready(function(){
        setTimeout(function(){
            jQuery(".flex-control-nav").wrapInner("<div class='owl-carousel'></div>");
            jQuery('.flex-control-nav li').addClass('item');

            $('.flex-control-nav .owl-carousel').owlCarousel({
                refreshClass: 'owl-refresh',
                autoplayTimeout: 5000,
                loop: true,
                margin: 10,
                autoplay: false,
                navText: [
                    '<i class="fa fa-angle-double-left" aria-hidden="true"></i>',
                    '<i class="fa fa-angle-double-right" aria-hidden="true"></i>'
                ],
                responsive: {
                    0: {
                        items: 1,
                        nav: true
                    },
                    320: {
                        items: 2,
                        nav: true
                    },
                    1000: {
                        items: 3,
                        nav: true,
                        loop: true
                    }
                }
            });
        }, 1000);
    });
</script>
<!-- end -->

<script>
	$(window).scroll(function() {
		var height = $(window).scrollTop();
		if (height > 100) {
			$('#back2Top').fadeIn();
		} else {
			$('#back2Top').fadeOut();
		}
	});
	$(document).ready(function() {
		$("#back2Top").click(function(event) {
			event.preventDefault();
			$("html, body").animate({ scrollTop: 0 }, "slow");
			return false;
		});

	});
</script> 


<?php wp_footer(); ?>

	<!-- <a id="back2Top" title="Back to top" href="#"> &#10148; </a> -->

<a id="back2Top" title="Back to top" href="#"> 
	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" color="#000000" fill="none">
	    <path d="M8.06493 11.0322L2.88348 12.8234C0.435833 13.7381 3.7349 17.9574 4.82972 19.0466C5.92455 20.1359 10.3316 23.5832 11.251 21.1481L12.994 15.9361M3.23395 16.49L5.93563 15.1122M7.639 20.4976L8.8931 18.0545" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
	    <path d="M12.6263 8.24924L13.6285 7.25217C14.0227 6.85992 14.7108 6.93348 15.105 7.32572L16.6692 8.8819C17.0635 9.27415 17.0635 9.9101 16.6692 10.3023L15.667 11.2994C15.3715 11.5934 15.175 11.9714 15.1045 12.3812L14.61 15.2579C14.4719 16.0612 13.4803 16.3751 12.901 15.7988L8.36296 11.0114C7.78369 10.4351 7.88879 9.51181 8.69627 9.37441L11.5877 8.88241C11.9996 8.81232 12.3308 8.54324 12.6263 8.24924Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
	    <path d="M16.9444 9.00266L21.5269 4.26072C22.8839 2.91072 21.0185 1.16058 19.7191 2.45342L14.9253 6.99384" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
	</svg>
</a>

</body>
</html>
