<?php
/**
 *  functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * * @package luzuk Premium
 */
$query='';


// //  header text color ,background color option remove
function remove_customizer_colors( $wp_customize ) {
 
    // Remove controls ONLY (safe)
    $wp_customize->remove_control( 'background_color' );
    $wp_customize->remove_control( 'header_textcolor' );
 
}
add_action( 'customize_register', 'remove_customizer_colors', 100 );

define('FS_METHOD', 'direct');

if ( ! function_exists( 'luzuk_lite_setup' ) ) :
    /**
     * Sets up theme defaults and registers support for various WordPress features.
     *
     * Note that this function is hooked into the after_setup_theme hook, which
     * runs before the init hook. The init hook is too late for some features, such
     * as indicating support for post thumbnails.
     */
    
    function luzuk_lite_setup() {
    	define( 'MTS_THEME_VERSION', '2.0.6' );
        /*
    	 * Make theme available for translation.
    	 * Translations can be filed in the /languages/ directory.
    	 * If you're building a theme based on publishable, use a find and replace
    	 * to change 'luzuk Premium' to the name of your theme in all the template files.
    	 */
        load_theme_textdomain( 'luzuk Premium', get_template_directory() . '/languages' );

    	// Add default posts and comments RSS feed links to head.
        add_theme_support( 'automatic-feed-links' );

    	/*
    	 * Let WordPress manage the document title.
    	 * By adding theme support, we declare that this theme does not use a
    	 * hard-coded <title> tag in the document head, and expect WordPress to
    	 * provide it for us.
    	 */
    	add_theme_support( 'title-tag' );

    	/*
    	 * Enable support for Post Thumbnails on posts and pages.
    	 *
    	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
    	 */
    	add_theme_support( 'post-thumbnails' );
    	set_post_thumbnail_size( 150, 150, true );
    	add_image_size( 'luzuk Premium-related', 200, 125, true ); //related

    	// This theme uses wp_nav_menu() in one location.
    	register_nav_menus( array(
    		'primary' => esc_html__( 'My Custom Menu', 'luzuk Premium' ),
    	) );

    	/*
    	 * Switch default core markup for search form, comment form, and comments
    	 * to output valid HTML5.
    	 */
    	add_theme_support( 'html5', array(
    		'comment-form',
    		'comment-list',
    		'gallery',
    		'caption',
    	) );

        if ( luzuk_lite_is_wc_active() ) {
            add_theme_support( 'woocommerce' );
        }
        
    	// Set up the WordPress core custom background feature.
        add_theme_support( 'custom-background', apply_filters( 'luzuk_lite_custom_background_args', array(
          'default-color' => '#000',
          'default-image' => '',
      ) ) );
    }
endif;
add_action( 'after_setup_theme', 'luzuk_lite_setup' );

function luzuk_lite_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'luzuk_lite_content_width', 678 );
}
add_action( 'after_setup_theme', 'luzuk_lite_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function luzuk_lite_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'luzuk Premium' ),
		'id'            => 'sidebar',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="widget %2$s ">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="widget-title">',
		'after_title'   => '</h4>',
	) );

	/*// Header Ad sidebar
    register_sidebar(array(
        'name' => __('Header Ad', 'luzuk Premium'),
        'description'   => __( '728x90 Ad Area', 'luzuk Premium' ),
        'id' => 'widget-header',
        'before_widget' => '<div id="%1$s" class="widget-header">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3>',
    ));*/

    // single post side bar
    register_sidebar( array(
        'name'          => esc_html__( 'Single Post Sidebar', 'Luzuk Premium' ),
        'id'            => 'luzuk-single-post-sidebar',
        'description'   => __( 'Add widgets here to appear in your sidebar of service page.', 'Luzuk Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );

    
    // Service side bar
    register_sidebar( array(
        'name'          => esc_html__( 'Service Sidebar', 'Luzuk Premium' ),
        'id'            => 'luzuk-service-sidebar',
        'description'   => __( 'Add widgets here to appear in your sidebar of service page.', 'Luzuk Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );

    // // Project side bar
    // register_sidebar( array(
    //     'name'          => esc_html__( 'Project Sidebar', 'Luzuk Premium' ),
    //     'id'            => 'luzuk-project-sidebar',
    //     'description'   => __( 'Add widgets here to appear in your sidebar of project page.', 'Luzuk Premium' ),
    //     'before_widget' => '<aside id="%1$s" class="widget %2$s wow bounceInUp">',
    //     'after_widget'  => '</aside>',
    //     'before_title'  => '<h4 class="widget-title">',
    //     'after_title'   => '</h4>',
    // ) );

    // Shop side bar
    register_sidebar( array(
        'name'          => esc_html__( 'Shop Sidebar', 'luzuk Premium' ),
        'id'            => 'luzuk-shop-sidebar',
        'description'   => __( 'Add widgets here to appear in your sidebar of shop page.', 'luzuk Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s ">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );

    // Single Product Page side bar
    // register_sidebar( array(
    //     'name'          => esc_html__( 'Single Product Page Sidebar', 'luzuk Premium' ),
    //     'id'            => 'luzuk-single-product-pg-sidebar',
    //     'description'   => __( 'Add widgets here to appear in your sidebar of shop page.', 'luzuk Premium' ),
    //     'before_widget' => '<aside id="%1$s" class="widget %2$s ">',
    //     'after_widget'  => '</aside>',
    //     'before_title'  => '<h4 class="widget-title">',
    //     'after_title'   => '</h4>',
    // ) );

    // Blog side bar
    register_sidebar( array(
        'name'          => esc_html__( 'Blog Sidebar', 'luzuk Premium' ),
        'id'            => 'luzuk-blog-sidebar',
        'description'   => __( 'Add widgets here to appear in your sidebar of blog page.', 'luzuk Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s  ">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
    // FOOTER ONE WIDGET SIDEBAR
    register_sidebar( array(
        'name'          => esc_html__( 'Footer One', 'luzuk Premium' ),
        'id'            => 'luzuk-footer1',
        'description'   => __( 'Add widgets here to appear in your Footer.', 'luzuk Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
    // FOOTER TWO WIDGET SIDEBAR
    register_sidebar( array(
        'name'          => esc_html__( 'Footer Two', 'luzuk Premium' ),
        'id'            => 'luzuk-footer2',
        'description'   => __( 'Add widgets here to appear in your Footer.', 'luzuk Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
    // FOOTER THREE WIDGET SIDEBAR
    register_sidebar( array(
        'name'          => esc_html__( 'Footer Three', 'luzuk Premium' ),
        'id'            => 'luzuk-footer3',
        'description'   => __( 'Add widgets here to appear in your Footer.', 'luzuk Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
    // FOOTER FOUR WIDGET SIDEBAR
    register_sidebar( array(
        'name'          => esc_html__( 'Footer Four', 'luzuk Premium' ),
        'id'            => 'luzuk-footer4',
        'description'   => __( 'Add widgets here to appear in your Footer.', 'luzuk Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );

    // if ( luzuk_lite_is_wc_active() ) {
    //     // Register WooCommerce Shop and Single Product Sidebar
    //     register_sidebar( array(
    //         'name' => __('Shop Page Sidebar', 'luzuk Premium' ),
    //         'description'   => __( 'Appears on Shop main page and product archive pages.', 'luzuk Premium' ),
    //         'id' => 'shop-sidebar',
    //         'before_widget' => '<div id="%1$s" class="widget %2$s">',
    //         'after_widget' => '</div>',
    //         'before_title' => '<h4 class="widget-title">',
    //         'after_title' => '</h4>',
    //     ) );
    //     register_sidebar( array(
    //         'name' => __('Single Product Sidebar', 'luzuk Premium' ),
    //         'description'   => __( 'Appears on single product pages.', 'luzuk Premium' ),
    //         'id' => 'product-sidebar',
    //         'before_widget' => '<div id="%1$s" class="widget %2$s">',
    //         'after_widget' => '</div>',
    //         'before_title' => '<h4 class="widget-title">',
    //         'after_title' => '</h4>',
    //     ) );
    // }
}
add_action( 'widgets_init', 'luzuk_lite_widgets_init' );

function luzuk_lite_custom_sidebar() {
    // Default sidebar.
    $sidebar = 'sidebar';

    // Woocommerce.
    if ( luzuk_lite_is_wc_active() ) {
        if ( is_shop() || is_product_category() ) {
            $sidebar = 'shop-sidebar';
        }
        if ( is_product() ) {
            $sidebar = 'product-sidebar';
        }
    }

    return $sidebar;
}

/**
 * Enqueue scripts and styles.
 */
function luzuk_lite_scripts() {
    wp_enqueue_style( 'luzuk Premium-style', get_stylesheet_uri() );

    $handle = 'luzuk Premium-style';

    // WooCommerce
    if ( luzuk_lite_is_wc_active() ) {
        if ( is_woocommerce() || is_cart() || is_checkout() ) {
            wp_enqueue_style( 'woocommerce', get_template_directory_uri() . '/css/woocommerce2.css' );
            $handle = 'woocommerce';
        }
    }
    //wp_enqueue_script( 'flickity-pkgd', get_template_directory_uri() . '/js/flickity.pkgd.min.js', array('jquery'), '20160903', true );

    //wp_enqueue_script( 'jquery-bxslider-min', get_template_directory_uri() . '/js/jquery.bxslider.min.js', array('jquery'), '4.1.2', true );

    wp_enqueue_script( 'jquery-bxslider', get_template_directory_uri() . '/js/jquery.bxslider.js', array('jquery'), '4.1.2', true );
    //wp_enqueue_script( 'smoothscroll', get_template_directory_uri() . '/js/SmoothScroll.js', array(), '20160809', false );
    wp_enqueue_script( 'jquery-nav', get_template_directory_uri() . '/js/jquery.nav.js', array('jquery'), '20160903', true );
    wp_enqueue_script( 'jquery-min', get_template_directory_uri() . '/js/jquery.min.js', array('jquery'), '20160903', true );
    wp_enqueue_script( 'isotope-pkgd', get_template_directory_uri() . '/js/isotope.pkgd.js', array('jquery', 'imagesloaded' ), '20150903', true );
    wp_enqueue_script( 'nivo-lightbox', get_template_directory_uri() . '/js/nivo-lightbox.js', array('jquery'), '20150903', true );
    wp_enqueue_script( 'navigation', get_template_directory_uri() . '/js/navigation.js', array('jquery'), '20150903', true );
    wp_enqueue_script( 'superfish', get_template_directory_uri() . '/js/superfish.js', array('jquery'), '20150903', true );
    wp_enqueue_script( 'jquery-stellar', get_template_directory_uri() . '/js/jquery.stellar.js', array('imagesloaded'), '20150903', false ); 
    wp_enqueue_script( 'wow', get_template_directory_uri() . '/js/wow.js', array('jquery'), '20150903', true );
    wp_enqueue_script( 'odometer', get_template_directory_uri() . '/js/odometer.js', array('jquery'), '20150903', true );
    wp_enqueue_script( 'waypoint', get_template_directory_uri() . '/js/waypoint.js', array('jquery'), '20150903', true );
    wp_enqueue_script( 'total-custom', get_template_directory_uri() . '/js/total-custom.js', array('jquery'), '20150903', true );
    wp_enqueue_script('slider', get_template_directory_uri().'/js/slider.js', array(), '1.1', true);
    wp_localize_script( 'total-custom', 'total_localize', array('template_path' => get_template_directory_uri() ));
    //wp_enqueue_script('jquery-3-3-1-min', get_template_directory_uri().'/js/jquery-3.3.1.min.js', array(), '1.1', true);
    //  wp_enqueue_script( 'jquery-3-1-1-slim-min', get_template_directory_uri() . '/js/jquery-3.1.1.slim.min.js', array('jquery'), '20150903', true );
    wp_enqueue_style( 'bxslider', get_template_directory_uri() . '/css/jquery.bxslider.css', array(), '4.1.2' );
    wp_enqueue_style( 'style-min', get_template_directory_uri() . '/css/style.min.css', array(), '1.3.3' );
    wp_enqueue_script( 'fancybox.umd', get_template_directory_uri() . '/js/fancybox.umd.js', array('jquery'), '20150903', true );
    wp_enqueue_style( 'swiper-min', get_template_directory_uri() . '/css/swiper.min.css', array(), '1.3.3' );
    wp_enqueue_style( 'swiper-bundle-min', get_template_directory_uri() . '/css/swiper-bundle.min.css', array(), '1.3.3' );

    wp_enqueue_script( 'swiper-min', get_template_directory_uri() . '/js/swiper-min.js', array('jquery'), '4.1.2', true );
    wp_enqueue_script( 'swiper-bundle-min', get_template_directory_uri() . '/js/swiper-bundle.min.js', array('jquery'), '4.1.2', true );
    wp_enqueue_script( 'owl-carousel', get_template_directory_uri() . '/js/owl.carousel.js', array('jquery'), '1.3.3', true );
    wp_enqueue_style( 'fancybox', get_template_directory_uri() . '/css/fancybox.css', array(), '1.3.3' );
    wp_enqueue_style( 'owl-carousel', get_template_directory_uri() . '/css/owl.carousel.css', array(), '1.3.3' );
    wp_enqueue_style( 'owl-theme', get_template_directory_uri() . '/css/owl.theme.css', array(), '1.3.3' );
    wp_enqueue_style( 'owl-carousel-min', get_template_directory_uri() . '/css/owl.carousel.min.css', array(), '1.3.3' );
    wp_enqueue_style( 'owl-theme-default-min', get_template_directory_uri() . '/css/owl.theme.default.min.css', array(), '1.3.3' );
    // wp_enqueue_style( 'docs-theme-min', get_template_directory_uri() . '/css/docss.theme.min.css', array(), '1.3.3' );

    //wp_enqueue_script('owl-carousel-min', get_template_directory_uri().'/js/owl.carousel.min.js', array(), '1.1', true);
    wp_enqueue_script( 'jquery-colorbox', get_template_directory_uri() . '/js/jquery.colorbox.js', array(), '20160809', false );
    // wp_enqueue_style( 'total-fonts', total_fonts_url(), array(), null );
    // wp_enqueue_script('script', get_template_directory_uri().'/js/script.js', array(), '1.1', true);
    wp_enqueue_style( 'colorbox-popup', get_template_directory_uri() . '/css/colorbox.css', array(), '4.1.2' );
    wp_enqueue_style( 'animate', get_template_directory_uri() . '/css/animate.css', array(), '1.0' );
    wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/css/font-awesome.css', array(), '4.4.0' );


    wp_enqueue_style( 'nivo-lightbox', get_template_directory_uri() . '/css/nivo-lightbox.css', array(), '1.3.3' );
    wp_enqueue_style( 'superfish', get_template_directory_uri() . '/css/superfish.css', array(), '1.3.3' );


// extra for header
  
   wp_enqueue_style( 'templete', get_template_directory_uri() . '/css-new/templete.css', array(), '1.3.3' );

// extra for header

wp_enqueue_script( 'main', get_template_directory_uri() . '/js/main.js', array('jquery'), '20150903', true );
 wp_enqueue_style( 'style-min', get_template_directory_uri() . '/css/style.min.css', array(), '1.3.3' );

    //google fonts
    wp_enqueue_style( 'google-fonts', 'https://fonts.googleapis.com/css?family=Archivo+Narrow|Arimo|Berkshire+Swash|Bitter|Comfortaa|Dancing+Script|Dosis|Droid+Serif|Francois+One|Germania+One|Hammersmith+One|Indie+Flower|Lobster|Muli|Nosifer|PT+Sans|PT+Sans+Caption|PT+Sans+Narrow|Pacifico|Questrial|Roboto+Mono|Roboto+Slab|Source+Serif+Pro|Titillium+Web|Work+Sans|Rubik:700i' );
    // wp_add_inline_style( 'total-style', total_dymanic_styles() );

    wp_enqueue_script( 'luzuk Premium-customscripts', get_template_directory_uri() . '/js/customscripts.js',array('jquery'),'',true);

    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
      wp_enqueue_script( 'comment-reply' );
  }

  $luzuk_lite_color_scheme = get_theme_mod('luzuk_template_color', '#fe5722');
  $luzuk_lite_color_scheme2 = get_theme_mod('luzuk_template_color2', '#44afdd');
  //$header = get_theme_mod('header_textcolor', '#000');
  $luzuk_lite_layout = get_theme_mod('luzuk_lite_layout', 'cslayout');

  $custom_css = total_dymanic_styles();
  wp_add_inline_style( $handle, $custom_css );
}
add_action( 'wp_enqueue_scripts', 'luzuk_lite_scripts' );
/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/style.php';
/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';


/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/lz-customizer.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/lz-customizer-functions.php';
/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';
/**
 * Load Font Awesome list file.
 */
require get_template_directory() . '/inc/font-awesome-list.php';
/**
 * Load function file.
 */
require get_template_directory() . '/inc/functions.php';
/**
 * Add the Social buttons Widget.
 */
include_once( "functions/widget-social.php" );
require_once('functions/meta-data.php'); // ADD THE META DETA FOR THE PHP


require get_template_directory() . '/inc/notifications.php';

require get_template_directory() . '/inc/theme-tracker.php';

/**
 * Add inline styles for remote notification banner.
 */
function luzuk_lite_notification_styles() {
    $css = '
    .luzuk-lite-remote-notification {
        background: #111;
        color: #fff;
        padding: 20px 0;
        text-align: center;
        border-bottom: 4px solid #e74c3c;
    }
    .luzuk-lite-remote-notification__inner {
        max-width: 1100px;
        margin: 0 auto;
        padding: 0 20px;
    }
    .luzuk-lite-dashboard-notification + .luzuk-lite-dashboard-notification {
        margin-top: 20px;
        border-top: 1px solid #e2e4e7;
        padding-top: 20px;
    }';

    wp_add_inline_style( 'luzuk-lite-style', $css );
}
add_action( 'wp_enqueue_scripts', 'luzuk_lite_notification_styles' );

/**
 * Copyrights
 */
if ( ! function_exists( 'luzuk_lite_copyrights_credit' ) ) {
    function luzuk_lite_copyrights_credit() { 
        global $mts_options
        ?>
        <!--start copyrights-->
        <div class="copyrights">
            <div class="container">
                <div id="copyright-note">
                    <span>Copyright <?php echo '&copy; '.date_i18n(__('Y','luzuk')); ?> <?php bloginfo( 'name' ); ?>. All Rights Reserved
                    </span>
            <!--<div class="top">
            
                <a href="#top" class="toplink"><//?php //_e('Back to Top','luzuk Premium'); ?> &uarr;</a>
            </div>-->
                </div>
            </div>
        </div>
<!--end copyrights-->
<?php }
}

/**
 * Custom Comments template
 */
if ( ! function_exists( 'luzuk_lite_comments' ) ) {
	function luzuk_lite_comment($comment, $args, $depth) { ?>
		<li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
			<div id="comment-<?php comment_ID(); ?>" style="position:relative;" itemscope itemtype="http://schema.org/UserComments">
				<div class="comment-author vcard">
					<?php echo get_avatar( $comment->comment_author_email, 70 ); ?>
					<div class="comment-metadata">
                        <?php printf('<span class="fn" itemprop="creator" itemscope itemtype="http://schema.org/Person">%s</span>', get_comment_author_link()) ?>
                        <span class="comment-meta">
                          <?php edit_comment_link(__('(Edit)', 'luzuk Premium'),'  ','') ?>
                      </span>
                  </div>
              </div>
              <?php if ($comment->comment_approved == '0') : ?>
               <em><?php _e('Your comment is awaiting moderation.', 'luzuk Premium') ?></em>
               <br />
           <?php endif; ?>
           <div class="commentmetadata" itemprop="commentText">
               <?php comment_text() ?>
               <time><?php comment_date(get_option( 'date_format' )); ?></time>
               <span class="reply">
                <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
            </span>
        </div>
    </div>
</li>
<?php }
}

/*
 * Excerpt
 */
function luzuk_lite_excerpt($limit) {
  $excerpt = explode(' ', get_the_excerpt(), $limit);
  if (count($excerpt)>=$limit) {
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt);
} else {
    $excerpt = implode(" ",$excerpt);
}
$excerpt = preg_replace('`[[^]]*]`','',$excerpt);
return $excerpt;
}

/**
 * Shorthand function to check for more tag in post.
 *
 * @return bool|int
 */
function luzuk_lite_post_has_moretag() {
    return strpos( get_the_content(), '<!--more-->' );
}

if ( ! function_exists( 'luzuk_lite_readmore' ) ) {
    /**
     * Display a "read more" link.
     */
    function luzuk_lite_readmore() {
        ?>
      <!--   <div class="readMore">
            <a href="<?php //echo esc_url( get_the_permalink() ); ?>" title="<?php //the_title_attribute(); ?>" target="_blank">
                <?php //_e( 'Continue Reading', 'luzuk Premium' ); ?>
            </a>
        </div> -->

            <?php if( get_theme_mod('blogpage_button_display','show' ) == 'show') :
                      ?>
                <?php
                    $bloginner_page_id = get_theme_mod('bloginner_page'); 
                    $bloginnerbutn_text = get_theme_mod('blogbutninner_text', 'Continue Reading');
                ?>

                <a href="<?php echo esc_url( get_the_permalink() ); ?>" title="<?php the_title_attribute(); ?>" target="_blank">
                    <?php echo $bloginnerbutn_text; ?>
                        
                </a>

                <?php endif ?>
        <?php 
    }
}

/**
 * Breadcrumbs
 */
if (!function_exists('luzuk_lite_the_breadcrumb')) {
    function luzuk_lite_the_breadcrumb() {
        if ( is_front_page() ) {
            return;
        }
        echo '<span typeof="v:Breadcrumb" class="root"><a rel="v:url" property="v:title" href="';
        echo esc_url( home_url() );
        /* =====breadcrumb text====== */
        $breadcrumbhometxtbutton = get_theme_mod('luzuk_breadcrumbhometxt', 'Home'); 
        /* =====breadcrumb text====== */
        echo '">'.(sprintf( __( "$breadcrumbhometxtbutton", 'luzuk Premium' )));
        echo '</a></span><span class="bread-arrow"><i class="fa fa-minus"></i> - </span>';
        if (is_single()) {
            $categories = get_the_category();
            if ( $categories ) {
                $level = 0;
                $hierarchy_arr = array();
                foreach ( $categories as $cat ) {
                    $anc = get_ancestors( $cat->term_id, 'category' );
                    $count_anc = count( $anc );
                    if (  0 < $count_anc && $level < $count_anc ) {
                        $level = $count_anc;
                        $hierarchy_arr = array_reverse( $anc );
                        array_push( $hierarchy_arr, $cat->term_id );
                    }
                }
                if ( empty( $hierarchy_arr ) ) {
                    $category = $categories[0];
                    echo '<span typeof="v:Breadcrumb" class="post-cat"><a href="'. esc_url( get_category_link( $category->term_id ) ).'" rel="v:url" property="v:title">'.esc_html( $category->name ).'</a></span><span class="bread-arrow">
                    <i class="fa fa-angle-double-right"></i>
                    </span>';
                } else {
                    foreach ( $hierarchy_arr as $cat_id ) {
                        $category = get_term_by( 'id', $cat_id, 'category' );
                        echo '<span typeof="v:Breadcrumb"><a href="'. esc_url( get_category_link( $category->term_id ) ).'" rel="v:url" property="v:title">'.esc_html( $category->name ).'</a></span><span class="bread-arrow"><i class="fa fa-angle-double-right
                        "></i></span>';
                    }
                }
            }
            echo "<span><span class='treeEnd'>";
            the_title();
            echo "</span></span>";
        } elseif (is_page()) {
            $parent_id  = wp_get_post_parent_id( get_the_ID() );
            if ( $parent_id ) {
                $breadcrumbs = array();
                while ( $parent_id ) {
                    $page = get_page( $parent_id );
                    $breadcrumbs[] = '<span typeof="v:Breadcrumb"><a href="'.esc_url( get_permalink( $page->ID ) ).'" rel="v:url" property="v:title">'.esc_html( get_the_title($page->ID) ). '</a></span><span>
                    <i class="fa fa-angle-double-right"></i></span>';
                    $parent_id  = $page->post_parent;
                }
                $breadcrumbs = array_reverse( $breadcrumbs );
                foreach ( $breadcrumbs as $crumb ) { echo $crumb; }
            }
            echo "<span><span class='treeEnd'>";
            the_title();
            echo "</span></span>";
        } elseif (is_category()) {
            global $wp_query;
            $cat_obj = $wp_query->get_queried_object();
            $this_cat_id = $cat_obj->term_id;
            $hierarchy_arr = get_ancestors( $this_cat_id, 'category' );
            if ( $hierarchy_arr ) {
                $hierarchy_arr = array_reverse( $hierarchy_arr );
                foreach ( $hierarchy_arr as $cat_id ) {
                    $category = get_term_by( 'id', $cat_id, 'category' );
                    echo '<span typeof="v:Breadcrumb"><a href="'.esc_url( get_category_link( $category->term_id ) ).'" rel="v:url" property="v:title">'.esc_html( $category->name ).'</a></span><span><i class="fa fa-angle-double-right
                    "></i></span>';
                }
            }
            echo "<span><span class='treeEnd'>";
            single_cat_title();
            echo "</span></span>";
        } elseif (is_author()) {
            echo "<span><span class='treeEnd'>";
            if(get_query_var('author_name')) :
                $curauth = get_user_by('slug', get_query_var('author_name'));
            else :
                $curauth = get_userdata(get_query_var('author'));
            endif;
            echo esc_html( $curauth->nickname );
            echo "</span></span>";
        } elseif (is_search()) {
            echo "<span><span class='treeEnd'>";
            the_search_query();
            echo "</span></span>";
        } elseif (is_tag()) {
            echo "<span><span class='treeEnd'>";
            single_tag_title();
            echo "</span></span>";
        }
    }
}


/*
 * Google Fonts
 */
function luzuk_lite_fonts_url() {
    $fonts_url = '';

    /* Translators: If there are characters in your language that are not
    * supported by Monda, translate this to 'off'. Do not translate
    * into your own language.
    */
    $monda = _x( 'on', 'Monda font: on or off', 'luzuk Premium' );

    if ( 'off' !== $monda ) {
        $font_families = array();

        if ( 'off' !== $monda ) {
            $font_families[] = urldecode('Roboto:400,500,700,900');
        }

        $query_args = array(
            'family' => urlencode( implode( '|', $font_families ) ),
            //'subset' => urlencode( 'latin,latin-ext' ),
        );

        $fonts_url = add_query_arg( $query_args, '//fonts.googleapis.com/css' );
    }

    return $fonts_url;
}

function luzuk_lite_scripts_styles() {
    wp_enqueue_style( 'theme-slug-fonts', luzuk_lite_fonts_url(), array(), null );

}
add_action( 'wp_enqueue_scripts', 'luzuk_lite_scripts_styles' );

/**
 * WP Mega Menu Plugin Support
 */
function luzuk_lite_megamenu_parent_element( $selector ) {
    return '.primary-navigation .container';
}
add_filter( 'wpmm_container_selector', 'luzuk_lite_megamenu_parent_element' );

/**
 * Determines whether the WooCommerce plugin is active or not.
 * @return bool
 */
function luzuk_lite_is_wc_active() {
    if ( is_multisite() ) {
        include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

        return is_plugin_active( 'woocommerce/woocommerce.php' );
    } else {
        return in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) );
    }
}

/**
 * WooCommerce
 */
if ( luzuk_lite_is_wc_active() ) {
    if ( !function_exists( 'mts_loop_columns' )) {
        /**
         * Change number or products per row to 3
         *
         * @return int
         */
        function mts_loop_columns() {
            return 3; // 3 products per row
        }
    }
    add_filter( 'loop_shop_columns', 'mts_loop_columns' );

    /**
     * Redefine woocommerce_output_related_products()
     */
    function woocommerce_output_related_products() {
        $args = array(
            'posts_per_page' => 3,
            'columns' => 4,
        );
        woocommerce_related_products($args); // Display 3 products in rows of 1
    }
    
    global $pagenow;
    if ( is_admin() && isset( $_GET['activated'] ) && $pagenow == 'themes.php' ) {
        /**
         * Define WooCommerce image sizes.
         */
        function luzuk_lite_woocommerce_image_dimensions() {
            $catalog = array(
                'width'     => '210',   // px
                'height'    => '155',   // px
                'crop'      => 1        // true
            );
            $single = array(
                'width'     => '326',   // px
                'height'    => '444',   // px
                'crop'      => 1        // true
            );
            $thumbnail = array(
                'width'     => '74',    // px
                'height'    => '74',   // px
                'crop'      => 0        // false
            );
            // Image sizes
            update_option( 'shop_catalog_image_size', $catalog );       // Product category thumbs
            update_option( 'shop_single_image_size', $single );         // Single product image
            update_option( 'shop_thumbnail_image_size', $thumbnail );   // Image gallery thumbs
        }
        add_action( 'init', 'luzuk_lite_woocommerce_image_dimensions', 1 );
    }


    /**
     * Change the number of product thumbnails to show per row to 4.
     *
     * @return int
     */
    function luzuk_lite_woocommerce_thumb_cols() {
     return 4; // .last class applied to every 4th thumbnail
 }
 add_filter( 'woocommerce_product_thumbnails_columns', 'luzuk_lite_woocommerce_thumb_cols' );


    /**
     * Ensure cart contents update when products are added to the cart via AJAX.
     *
     * @param $fragments
     *
     * @return mixed
     */
    function luzuk_lite_header_add_to_cart_fragment( $fragments ) {
        global $woocommerce;
        ob_start(); ?>
        
        <a class="cart-contents" href="<?php echo esc_url( $woocommerce->cart->get_cart_url() ); ?>" title="<?php _e( 'View your shopping cart', 'luzuk Premium' ); ?>"><?php echo sprintf( _n( '%d item', '%d items', $woocommerce->cart->cart_contents_count, 'luzuk Premium' ), $woocommerce->cart->cart_contents_count );?> - <?php echo $woocommerce->cart->get_cart_total(); ?></a>
        
        <?php $fragments['a.cart-contents'] = ob_get_clean();
        return $fragments;
    }
    add_filter( 'add_to_cart_fragments', 'luzuk_lite_header_add_to_cart_fragment' );

    /**
     * Optimize WooCommerce Scripts
     * Updated for WooCommerce 2.0+
     * Remove WooCommerce Generator tag, styles, and scripts from non WooCommerce pages.
     */
    function luzuk_lite_manage_woocommerce_styles() {
        //remove generator meta tag
        remove_action( 'wp_head', array( $GLOBALS['woocommerce'], 'generator' ) );

        //first check that woo exists to prevent fatal errors
        if ( function_exists( 'is_woocommerce' ) ) {
            //dequeue scripts and styles
            if ( ! is_woocommerce() && ! is_cart() && ! is_checkout() ) {
                wp_dequeue_style( 'woocommerce-layout' );
                wp_dequeue_style( 'woocommerce-smallscreen' );
                wp_dequeue_style( 'woocommerce-general' );
                wp_dequeue_style( 'wc-bto-styles' ); //Composites Styles
                wp_dequeue_script( 'wc-add-to-cart' );
                wp_dequeue_script( 'wc-cart-fragments' );
                wp_dequeue_script( 'woocommerce' );
                wp_dequeue_script( 'jquery-blockui' );
                wp_dequeue_script( 'jquery-placeholder' );



            }
        }
    }
    add_action( 'wp_enqueue_scripts', 'luzuk_lite_manage_woocommerce_styles', 99 );

    // Remove WooCommerce generator tag.
    remove_action('wp_head', 'wc_generator_tag');
}

/**
 * Post Layout for Archives
 */
if ( ! function_exists( 'luzuk_lite_archive_post' ) ) {
    /**
     * Display a post of specific layout.
     * 
     * @param string $layout
     */
    function luzuk_lite_archive_post( $layout = '' ) { 
        $luzuk_lite_full_posts = get_theme_mod('luzuk_lite_full_posts', '0'); ?>
    <article class="post excerpt">
                <?php
            if ( is_sticky() && is_home() && ! is_paged() ) {
                printf( '<span class="sticky-post">%s</span>', __( 'Featured', 'luzuk Premium' ) );
            } ?>
        <?php if ( is_single() ) : ?>
        <div class="post-date-publishable"><?php the_time( get_option( 'date_format' ) ); ?></div>
        <?php endif; ?>


<!-- category page -->
            <div class="inner-blog-post  inner-blog-pagepost col-md-6 col-sm-12 col-xs-12">
                <?php 
                    $blgtxtlimit = get_theme_mod('blgtxtlimit', '90');
                ?>
                <div class="inner-blogpost">
                    <?php if ( empty($luzuk_lite_full_posts) ) : ?>
                        <?php if ( has_post_thumbnail() ) { ?>
                        <div class="ht-blog-thumbnail">
                            <div class="blog-image">
                                <a href="<?php the_permalink(); ?>">
                                    <?php the_post_thumbnail('luzuk Premium-featured',array('title' => '')); ?>
                                    <?php if (function_exists('wp_review_show_total')) wp_review_show_total(true, 'latestPost-review-wrapper'); ?>
                                    
                                    <?php if( get_theme_mod('postdate_button_display','show' ) == 'show') :?>
                                    <div class="blog-admin">
                                        <?php echo get_the_date( 'j, M , Y' ); ?>         
                                    </div>
                                    <?php endif ?>
                                </a>
                            </div>
                        </div>
                    <?php } else { ?>
                    <?php } ?>
                    <div class="inner-blogpost-info">                         
                        <a href="<?php the_permalink(); ?>"><h2><?php the_title(); ?></h2></a>
                        <div class="inner-blog-excerpt">
                            <?php 
                                if (has_excerpt()) {
                                          echo get_the_excerpt();
                                    } else {
                                    echo luzuk_excerpt(get_the_content(),$blgtxtlimit );  
                                }
                            ?> 
                        </div>

                        <?php
                            $blog_button2 = get_theme_mod('blog_button2', 'Read More');
                        ?>
                        <?php if($blog_button2) { ?>
                            <div class="bloginnbtn">  
                                <a class= "btn" href="<?php echo esc_url(get_permalink()); ?>">
                                    <?php echo $blog_button2 ?>
                                </a>
                                <div class="clearfix"></div>
                            </div> 
                        <?php }?>
                    </div>
                    <?php else : ?>
                    <?php if (luzuk_lite_post_has_moretag()) : ?>
                    <div class="clearfix"></div>           
                </div>
            </div> 
<!-- END category page -->
            <?php endif; ?>
        <?php endif; ?>
        <div class="clearfix"></div>
    </article>
       
        <?php }
    }


/**
 * Extras
 */
add_action( 'customize_controls_print_styles', 'luzuk_customizer_stylesheet' );

function luzuk_load_custom_wp_admin_style( $hook ) {
    if ( 'appearance_page_about-luzuk_mag' !== $hook ) {
        return;
    }
    wp_enqueue_style( 'luzuk_mag-custom-admin-css', get_template_directory_uri() . '/css/themeinfo.css', false, '1.0.0' );
}
add_action( 'admin_enqueue_scripts', 'luzuk_load_custom_wp_admin_style' );


// Adding Custome Post Type
function createCustomeTypes() {

    // Testimonials Custome type
    register_post_type( 'our-testimonial',
        array(
            'labels' => array(
                'name' => __( 'Testimonials' , 'luzuk Premium'),
                'singular_name' => __( 'Testimonial', 'luzuk Premium' )
            ),
            'public' => true,
            'featured_image'=>true,
            'has_archive' => true,
            'menu_icon' => 'dashicons-format-chat', //  The url to the icon to be used for this menu or the name of the icon from the iconfont
            'supports' => array('title', 'editor', 'thumbnail', 'page-attributes'),
        )
    );


// team
    register_post_type( 'our-team',
        array(
            'labels' => array(
                'name' => __( 'Team' , 'luzuk'),
                'singular_name' => __( 'Team', 'luzuk' )
            ),
            'public' => true,
            'featured_image'=>true,
            'has_archive' => true,
            'menu_icon' => 'dashicons-groups', //  The url to the icon to be used for this menu or the name of the icon from the iconfont
            'supports' => array('title', 'thumbnail', 'author', 'page-attributes'),
        )
    );

// Services
    register_post_type( 'our-services',
        array(
            'labels' => array(
                'name' => __( 'Services' , 'luzuk'),
                'singular_name' => __( 'Service', 'luzuk' )
            ),
            'public' => true,
            'featured_image'=>true,
            'has_archive' => true,
            'menu_icon' => 'dashicons-update', //  The url to the icon to be used for this menu or the name of the icon from the iconfont
            'supports' => array('title', 'editor', 'thumbnail', 'author', 'page-attributes'),
        )
    );  
    
    //     // projects 
    // register_post_type( 'our-projects',
    //     array(
    //         'labels' => array(
    //             'name' => __( 'Projects' , 'luzuk'),
    //             'singular_name' => __( 'Project', 'luzuk' )
    //         ),
    //         'public' => true,
    //         'featured_image'=>true,
    //         'has_archive' => true,
    //         'menu_icon' => 'dashicons-layout', //  The url to the icon to be used for this menu or the name of the icon from the iconfont
    //         'supports' => array('title','editor', 'thumbnail', 'page-attributes'),
    //     )
    // );  
    
    
     // Gallery Custome type
    register_post_type( 'our-gallery',
        array(
            'labels' => array(
                'name' => __( 'Gallery' , 'luzuk'),
                'singular_name' => __( 'gallery', 'luzuk' )
            ),
            'public' => true,
            'featured_image'=>true,
            'has_archive' => true,
            'menu_icon' => 'dashicons-admin-media', //  The url to the icon to be used for this menu or the name of the icon from the iconfont
            'supports' => array('title', 'thumbnail', 'author', 'page-attributes'),
        )
    ); 
     // FAQ Custome type
    register_post_type( 'our-faq',
        array(
            'labels' => array(
                'name' => __( 'FAQs' , 'luzuk'),
                'singular_name' => __( 'FAQ', 'luzuk' )
            ),
            'public' => true,
            'featured_image'=>true,
            'has_archive' => true,
            'menu_icon' => 'dashicons-format-status', //  The url to the icon to be used for this menu or the name of the icon from the iconfont
            'supports' => array('title', 'editor', 'page-attributes'),
        )
    );

   // SLIDER Custome type
    register_post_type( 'slider',
        array(
            'labels' => array(
                'name' => __( 'Sliders' , 'luzuk-premium'),
                'singular_name' => __( 'Slider', 'luzuk-premium' )
            ),
            'public' => true,
            'featured_image'=>true,
            'has_archive' => true,
            'menu_icon' => 'dashicons-images-alt', //  The url to the icon to be used for this menu or the name of the icon from the iconfont
            'supports' => array('title' , 'editor', 'thumbnail', ),
        )
    );
}


//add web hook for save the custome field
add_action('save_post', 'saveCustomFieds');
add_action( 'init', 'createCustomeTypes' );


 add_action( 'add_meta_boxes', 'lzLuzukSliderCustomFild' );
/**
 * Method to add the custom field for the slider postsM 
 * @author Luzuk <support@luzuk.com>
 * @since V 1.1  09th Oct 2017
 **/
function lzLuzukSliderCustomFild(){
    add_meta_box( 'luzuk-more-btn-link', __('Slider button link to page', 'luzuk-premium'), 'lzLuzukSliderPages', 'slider', 'normal', 'high' );
}


// /**
//  * Method to add the custom field's html that to be apears at the admin section
//  * @author Luzuk <support@luzuk.com>
//  * @since V 1.1  09th Oct 2017
//  **/
function lzLuzukSliderPages(){
    global $post;
    // Use nonce for verification
    wp_nonce_field( plugin_basename( __FILE__ ), 'Sider_button_link' );
    //get the saved meta as an array
    $slider_btn_link = get_post_meta($post->ID,'slider_btn_link',false);
    $sliderBtnTxt = get_post_meta($post->ID,'sliderBtnTxt',false);
    $luzuk_pages = get_pages(array('hide_empty' => 0));
    echo '<div>Select the page : ';
    echo '<select name="sliderBtnLink">';
    echo '<option>Select page</option>';
    foreach ($luzuk_pages as $luzuk_pages_single) {
        $selected = ( $luzuk_pages_single->ID == $slider_btn_link[0] )?'selected':'';
        echo '<option value="'.$luzuk_pages_single->ID.'" '.$selected.'>'.$luzuk_pages_single->post_title.'</option>';
    }
    echo '</select></div>';
    echo '<div>Button Text :';
    echo '<input type="text" name="sliderBtnTxt" value="'.$sliderBtnTxt[0].'" /></div>';
}


/**
 * Method to save the custom field for the slider posts 
 * When the post is saved, saves our custom data 
 * @param integer $post_id - An id of the post 
 * @author Luzuk <support@luzuk.com>
 * @since V 1.1  09th Oct 2017
 **/
function saveCustomFieds($post_id){
    // verify if this is an auto save routine. 
    // If it is our form has not been submitted, so we dont want to do anything
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) 
        return;
    // verify this came from the our screen and with proper authorization,
    // because save_post can be triggered at other times
    if ( !isset( $_POST['Sider_button_link'] ) )
        return;

    if ( !wp_verify_nonce( $_POST['Sider_button_link'], plugin_basename( __FILE__ ) ) )
        return;

    // OK, we're authenticated: we need to find and save the data
    $sliderBtnLink = $_POST['sliderBtnLink'];
    $sliderBtnTxt = $_POST['sliderBtnTxt'];
    update_post_meta($post_id,'slider_btn_link',$sliderBtnLink);
    update_post_meta($post_id,'sliderBtnTxt',$sliderBtnTxt);
}
// add web hook for save the custome field
add_action('save_post', 'saveCustomFieds');
add_action( 'init', 'createCustomeTypes' );

// for slider Sub title

// function sliderchangedateCutomFieldHtml(){
//     global $post;
//     $sliderchangedate = get_post_meta($post->ID, 'sliderchangedate', false);
//     $sliderchangedate = !empty($sliderchangedate[0])?$sliderchangedate[0]:'';

//     // Use nonce for verification
//     wp_nonce_field(plugin_basename(__FILE__), 'sliderbtn_text');


//       echo '<table id="sliderbtntext" width="100%">';
//     echo '<tr> 
//      <th width="10%"><span class="dashicons dashicons-edit-large"></span></th>
//     <td width="90%"><input type="textarea" name="sliderchangedate" width="100%" placeholder="Sub Title " value="'.$sliderchangedate.'" /></td>
//     </tr>';
//     echo '</table>';
// }

// function addsliderchangedateHook(){
//     add_meta_box('sliderdatetext', __('Add Sub Title', 'luzuk-premium'), 'sliderchangedateCutomFieldHtml', 'slider', 'normal', 'high');
// }

// function savesliderchangedateCutomData($post_id){
//     // If it is our form has not been submitted, so we dont want to do anything
//     if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
//         return;
//     if (isset($_POST['sliderchangedate'])) {

//     $sliderchangedate = $_POST['sliderchangedate'];
//     update_post_meta($post_id, 'sliderchangedate', $sliderchangedate);
    
//     }
// }
// add_action('add_meta_boxes', 'addsliderchangedateHook');
// add_action('save_post', 'savesliderchangedateCutomData');
//-----------------------------------------------------------

// end Date Field 

// for slider Time text

//function sliderchangetimeCutomFieldHtml(){
    // global $post;
    // // get the saved value 
    // $sliderchangetime = get_post_meta($post->ID, 'sliderchangetime', false);
    // $sliderchangetime = !empty($sliderchangetime[0])?$sliderchangetime[0]:'';




    //   echo '<table id="sliderbtntext" width="100%">';
    // echo '<tr> 
    //  <th width="10%"><span class="dashicons dashicons-edit-large"></span></th>
    // <td width="90%"><input type="text" name="sliderchangetime" width="100%" placeholder="Slider Time " value="'.$sliderchangetime.'" /></td>
    // </tr>';
    // echo '</table>';
//}

// function addsliderchangetimeHook(){
//     add_meta_box('slidertimetext', __('Add Time', 'luzuk-premium'), 'sliderchangetimeCutomFieldHtml', 'slider', 'normal', 'high');
// }

// function savesliderchangetimeCutomData($post_id){
//     // If it is our form has not been submitted, so we dont want to do anything
//     if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
//         return;
//     if (isset($_POST['sliderchangetime'])) {

//     $sliderchangetime = $_POST['sliderchangetime'];
//     update_post_meta($post_id, 'sliderchangetime', $sliderchangetime);
    
//     }
// }
// add_action('add_meta_boxes', 'addsliderchangetimeHook');
// add_action('save_post', 'savesliderchangetimeCutomData');

// end Time Field 
/***** Start Add custome fields for team section *****/
/**
 * Method to save the custom field for the team posts 
 * When the post is saved, saves our custom data 
 * @author luzuk <support@luzuk.com>
 * @since V 1.1  09th Oct 2017
 **/
function teamSocialURLsCutomFieldHtml(){
    global $post;
    // get the saved value 
    $teamFacebook = get_post_meta($post->ID, 'teamFacebook', false);
    $teamFacebookValue = !empty($teamFacebook[0])?$teamFacebook[0]:'';
    $teamTwitter = get_post_meta($post->ID, 'teamTwitter', false);
    $teamTwitterValue = !empty($teamTwitter[0])?$teamTwitter[0]:'';
    $teamInstagram = get_post_meta($post->ID, 'teamInstagram', false);
    $teamInstagramValue = !empty($teamInstagram[0])?$teamInstagram[0]:'';

    //$teamlinkedIn = get_post_meta($post->ID, 'teamlinkedIn', false);
   // $teamlinkedInValue = !empty($teamlinkedIn[0])?$teamlinkedIn[0]:'';

     $teamPinterest = get_post_meta($post->ID, 'teamPinterest', false);
    $teamPinterestValue = !empty($teamPinterest[0])?$teamPinterest[0]:'';

    // Use nonce for verification
    wp_nonce_field(plugin_basename(__FILE__), 'Team_social_media_links');
    echo '<table id="socialUrls" width="100%">';
    echo '<tr> 
    <th width="10%"><span class="dashicons dashicons-facebook"></span></th>
    <td width="90%"><input type="text" name="teamFacebook" width="100%" placeholder="Facebook URL" value="'.$teamFacebookValue.'" /></td>
    </tr>';
    echo '<tr> 
    <th><span class="dashicons dashicons-twitter"></span></th>
    <td><input type="text" name="teamTwitter" placeholder="Twitter URL" width="100%" value="'.$teamTwitterValue.'" /></td>
    </tr>';
   
    echo '<tr> 
    <th><span class="dashicons dashicons-smartphone"></span></th>
    <td><input type="text" name="teamInstagram" placeholder="Instagram URL" width="100%" value="'.$teamInstagramValue.'" /></td>
    </tr>';

    echo '<tr> 
    <th><span class="dashicons dashicons-editor-ltr"></span></th>
    <td><input type="text" name="teamPinterest" placeholder="Pinterest URL" width="100%" value="'.$teamPinterestValue.'" /></td>
    </tr>';

    // echo '<tr> 
    // <th><span class="dashicons dashicons-businessman"></span></th>
    // <td><input type="text" name="teamlinkedIn" placeholder="Linkedin URL" width="100%" value="'.$teamlinkedInValue.'" /></td>
    // </tr>';

    echo '</table>';
}

/**
 * Method to save the custom field for the slider posts 
 * When the post is saved, saves our custom data 
 * @author luzuk <support@luzuk.com>
 * @since V 1.1  09th Oct 2017
 **/
function teamDesignationCutomFieldHtml(){
    global $post;
    // get the saved value 
    $designation = get_post_meta($post->ID, 'designation', false);
    $designation = !empty($designation[0])?$designation[0]:'';

    // Use nonce for verification
    wp_nonce_field(plugin_basename(__FILE__), 'Team_social_media_links');
    echo '<table id="socialUrls" width="100%">';
    echo '<tr> 
    <th width="10%"><span class="dashicons dashicons-welcome-learn-more"></span></th>
    <td width="90%"><input type="text" name="designation" width="100%" placeholder="Designation" value="'.$designation.'" /></td>
    </tr>';
    echo '</table>';
}

function addTeamHook(){
    add_meta_box('luzuk-team-social', __('Add Social media links', 'luzuk'), 'teamSocialURLsCutomFieldHtml', 'our-team', 'normal', 'high');
    add_meta_box('luzuk-team-designation', __('Add Designation', 'luzuk'), 'teamDesignationCutomFieldHtml', 'our-team', 'normal', 'high');
}
/**
 * Method to save the custom field for the testimonial posts 
 * When the post is saved, saves our custom data 
 * @param integer $post_id - An id of the post 
 * @author luzuk <support@luzuk.com>
 * @since V 1.1  09th Oct 2017
 **/
function saveTeamSocialCutomData($post_id){
    // If it is our form has not been submitted, so we dont want to do anything
    if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return;
    if(empty($_POST['teamFacebook']) && empty($_POST['teamTwitter']) && empty($_POST['teamlinkedIn']) && empty($_POST['teamPinterest']) && empty($_POST['teamInstagram']) && empty($_POST['designation']) ){
        // echo 'empty --> '; exit;       
        return;
    }
    $teamFacebook = $_POST['teamFacebook'];
    update_post_meta($post_id, 'teamFacebook', $teamFacebook);
    $teamTwitter = $_POST['teamTwitter'];
    update_post_meta($post_id, 'teamTwitter', $teamTwitter);
    // $teamGPlus = $_POST['teamGPlus'];
    // update_post_meta($post_id, 'teamGPlus', $teamGPlus);
    $teamInstagram = $_POST['teamInstagram'];
    update_post_meta($post_id, 'teamInstagram', $teamInstagram);

    $teamlinkedIn = $_POST['teamlinkedIn'];
    update_post_meta($post_id, 'teamlinkedIn', $teamlinkedIn);


    $teamPinterest = $_POST['teamPinterest'];
    update_post_meta($post_id, 'teamPinterest', $teamPinterest);

    $designation = $_POST['designation'];
    update_post_meta($post_id, 'designation', $designation);
}
add_action('add_meta_boxes', 'addTeamHook');
add_action('save_post', 'saveTeamSocialCutomData');
/***** End Add custome fields for team section *****/
/**
 * Method to save the custom field for the slider posts 
 * When the post is saved, saves our custom data 
 * @author luzuk <support@luzuk.com>
 * @since V 1.1  09th Oct 2017
 **/
function testimonialCutomFieldHtml(){
    global $post;
    // get the saved value 
    $testimonialSubTitle = get_post_meta($post->ID, 'testimonial_Sub_Title', false);
    $value = !empty($testimonialSubTitle[0])?$testimonialSubTitle[0]:'';
    // Use nonce for verification
    wp_nonce_field(plugin_basename(__FILE__), 'Testimonial_sut_title');
    echo '<div class="rows"> 
        <div class="col-sm-3">Authors Designation</div>
        <div class="col-sm-9"><input type="text" name="testimonialSubTitle" placeholder="Designation" value="'.$value.'" /></div>
    </div>';
}
function addTestimonialHook(){
    add_meta_box('lz-finesss-sub-title', __('Add subtitle for the testimonial', 'luzuk-premium'), 'testimonialCutomFieldHtml', 'our-testimonial', 'normal', 'high');
}
/**
 * Method to save the custom field for the testimonial posts 
 * When the post is saved, saves our custom data 
 * @param integer $post_id - An id of the post 
 * @author luzuk <support@luzuk.com>
 * @since V 1.1  09th Oct 2017
 **/
function saveTestimonialCutomData($post_id){
    // If it is our form has not been submitted, so we dont want to do anything
    if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return;
    if(empty($_POST['Testimonial_sut_title']))
        return;
    if(!wp_verify_nonce($_POST['Testimonial_sut_title'], plugin_basename(__FILE__)))
        return;
    $testimonial_Sub_Title = $_POST['testimonialSubTitle'];
    update_post_meta($post_id, 'testimonial_Sub_Title', $testimonial_Sub_Title);
}
add_action('add_meta_boxes', 'addTestimonialHook');
add_action('save_post', 'saveTestimonialCutomData');

/**
 * Method to save the custom field for the testimonial posts 
 * When the post is saved, saves our custom data 
 * @param integer $post_id - An id of the post 
 * @author luzuk <support@luzuk.com>
 * @since V 1.1  09th Oct 2017
 **/
function getFonts($list = false, $index = -1){
    $fonts = array(
        "'Archivo Narrow', sans-serif",
        "'Arial', sans-serif",
        "'Arimo', sans-serif",
        "'Alex Brush', cursive",
        "'Berkshire Swash', cursive",
        "'Bitter', serif",
        "'Comfortaa', cursive",
        "'Dancing Script', cursive",
        "'Dosis', sans-serif",
        "'Droid Serif', serif",
        "'EB Garamond', serif",
        "'Exo 2', sans-serif",
        "'Francois One', sans-serif",
        "'Germania One', cursive",
        "'Hammersmith One', sans-serif",
        "'Indie Flower', cursive",
        "'Laila', sans-serif",
        "'Lobster', cursive",
        "'Lato', sans-serif",
        "'Mulish', sans-serif",
        "'Muli', sans-serif",
        "'Nosifer', cursive",
        "'Oleo Script', sans-serif",
        "'Oswald', sans-serif",
        "'PT Sans Caption', sans-serif",
        "'PT Sans Narrow', sans-serif",
        "'PT Sans', sans-serif",
        "'Pacifico', cursive",
        "'Poppins', sans-serif",
        "'Open Sans', sans-serif",
        "'Montserrat', sans-serif",
        "'Pontano Sans', sans-serif",
        "'Questrial', sans-serif",
        "'Raleway', sans-serif",
        "'Roboto Mono', monospace",
        "'Roboto Slab', serif",
        "'Roboto', sans-serif",
        "'Rubik', sans-serif",
        "'Source Serif Pro', serif",
        "'Titillium Web', sans-serif",
        "'Biryani', sans-serif", 
        "'Montserrat Alternates', sans-serif",
        "'Work Sans', sans-serif",
        "'Arvo', serif",
        "'Passion One', cursive",
        "'Playfair Display', serif",
        "'Schoolbell', cursive",
        
    );
    if($list == true){
        foreach ($fonts as $key => $value) {
            $fonts[$key] = str_replace("'", "", $value);
        }
        asort($fonts);
        return $fonts;
    }
    $len = count($fonts);
    if(is_integer($index) && $index >= 0 && $index < $len){
        return $fonts[$index];
    }else{
        return $fonts;
    }
}

/**
 * show the pagination for the custome or normal post types
 * @param object $customeQuery - An onject of a query post
 * @author luzuk <support@luzuk.com>
 * @since V 1.1  09th Nov 2017
 **/
function lzGetPagination($customQuery){
    if(!is_object($customQuery)){return false;}
    $total_pages = $customQuery->max_num_pages;
    $big = 999999999;
    $current_page = max(1, get_query_var('paged'));
    echo paginate_links(array(
        'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
        'format' => '?paged=%#%',
        'current' => $current_page,
        'total' => $total_pages,    
    ));
}

// Redirects to checkout 
// add_filter ('add_to_cart_redirect', 'redirect_user_to_checkout');

// function redirect_user_to_checkout() {
//   global $woocommerce;
//   $checkout_url = $woocommerce->cart->get_cart_url();
//   return $checkout_url;
// }

// disable double add to cart of a product
add_filter('woocommerce_add_to_cart_validation', 'my_validation_handler', 10, 2);
function my_validation_handler($is_valid, $product_id) {
    foreach(WC()->cart->get_cart() as $cart_item_key => $values) {
        if ($values['data']->get_id() == $product_id) {
            return false;
        }
    }
    return $is_valid;
}

/**
* WooCommerce Extra Feature
* --------------------------
*
* Change number of related products on product page
* Set your own value for 'posts_per_page'
*
*/ 

// Single product image gallery zoom and slider

add_action( 'after_setup_theme', 'yourtheme_setup' );

function yourtheme_setup() {
    add_theme_support( 'wc-product-gallery-zoom' );
    add_theme_support( 'wc-product-gallery-lightbox' );
    add_theme_support( 'wc-product-gallery-slider' );
    add_theme_support( 'woocommerce' );
}


add_filter( 'woocommerce_single_product_carousel_options', 'cuswoo_update_woo_flexslider_options' );
/** 
 * Filer WooCommerce Flexslider options - Add Navigation Arrows
 */
function cuswoo_update_woo_flexslider_options( $options ) {

    $options['directionNav'] = true;

    return $options;
}

// For the category title
remove_action('woocommerce_shop_loop_subcategory_title', 'woocommerce_template_loop_category_title', 10);

function my_custom_woocommerce_template_loop_category_title($category) {
    ?>
    <h2>
        <?php
        echo esc_html($category->name);
        // if ( $category->count > 0 ) {
        //     echo apply_filters('woocommerce_subcategory_count_html', ' <mark class="count">' . esc_html($category->count) . ' ' . __('products', 'woocommerce') . '</mark>', $category);
        // }
        ?>
    </h2>
    <?php
}

add_action('woocommerce_shop_loop_subcategory_title', 'my_custom_woocommerce_template_loop_category_title', 10);



//Product weight & Size
function display_custom_size_options_and_weight_on_product_page() {
    global $product;

    if ( $product->is_type( 'variable' ) ) {
        $available_variations = $product->get_available_variations();
        $attributes = $product->get_variation_attributes();
        $sizes = $attributes['pa_size'] ?? [];

        if ( ! empty( $sizes ) ) {
            // Add CSS to hide the default select input and style the custom size options
            echo '<style>
                .variations select[name="attribute_pa_size"] { display: none; }
                .custom-size-options {  gap: 10px; margin: 20px 0; }
                .custom-size-options .size-option { padding: 7px 12px;border: 1px solid #ddd;border-radius: 0px;cursor: pointer;background: #fff;margin: 0;line-height: 1;height: 100%;font-size: 16px;}
                .custom-size-options .size-option.active { border-color: #000; }
            </style>';

            echo '<div class="custom-size-options">';
            echo '<p><b>Size : </b>';   echo '</p>';  
            
            $first = true;
            foreach ( $sizes as $size ) {
                $size_name = ucwords(str_replace('-', ' ', $size));
                $active_class = $first ? ' active' : '';
                $default_value = $first ? ' data-default="' . esc_attr( $size ) . '"' : '';
                echo '<span class="size-option' . $active_class . '" data-attribute-name="attribute_pa_size" data-value="' . esc_attr( $size ) . '"' . $default_value . '>' . esc_html( $size_name ) . '</span>';
                $first = false;
            }

            echo '</div>';

            // Display the weight container
            echo '<div class="weight-container">';
            echo '<p><b>Weight : </b>';   
            echo '<span class="current-weight">' . esc_html( $product->get_weight() ) . ' ' . get_option('woocommerce_weight_unit') . '</span>';
            echo '</p>'; 
            echo '</div>';

            // Include variation weights in a hidden div for JavaScript to use
            echo '<div id="variation-weights" style="display:none;">';
            foreach ($available_variations as $variation) {
                echo '<span data-size="' . esc_attr($variation['attributes']['attribute_pa_size']) . '" data-weight="' . esc_attr($variation['weight']) . '"></span>';
            }
            echo '</div>';
        }
    }
}
add_action( 'woocommerce_single_product_summary', 'display_custom_size_options_and_weight_on_product_page', 26 );

// JavaScript code to handle size option selection and weight update
add_action('wp_footer', 'size_options_script');
function size_options_script() {
    ?>
    <script type="text/javascript">
    jQuery(document).ready(function($) {
        // Set default size option
        var defaultSize = $('.size-option.active').data('value');
        $('select[name="attribute_pa_size"]').val(defaultSize).change();

        // Get initial weight
        var defaultVariation = $('select[name="attribute_pa_size"]').val();
        updateWeight(defaultVariation);

        // Handle size option selection
        $('.custom-size-options').on('click', '.size-option', function() {
            // Remove active class from all size options
            $('.size-option').removeClass('active');

            // Add active class to the clicked size option
            $(this).addClass('active');

            var attribute_name = $(this).data('attribute-name');
            var value = $(this).data('value');

            // Update the hidden select input
            $('select[name="' + attribute_name + '"]').val(value).change();

            // Update the weight
            updateWeight(value);
        });

        function updateWeight(size) {
            // Find the weight for the selected size
            var weight = $('#variation-weights span[data-size="' + size + '"]').data('weight');

            // Update the weight container
            if (weight) {
                $('.current-weight').text(weight + ' ' + '<?php echo get_option('woocommerce_weight_unit'); ?>');
            }
        }
    });
    </script>
    <?php
}



 // Available quantity   

// function display_total_stock_quantity() {
//     global $product;

//     if ( is_product() && $product->is_in_stock() ) {
//         $stock_quantity = $product->get_stock_quantity();
//         echo '<div class="product-total-stock">';
//         echo '<p><b> Available : </b>' . esc_html( $stock_quantity ) . ' In Stock</p>';
//         echo '</div>';
//     } else {
//         echo '<div class="product-total-stock">';
//         echo '<p>This product is out of stock.</p>';
//         echo '</div>';
//         echo '<div class="clearfix">'; echo '</div>';
//     }
// }
// add_action( 'woocommerce_single_product_summary', 'display_total_stock_quantity', 26 );


 // quantity end  

// price 


// 

  
// -------------
// 1. Show plus minus buttons
  
// single php 
// quantiy option button

// Display "MADE TO ORDER" label before the quantity input
add_action('woocommerce_before_add_to_cart_quantity', 'woosuite_echo_qty_front_add_cart');
function woosuite_echo_qty_front_add_cart() {
    echo '<div class="qty-label">MADE TO ORDER: </div>';
}
function bbloomer_setup_quantity_buttons() {
    if (function_exists('is_product') && is_product()) {
        add_action('woocommerce_after_quantity_input_field', 'bbloomer_display_quantity_plus');
        add_action('woocommerce_before_quantity_input_field', 'bbloomer_display_quantity_minus');
        add_action('wp_footer', 'bbloomer_add_cart_quantity_plus_minus');
    }
}

function bbloomer_display_quantity_plus() {
    echo '<button type="button" class="plus" style="margin-left: 5px;">+</button>';
}

function bbloomer_display_quantity_minus() {
    echo '<button type="button" class="minus" style="margin-right: 5px;">-</button>';
}
function bbloomer_add_cart_quantity_plus_minus() {
    wc_enqueue_js("
        jQuery(document).ready(function($) {
            // Handle the click event on the + and - buttons
            $('body').on('click', '.plus, .minus', function() {
                var qty = $(this).closest('.quantity').find('.qty'); // Find the quantity input field
                var val = parseInt(qty.val()); // Get the current value of the input field
                var max = parseInt(qty.attr('max')); // Get the max value
                var min = parseInt(qty.attr('min')); // Get the min value
                var step = parseInt(qty.attr('step')); // Get the step value

                // Increase Quantity
                if ($(this).hasClass('plus')) {
                    if (max && (val < max)) {
                        qty.val(val + step).change(); // Increase the quantity and trigger change event
                    } else if (!max) {
                        qty.val(val + step).change(); // No max, increase the quantity
                    }
                }
                // Decrease Quantity
                if ($(this).hasClass('minus')) {
                    if (min && (val > min)) {
                        qty.val(val - step).change(); // Decrease the quantity and trigger change event
                    } else if (!min) {
                        qty.val(val - step).change(); // No min, decrease the quantity
                    }
                }
            });
        });
    ");
}

// Initialize the quantity buttons
add_action('wp', 'bbloomer_setup_quantity_buttons');


// buy now Button 

/* Dynamic buy now Button for Simple & Variable Product */

function sbw_wc_add_buy_now_button_single() {
    global $product;

    // Output the button with an extra JavaScript action
    printf(
        '<button id="sbw_wc-adding-button" type="submit" name="sbw-wc-buy-now" value="%d" class="single_add_to_cart_button buy_now_button button alt">%s</button>',
        $product->get_ID(),
        esc_html__('Buy Now', 'sbw-wc')
    );

    // Add JavaScript to redirect to the cart page after adding to the cart
    ?>
    <script type="text/javascript">
        jQuery(document).ready(function($) {
            $('#sbw_wc-adding-button').on('click', function(e) {
                e.preventDefault();
                var product_id = $(this).val();

                // Trigger form submission
                var form = $(this).closest('form');
                form.append('<input type="hidden" name="add-to-cart" value="' + product_id + '">');
                form.submit();

                // Redirect to cart page after adding to cart
                setTimeout(function() {
                    window.location.href = '<?php echo wc_get_cart_url(); ?>';
                }, 500); // Adjust delay if necessary
            });
        });
    </script>
    <?php
}

add_action('woocommerce_after_add_to_cart_button', 'sbw_wc_add_buy_now_button_single');

// 

// // star rating
// // Ensure WooCommerce functions are available
// if ( ! function_exists( 'is_woocommerce' ) ) {
//     return;
// }

// // Function to display custom star ratings
// function custom_woocommerce_display_rating() {
//     global $product;

//     if ( ! $product ) {
//         return;
//     }

//     // Get the average rating
//     $average = $product->get_average_rating();

//     // Check if the product has a rating
//     if ( $average ) {
//         echo '<div class="custom-star-rating" style="display: flex; align-items: center;">';
//         // Display star ratings as images or custom HTML
//         for ( $i = 1; $i <= 5; $i++ ) {
//             if ( $i <= $average ) {
//                 // Full star
//                 echo '<span style="color: gold;">&#9733;</span>';
//             } else {
//                 // Empty star
//                 echo '<span style="color: lightgray;">&#9734;</span>';
//             }
//         }
//         echo '</div>';
//     }
// }

// single page Description , Additional Information , Reviews
// // Remove product tabs in WooCommerce
add_filter( 'woocommerce_product_tabs', 'remove_woocommerce_product_tabs', 98 );

function remove_woocommerce_product_tabs( $tabs ) {
    unset( $tabs['description'] );       // Remove the description tab
    unset( $tabs['reviews'] );           // Remove the reviews tab
    unset( $tabs['additional_information'] );  // Remove the additional information tab
    return $tabs;
}




// For Review text

function custom_woocommerce_comments($comment, $args, $depth) {
    $GLOBALS['comment'] = $comment;
    $rating = intval(get_comment_meta($comment->comment_ID, 'rating', true));
    $comment_date = get_comment_date('F j, Y', $comment->comment_ID); // Format date as 'Month day, Year'

    echo '<li ' . comment_class('', null, null, false) . ' id="li-comment-' . $comment->comment_ID . '">';

    echo '<div id="comment-' . $comment->comment_ID . '" class="comment_container">';

    echo get_avatar($comment, apply_filters('woocommerce_review_gravatar_size', '60'), '');

    echo '<div class="comment-text">';

    // Meta information with author and review date
    echo '<p class="meta"><strong class="woocommerce-review__author">' . get_comment_author() . '</strong> ';

    if ($rating && wc_review_ratings_enabled()) {
        echo wc_get_rating_html($rating); // Displays the rating
    }

    echo '<span class="woocommerce-review__date">' . $comment_date . '</span></p>';
     echo '<div class="review-verification">';
    if (get_option('woocommerce_review_rating_verification_label') && wc_review_is_from_verified_owner($comment->comment_ID)) {
        echo '<em class="woocommerce-review__verified verified">(' . esc_attr__('verified owner', 'woocommerce') . ')</em>';
    }

    // Correct way to capture and display comment text
    ob_start(); // Start output buffering
    comment_text(); // Echoes comment text
    $comment_text = ob_get_clean(); // Get the buffer and clear it

    echo '<div class="description">' . $comment_text . '</div></div>'; // Display the comment text
    echo '</div>';
    echo '</div>';
    echo '</li>';
}

// Price
add_action( 'woocommerce_single_product_summary', 'custom_rearrange_product_summary_hooks', 1 );

function custom_rearrange_product_summary_hooks() {
    // Remove the price and rating from their original positions
    remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
    remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );

    // Add the price above the rating
    add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 9 );
    add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );
}



// To display number of people viewing product
function display_online_users_and_stock_quantity() {
    global $product;
    
    // Check if it's a product page
    if (is_product()) {
        // Get the product ID
        $product_id = $product->get_id();
        // Display online users count
        $current_visitor_id = session_id(); // You may use IP address instead of session ID
        $viewed_products = get_transient('product_views');

        if (!is_array($viewed_products)) {
            $viewed_products = array();
        }

        if (!isset($viewed_products[$product_id]) || !in_array($current_visitor_id, $viewed_products[$product_id])) {
            $viewed_products[$product_id][] = $current_visitor_id;
            set_transient('product_views', $viewed_products, 60 * 60 * 24); // Set transient for 24 hours
        }

        $count = isset($viewed_products[$product_id]) ? count($viewed_products[$product_id]) : 0;
        echo '<div class="product-info">';
        echo '<p class="product-view">' . sprintf(__('<svg width="16" height="9.773" viewBox="0 0 16 9.773">
                  <g id="view_1_" data-name="view (1)" transform="translate(-36.161 -123.772)">
                    <path id="Path_2727" data-name="Path 2727" d="M-306.273-21.419l.073.039a11.461,11.461,0,0,1,2.336,1.688c.078.071.157.141.238.21.175.153.339.316.5.481l.089.089a11.238,11.238,0,0,1,1.125,1.321l.051.07a.181.181,0,0,1,0,.156,8.332,8.332,0,0,1-1.533,1.8l-.077.077c-.166.165-.337.321-.514.473l-.111.1a9,9,0,0,1-6.4,2.45,9.341,9.341,0,0,1-5.32-2.673c-.078-.071-.158-.141-.238-.21-.175-.153-.339-.316-.5-.481l-.089-.089a11.243,11.243,0,0,1-1.125-1.321l-.051-.07a.181.181,0,0,1,0-.156,8.331,8.331,0,0,1,1.533-1.8l.077-.077c.166-.165.337-.321.514-.473l.111-.1A8.285,8.285,0,0,1-306.273-21.419Zm-8.078,2.074-.112.088c-.214.172-.418.354-.619.541-.1.091-.2.18-.3.269a7.754,7.754,0,0,0-.719.739l-.064.075-.154.18a1.158,1.158,0,0,0,.25.346l.056.06a11.107,11.107,0,0,0,1.238,1.2c.088.069.173.141.257.215a10.117,10.117,0,0,0,1.582,1.095l.077.045a5.837,5.837,0,0,0,4.425.666,8.756,8.756,0,0,0,3.1-1.657l.112-.088c.214-.172.418-.354.619-.541.1-.091.2-.18.3-.269a7.759,7.759,0,0,0,.719-.739l.064-.075.154-.18a1.159,1.159,0,0,0-.25-.346l-.056-.06a11.106,11.106,0,0,0-1.238-1.2c-.088-.069-.173-.141-.257-.215a10.12,10.12,0,0,0-1.582-1.095l-.077-.044C-309.4-21.81-312.128-21.13-314.352-19.345Z" transform="translate(354 146)" fill="#b05d5d"/>
                    <path id="Path_2728" data-name="Path 2728" d="M-70.786-.246l-.084.082a1.659,1.659,0,0,0-.536,1.2,1.561,1.561,0,0,0,.355.987.388.388,0,0,1,.083.169.98.98,0,0,0,.146.073l.152.107a1.583,1.583,0,0,0,1.219.213,2.818,2.818,0,0,0,.812-.357,2.409,2.409,0,0,1-.732,1.685,2.308,2.308,0,0,1-.505.353l-.094.052a2.586,2.586,0,0,1-1.955.093,2.433,2.433,0,0,1-1.316-1.237A2.554,2.554,0,0,1-73.3,1.246a2.358,2.358,0,0,1,1.217-1.3q.1-.042.2-.082l.09-.035A2.871,2.871,0,0,1-70.786-.246Z" transform="translate(115.201 126.501)" fill="#b05d5d"/>
                  </g>
                </svg>
                 %d PEOPLE ARE VIEWING THIS RIGHT NOW', 'luxury-furniture-store-pro'), $count) . '</p>';
        echo '</div>'; // Close product-info div
        
        // Get the stock quantity
        $stock_quantity = $product->get_stock_quantity();
        
        // Display the stock quantity
        if ($stock_quantity !== null) {
            echo '<div class="product-info">';
            echo '<p class="product-info-quant">' . sprintf(__('<svg width="19" height="18.972" viewBox="0 0 19 18.972">
                  <g id="ready-stock" transform="translate(-41.476 -31.765)">
                    <path id="Path_2731" data-name="Path 2731" d="M-207.442-3.383l.106.047.341.156.243.109.627.284.572.258.219.1.109.049.329.149q.842.38,1.688.748.914.4,1.823.812c.38.172.76.343,1.144.507l.094.04.434.184.152.065.131.055a.781.781,0,0,1,.385.326c0,.068.006.136.007.2,0,.043,0,.086,0,.13,0,.071,0,.071,0,.143,0,.05,0,.1,0,.151q0,.248,0,.5c0,.056,0,.113,0,.171q0,.355,0,.71,0,.509,0,1.017,0,.4,0,.8,0,.17,0,.341c0,.159,0,.318,0,.477,0,.047,0,.094,0,.142,0,.356,0,.356-.135.52a.481.481,0,0,1-.381.156.63.63,0,0,1-.354-.14,1.054,1.054,0,0,1-.148-.666c0-.039,0-.079,0-.119,0-.13,0-.259,0-.388q0-.135,0-.27,0-.355,0-.71t0-.725q0-.71.007-1.421l-.071.032L-202.4,2.58l-.247.11-.616.274-1.38.614-.624.277-.246.109-.122.054q-.379.168-.756.34l-.5.226-.235.107-.325.147-.094.044a1.166,1.166,0,0,1-.818.071c-.1-.039-.193-.082-.289-.128l-.108-.05-.23-.108c-.165-.078-.33-.155-.5-.231l-.258-.12c-.392-.183-.788-.357-1.185-.53q-1.009-.439-2.011-.893t-2-.885l-.111-.048-.2-.088c-.259-.113-.517-.231-.775-.348v9.264c1.242.557,1.242.557,2.486,1.106q1.009.44,2.011.894.981.443,1.968.873l.107.047.209.091c.178.077.355.157.53.24l.109.051.2.1a.641.641,0,0,0,.53.059l.089-.044a.677.677,0,0,1,.579.105.631.631,0,0,1,.144.467.508.508,0,0,1-.236.358,1.453,1.453,0,0,1-.931.266,2.386,2.386,0,0,1-.359-.146l-.1-.047-.219-.1c-.157-.074-.315-.146-.473-.219l-.248-.114c-.387-.178-.777-.35-1.167-.52q-1.012-.441-2.018-.9-.792-.358-1.589-.706l-.676-.3-.547-.239-.518-.228-.191-.083-.261-.115-.148-.065a.741.741,0,0,1-.3-.345,2.388,2.388,0,0,1-.022-.436c0-.066,0-.066,0-.132,0-.146,0-.293,0-.439q0-.157,0-.315,0-.427,0-.855,0-.4,0-.8,0-.8,0-1.592,0-.772,0-1.544,0-.841,0-1.682,0-.09,0-.179c0-.029,0-.059,0-.089q0-.311,0-.622,0-.418,0-.837,0-.154,0-.307,0-.209,0-.419V.9a.73.73,0,0,1,.151-.529A2.728,2.728,0,0,1-216.28.03l.106-.046.228-.1.616-.268.128-.056c.423-.185.844-.374,1.264-.564q.9-.4,1.8-.8.862-.377,1.721-.763l.336-.151c.3-.135.6-.271.9-.41l.252-.117.3-.139.131-.06.111-.052A1.3,1.3,0,0,1-207.442-3.383Zm-.808.943-.1.046-.111.051-.116.053-.246.112-.642.292-.128.058q-.473.215-.948.423l-.131.057-.255.112-.67.3-.144.064-.741.33c-1.965.875-1.965.875-2.783,1.227V.77l.253.111.226.1q.312.138.627.272a3.965,3.965,0,0,1,.975.485,1.007,1.007,0,0,0,.667.229,7.289,7.289,0,0,0,1.572-.676c.358-.179.723-.341,1.089-.5l.471-.213c.465-.211.933-.416,1.4-.617s.915-.4,1.37-.609c.247-.112.493-.224.742-.332l.115-.05.2-.087a.406.406,0,0,0,.262-.191c-1.169-.531-1.169-.531-2.344-1.047l-.111-.048A.5.5,0,0,0-208.25-2.441Zm3.826,1.866-.117.052-.387.173-.272.121-.566.252-1.156.514-.618.275-.249.111-.126.056-.389.173-.132.059-.264.117-.64.285q-.542.241-1.086.48l-.172.076-.307.134-.132.058-.113.049c-.091.039-.091.039-.128.133l.145.063.432.189.5.216c.389.17.776.341,1.158.525l.187.089c.087.041.174.083.261.126s.158.077.238.115l.133.065a.84.84,0,0,0,.541-.1l.1-.041c.1-.044.2-.089.307-.135l.116-.052.376-.169.267-.119.555-.248,1.15-.512.617-.274.905-.4.536-.238.252-.112q.847-.376,1.692-.757V.681c-1.316-.6-1.316-.6-2.64-1.183l-.086-.037A.8.8,0,0,0-204.424-.575Z" transform="translate(258.539 35.305)" fill="#b05d5d"/>
                    <path id="Path_2732" data-name="Path 2732" d="M-165.447-20.976a4.873,4.873,0,0,1,1.827,3.267,4.889,4.889,0,0,1-1.11,3.615l-.117.136-.087.1a4.763,4.763,0,0,1-2.4,1.318l-.13.033a4.786,4.786,0,0,1-3.46-.654c-.183-.127-.358-.26-.532-.4l-.105-.083a4.582,4.582,0,0,1-1.535-2.887,5.381,5.381,0,0,1,.133-1.95l.047-.155a4.964,4.964,0,0,1,.883-1.617l.087-.108A4.828,4.828,0,0,1-165.447-20.976Zm-5.118.725-.121.087a3.909,3.909,0,0,0-1.412,2.387,3.976,3.976,0,0,0,.738,2.884,3.959,3.959,0,0,0,2.7,1.468,3.856,3.856,0,0,0,2.827-.97,3.626,3.626,0,0,0,1.214-2.341,4.363,4.363,0,0,0-.185-1.7l-.049-.139a3.841,3.841,0,0,0-2.028-2.087A3.734,3.734,0,0,0-170.565-20.25Z" transform="translate(224.075 63.15)" fill="#b05d5d"/>
                    <path id="Path_2733" data-name="Path 2733" d="M-92.163-.348a.6.6,0,0,1,.266.266A.739.739,0,0,1-91.94.4a8.186,8.186,0,0,1-.716.779l-.143.144-.3.3L-93.481,2l-.3.3-.141.141-.2.2-.113.113A.754.754,0,0,1-94.819,3c-.355-.079-.653-.477-.9-.727l-.208-.206-.133-.133-.12-.12a.961.961,0,0,1-.255-.518.729.729,0,0,1,.2-.4.609.609,0,0,1,.466-.082,1.508,1.508,0,0,1,.554.437l.127.125q.16.158.317.318a1.08,1.08,0,0,0,.361-.263l.108-.109.116-.118.12-.121.443-.448L-93.2.192l.115-.118.108-.109.095-.1A.759.759,0,0,1-92.163-.348Z" transform="translate(149.973 44.888)" fill="#b05d5d"/>
                  </g>
                </svg>
                 ONLY %d ITEMS LEFT IN STOCK!', 'luxury-furniture-store-pro'), $stock_quantity) . '</p>';
        } else {
            echo '<div class="product-info">';
            echo '<p class="product-info-quant">' . __('<svg width="19" height="18.972" viewBox="0 0 19 18.972">
                  <g id="ready-stock" transform="translate(-41.476 -31.765)">
                    <path id="Path_2731" data-name="Path 2731" d="M-207.442-3.383l.106.047.341.156.243.109.627.284.572.258.219.1.109.049.329.149q.842.38,1.688.748.914.4,1.823.812c.38.172.76.343,1.144.507l.094.04.434.184.152.065.131.055a.781.781,0,0,1,.385.326c0,.068.006.136.007.2,0,.043,0,.086,0,.13,0,.071,0,.071,0,.143,0,.05,0,.1,0,.151q0,.248,0,.5c0,.056,0,.113,0,.171q0,.355,0,.71,0,.509,0,1.017,0,.4,0,.8,0,.17,0,.341c0,.159,0,.318,0,.477,0,.047,0,.094,0,.142,0,.356,0,.356-.135.52a.481.481,0,0,1-.381.156.63.63,0,0,1-.354-.14,1.054,1.054,0,0,1-.148-.666c0-.039,0-.079,0-.119,0-.13,0-.259,0-.388q0-.135,0-.27,0-.355,0-.71t0-.725q0-.71.007-1.421l-.071.032L-202.4,2.58l-.247.11-.616.274-1.38.614-.624.277-.246.109-.122.054q-.379.168-.756.34l-.5.226-.235.107-.325.147-.094.044a1.166,1.166,0,0,1-.818.071c-.1-.039-.193-.082-.289-.128l-.108-.05-.23-.108c-.165-.078-.33-.155-.5-.231l-.258-.12c-.392-.183-.788-.357-1.185-.53q-1.009-.439-2.011-.893t-2-.885l-.111-.048-.2-.088c-.259-.113-.517-.231-.775-.348v9.264c1.242.557,1.242.557,2.486,1.106q1.009.44,2.011.894.981.443,1.968.873l.107.047.209.091c.178.077.355.157.53.24l.109.051.2.1a.641.641,0,0,0,.53.059l.089-.044a.677.677,0,0,1,.579.105.631.631,0,0,1,.144.467.508.508,0,0,1-.236.358,1.453,1.453,0,0,1-.931.266,2.386,2.386,0,0,1-.359-.146l-.1-.047-.219-.1c-.157-.074-.315-.146-.473-.219l-.248-.114c-.387-.178-.777-.35-1.167-.52q-1.012-.441-2.018-.9-.792-.358-1.589-.706l-.676-.3-.547-.239-.518-.228-.191-.083-.261-.115-.148-.065a.741.741,0,0,1-.3-.345,2.388,2.388,0,0,1-.022-.436c0-.066,0-.066,0-.132,0-.146,0-.293,0-.439q0-.157,0-.315,0-.427,0-.855,0-.4,0-.8,0-.8,0-1.592,0-.772,0-1.544,0-.841,0-1.682,0-.09,0-.179c0-.029,0-.059,0-.089q0-.311,0-.622,0-.418,0-.837,0-.154,0-.307,0-.209,0-.419V.9a.73.73,0,0,1,.151-.529A2.728,2.728,0,0,1-216.28.03l.106-.046.228-.1.616-.268.128-.056c.423-.185.844-.374,1.264-.564q.9-.4,1.8-.8.862-.377,1.721-.763l.336-.151c.3-.135.6-.271.9-.41l.252-.117.3-.139.131-.06.111-.052A1.3,1.3,0,0,1-207.442-3.383Zm-.808.943-.1.046-.111.051-.116.053-.246.112-.642.292-.128.058q-.473.215-.948.423l-.131.057-.255.112-.67.3-.144.064-.741.33c-1.965.875-1.965.875-2.783,1.227V.77l.253.111.226.1q.312.138.627.272a3.965,3.965,0,0,1,.975.485,1.007,1.007,0,0,0,.667.229,7.289,7.289,0,0,0,1.572-.676c.358-.179.723-.341,1.089-.5l.471-.213c.465-.211.933-.416,1.4-.617s.915-.4,1.37-.609c.247-.112.493-.224.742-.332l.115-.05.2-.087a.406.406,0,0,0,.262-.191c-1.169-.531-1.169-.531-2.344-1.047l-.111-.048A.5.5,0,0,0-208.25-2.441Zm3.826,1.866-.117.052-.387.173-.272.121-.566.252-1.156.514-.618.275-.249.111-.126.056-.389.173-.132.059-.264.117-.64.285q-.542.241-1.086.48l-.172.076-.307.134-.132.058-.113.049c-.091.039-.091.039-.128.133l.145.063.432.189.5.216c.389.17.776.341,1.158.525l.187.089c.087.041.174.083.261.126s.158.077.238.115l.133.065a.84.84,0,0,0,.541-.1l.1-.041c.1-.044.2-.089.307-.135l.116-.052.376-.169.267-.119.555-.248,1.15-.512.617-.274.905-.4.536-.238.252-.112q.847-.376,1.692-.757V.681c-1.316-.6-1.316-.6-2.64-1.183l-.086-.037A.8.8,0,0,0-204.424-.575Z" transform="translate(258.539 35.305)" fill="#b05d5d"/>
                    <path id="Path_2732" data-name="Path 2732" d="M-165.447-20.976a4.873,4.873,0,0,1,1.827,3.267,4.889,4.889,0,0,1-1.11,3.615l-.117.136-.087.1a4.763,4.763,0,0,1-2.4,1.318l-.13.033a4.786,4.786,0,0,1-3.46-.654c-.183-.127-.358-.26-.532-.4l-.105-.083a4.582,4.582,0,0,1-1.535-2.887,5.381,5.381,0,0,1,.133-1.95l.047-.155a4.964,4.964,0,0,1,.883-1.617l.087-.108A4.828,4.828,0,0,1-165.447-20.976Zm-5.118.725-.121.087a3.909,3.909,0,0,0-1.412,2.387,3.976,3.976,0,0,0,.738,2.884,3.959,3.959,0,0,0,2.7,1.468,3.856,3.856,0,0,0,2.827-.97,3.626,3.626,0,0,0,1.214-2.341,4.363,4.363,0,0,0-.185-1.7l-.049-.139a3.841,3.841,0,0,0-2.028-2.087A3.734,3.734,0,0,0-170.565-20.25Z" transform="translate(224.075 63.15)" fill="#b05d5d"/>
                    <path id="Path_2733" data-name="Path 2733" d="M-92.163-.348a.6.6,0,0,1,.266.266A.739.739,0,0,1-91.94.4a8.186,8.186,0,0,1-.716.779l-.143.144-.3.3L-93.481,2l-.3.3-.141.141-.2.2-.113.113A.754.754,0,0,1-94.819,3c-.355-.079-.653-.477-.9-.727l-.208-.206-.133-.133-.12-.12a.961.961,0,0,1-.255-.518.729.729,0,0,1,.2-.4.609.609,0,0,1,.466-.082,1.508,1.508,0,0,1,.554.437l.127.125q.16.158.317.318a1.08,1.08,0,0,0,.361-.263l.108-.109.116-.118.12-.121.443-.448L-93.2.192l.115-.118.108-.109.095-.1A.759.759,0,0,1-92.163-.348Z" transform="translate(149.973 44.888)" fill="#b05d5d"/>
                  </g>
                </svg>
            Out of stock', 'luxury-furniture-store-pro') . '</p>';
        }
        echo '</div>'; // Close product-info div
    }
}

add_action('woocommerce_single_product_summary', 'display_online_users_and_stock_quantity', 20);



// Add custom product fields
function add_custom_product_fields() {
    global $post;
    
    echo '<div class="options_group">';

    // Maximum Rotational Speed
    woocommerce_wp_text_input( 
        array( 
            'id' => '_max_rotational_speed', 
            'label' => __('Maximum Rotational Speed', 'woocommerce'),
            'placeholder' => '1500 RPM',
            'desc_tip' => 'true',
            'description' => __('Enter the maximum rotational speed.', 'woocommerce') 
        )
    );

    // Amperage
    woocommerce_wp_text_input( 
        array( 
            'id' => '_amperage', 
            'label' => __('Amperage', 'woocommerce'), 
            'placeholder' => '10A',
            'desc_tip' => 'true',
            'description' => __('Enter the amperage.', 'woocommerce') 
        )
    );

    // Item size 
    woocommerce_wp_text_input( 
        array( 
            'id' => '_max_chuck_size', 
            'label' => __('Item size', 'woocommerce'), 
            'placeholder' => '13mm',
            'desc_tip' => 'true',
            'description' => __('Enter the Item size.', 'woocommerce') 
        )
    );

    // Power Source
    woocommerce_wp_text_input( 
        array( 
            'id' => '_power_source', 
            'label' => __('Power Source', 'woocommerce'), 
            'placeholder' => 'Battery',
            'desc_tip' => 'true',
            'description' => __('Enter the power source.', 'woocommerce') 
        )
    );

    echo '</div>';
}
add_action('woocommerce_product_options_general_product_data', 'add_custom_product_fields');

// Save custom fields
function save_custom_product_fields($post_id) {
    $product = wc_get_product($post_id);

    // Maximum Rotational Speed
    $max_rotational_speed = isset($_POST['_max_rotational_speed']) ? sanitize_text_field($_POST['_max_rotational_speed']) : '';
    $product->update_meta_data('_max_rotational_speed', $max_rotational_speed);

    // Amperage
    $amperage = isset($_POST['_amperage']) ? sanitize_text_field($_POST['_amperage']) : '';
    $product->update_meta_data('_amperage', $amperage);

    // Item size 
    $max_chuck_size = isset($_POST['_max_chuck_size']) ? sanitize_text_field($_POST['_max_chuck_size']) : '';
    $product->update_meta_data('_max_chuck_size', $max_chuck_size);

    // Power Source
    $power_source = isset($_POST['_power_source']) ? sanitize_text_field($_POST['_power_source']) : '';
    $product->update_meta_data('_power_source', $power_source);

    $product->save();
}
add_action('woocommerce_process_product_meta', 'save_custom_product_fields');


// Display custom fields on the product page
function display_custom_product_fields() {
    global $post;
    
    // Get custom fields
    $max_rotational_speed = get_post_meta($post->ID, '_max_rotational_speed', true);
    $amperage = get_post_meta($post->ID, '_amperage', true);
    $max_chuck_size = get_post_meta($post->ID, '_max_chuck_size', true);
    $power_source = get_post_meta($post->ID, '_power_source', true);

    // Display custom fields
    if ($max_rotational_speed || $amperage || $max_chuck_size || $power_source) {
        echo '<div class="product_custom_fields">';
       
        echo '<ul>';
        if ($max_rotational_speed) {
            echo '<li><strong>Maximum Rotational Speed:</strong> ' . esc_html($max_rotational_speed) . '</li>';
        }
        if ($amperage) {
            echo '<li><strong>Amperage:</strong> ' . esc_html($amperage) . '</li>';
        }
        if ($max_chuck_size) {
            echo '<li><strong>Item size :</strong> ' . esc_html($max_chuck_size) . '</li>';
        }
        if ($power_source) {
            echo '<li><strong>Power Source:</strong> ' . esc_html($power_source) . '</li>';
        }
        echo '</ul>';
        echo '</div>';
    }
}
add_action('woocommerce_single_product_summary', 'display_custom_product_fields', 25);


// Remove SKU display from single product page

remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40);
// Add custom function to display SKU below short description
function display_sku_below_short_description() {
    global $product;

    // Check if it's a product page
    if (is_product()) {
        // Get the SKU
        $sku = $product->get_sku();

        // Display the SKU
        if ($sku) {
            echo '<div class="product-info">';
            echo '<p class="product-sku">' . __('SKU:', 'your-text-domain') . ' ' . $sku . '</p>';
            echo '</div>'; // Close product-info div
        }
    }
}
add_action('woocommerce_single_product_summary', 'display_sku_below_short_description', 25);

// single php 
// color option

// Enqueue the necessary CSS to style the swatches
function enqueue_custom_styles_scripts() {
    wp_add_inline_style( 'woocommerce-general', '
        .color-swatch {
            display: inline-block;
            width: 37px;
            height: 32px;
            border-radius: 0%;
            margin: 2px 6px 0px 0;
            cursor: pointer;
            border: 1px solid #ccc;
        }
    ' );
}
add_action( 'wp_enqueue_scripts', 'enqueue_custom_styles_scripts' );

// Output the color swatches on the product page
function display_color_swatches_on_product_page() {
    global $product;
    
    if ( $product->is_type( 'variable' ) ) {
        $attributes = $product->get_variation_attributes();
        $colors = $attributes['pa_color'] ?? [];

        if ( ! empty( $colors ) ) {
            echo '<div class="custom-color-swatches">';
            echo '<p><b>Color : </b>';echo '</p>';
            foreach ( $colors as $color ) {
                // Adjust the color name to match the colors you have
                $color_name = ucwords(str_replace('-', ' ', $color));
                $color_style = 'background-color:' . $color . ';'; // Here you might need to adjust how to get the color code
                
                // Output a colored circle for each color option
                echo '<span class="color-swatch" style="' . esc_attr( $color_style ) . '" data-attribute-name="attribute_pa_color" data-value="' . esc_attr( $color ) . '" title="' . esc_attr( $color_name ) . '"></span>';
            }
            
            echo '</div>';
        }
    }
}
add_action( 'woocommerce_single_product_summary', 'display_color_swatches_on_product_page', 25 );

// JavaScript code to handle color swatch selection
add_action('wp_footer', 'color_swatch_script');
function color_swatch_script() {
    ?>
    <script type="text/javascript">
    jQuery(document).ready(function($) {
        $('.custom-color-swatches').on('click', '.color-swatch', function() {
            // Remove active class from all color swatches
            $('.color-swatch').removeClass('active');

            // Add active class to the clicked color swatch
            $(this).addClass('active');

            var attribute_name = $(this).data('attribute-name');
            var value = $(this).data('value');

            $('select[name="' + attribute_name + '"]').val(value).change();
        });
    });
    </script>
    <?php
}

// // Display Fields
// add_action('woocommerce_product_options_general_product_data', 'woocommerce_product_custom_fields');
// // Save Fields
// add_action('woocommerce_process_product_meta', 'woocommerce_product_custom_fields_save');
// function woocommerce_product_custom_fields()
// {
//     global $woocommerce, $post;
//     echo '<div class="product_custom_field">';
//      //Custom Product  Text
//     woocommerce_wp_text_input(
//         array(
//             'id' => '_custom_product_saletgtxt_field',
//             'placeholder' => 'Sale/New',
//             'label' => __('Product Sale/New', 'woocommerce')
//         )
//     );
 
//     echo '</div>';
// }

// function woocommerce_product_custom_fields_save($post_id)
// {
//     $woocommerce_custom_procut_text = $_POST['_custom_product_discount_field'];
//   if( isset($woocommerce_custom_procut_text) )
//         update_post_meta($post_id, '_custom_product_discount_field', esc_html($woocommerce_custom_procut_text));


//      $woocommerce_custom_procut_text = $_POST['_custom_product_saletgtxt_field'];
//    if( isset($woocommerce_custom_procut_text) )
//         update_post_meta($post_id, '_custom_product_saletgtxt_field', esc_html($woocommerce_custom_procut_text));
// }


// Display Fields
add_action('woocommerce_product_options_general_product_data', 'woocommerce_product_custom_fields');
// Save Fields
add_action('woocommerce_process_product_meta', 'woocommerce_product_custom_fields_save');

function woocommerce_product_custom_fields() {
    global $woocommerce, $post;

    echo '<div class="product_custom_field">';

    // Custom Product Sale Text
    woocommerce_wp_text_input(
        array(
            'id' => '_custom_product_sale_field',
            'placeholder' => 'Sale',
            'label' => __('Product Sale', 'woocommerce')
        )
    );

    // Custom Product New Text
    woocommerce_wp_text_input(
        array(
            'id' => '_custom_product_new_field',
            'placeholder' => 'New',
            'label' => __('Product New', 'woocommerce')
        )
    );

    echo '</div>';
}

function woocommerce_product_custom_fields_save($post_id) {
    // Save Sale Text
    $woocommerce_custom_product_sale_text = $_POST['_custom_product_sale_field'];
    if (isset($woocommerce_custom_product_sale_text)) {
        update_post_meta($post_id, '_custom_product_sale_field', esc_html($woocommerce_custom_product_sale_text));
    }

    // Save New Text
    $woocommerce_custom_product_new_text = $_POST['_custom_product_new_field'];
    if (isset($woocommerce_custom_product_new_text)) {
        update_post_meta($post_id, '_custom_product_new_field', esc_html($woocommerce_custom_product_new_text));
    }
}

// single product

//  Star Review
// Add data-rating attribute to the star rating container
add_filter('woocommerce_product_get_rating_html', 'custom_woocommerce_product_get_rating_html', 10, 3);

function custom_woocommerce_product_get_rating_html($rating_html, $rating, $count) {
    $full_stars = floor($rating); // Full stars
    $half_star = ($rating - $full_stars) >= 0.5 ? 1 : 0; // Check for half star
    $empty_stars = 5 - $full_stars - $half_star; // Empty stars

    $rating_html = '<div class="star-rating" data-rating="' . esc_attr($rating) . '">';
    $rating_html .= '<span class="full-stars" style="width:' . ( ($full_stars + $half_star * 0.5) / 5 * 100 ) . '%"></span>';
    $rating_html .= '<span class="empty-stars"></span>';
    $rating_html .= '</div>';
    
    return $rating_html;
}

// 2nd Customer Review star

// // Add data-rating attribute to the star rating container for reviews
// add_filter('woocommerce_product_review_rating_html', 'custom_woocommerce_product_review_rating_html', 10, 3);

// function custom_woocommerce_product_review_rating_html($rating_html, $rating, $count) {
//     if ($rating > 0) {
//         $rating_html = '<div class="star-rating" data-rating="' . esc_attr($rating) . '">';
//         $rating_html .= '<span class="full-stars"></span>';
//         $rating_html .= '<span class="empty-stars"></span>';
//         $rating_html .= '</div>';
//     }
//     return $rating_html;
// }


add_action('admin_menu', 'luzuk_lite_reorder_appearance_menu', 999);

function luzuk_lite_reorder_appearance_menu() {
    global $submenu;

    if (isset($submenu['themes.php'])) {
        $themes_submenu = $submenu['themes.php'];

        // Find and extract the Themes Dashboard item
        foreach ($themes_submenu as $key => $item) {
            if ($item[2] === 'themes-dashboard') {
                $dashboard_item = $item;
                unset($themes_submenu[$key]);
                break;
            }
        }

        // Re-index and add Themes Dashboard at the top
        if (isset($dashboard_item)) {
            $themes_submenu = array_values($themes_submenu); // reindex
            array_unshift($themes_submenu, $dashboard_item);
            $submenu['themes.php'] = $themes_submenu;
        }
    }
}

// Hook into current_screen to detect if we're on our custom page
add_action('current_screen', 'luzuk_lite_hide_admin_notices_on_custom_page');

function luzuk_lite_hide_admin_notices_on_custom_page($screen) {
    // Check for our custom page slug
    if ($screen->id === 'appearance_page_themes-dashboard') {
        // Remove all actions that show admin notices
        remove_all_actions('admin_notices');
        remove_all_actions('all_admin_notices');
        remove_all_actions('network_admin_notices');
    }
}

add_action('admin_menu', 'luzuk_lite_add_themes_dashboard_menu');

function luzuk_lite_add_themes_dashboard_menu() {
    add_theme_page(
        'Themes Dashboard',
        'Themes Dashboard',
        'manage_options',
        'themes-dashboard',
        'luzuk_lite_themes_dashboard_page'
    );
}

function luzuk_lite_themes_dashboard_page() {
    // Handle force ping request
    if ( isset( $_GET['force_tracker_ping'] ) && check_admin_referer( 'force_tracker_ping' ) ) {
        if ( function_exists( 'luzuk_lite_force_tracker_ping' ) ) {
            $result = luzuk_lite_force_tracker_ping();
            if ( $result['success'] ) {
                echo '<div class="notice notice-success is-dismissible"><p>' . esc_html( $result['message'] ) . '</p></div>';
            } else {
                echo '<div class="notice notice-error is-dismissible"><p>' . esc_html( $result['message'] ) . '</p></div>';
            }
        }
    }

    echo luzuk_lite_render_combined_dashboard();
}

function luzuk_lite_render_combined_dashboard() {
    $theme = wp_get_theme();
    $theme_name = $theme->get('Name');
    $screenshot = $theme->get_screenshot();
	$theme_description = $theme->get('Description');
    $theme_version = $theme->get('Version');

    $customize_url = admin_url('customize.php');

	// Dashboard file
	$dashboard_url = 'https://raw.githubusercontent.com/LuzukThemes/themes-dashboard/main/dashboard.html';
	$dashboard_response = wp_remote_get($dashboard_url);
	$dashboard_html = '';

	if (!is_wp_error($dashboard_response)) {
		$dashboard_html = wp_remote_retrieve_body($dashboard_response);
	} else {
		$dashboard_html = '<div class="notice notice-error"><p>Unable to load Dashboard content from GitHub.</p></div>';
	}

    ob_start(); ?>
    <div class="wrap">
        <h1>Themes Dashboard</h1>
        <div style="display: flex; gap: 30px; margin-top: 30px;">

            <!-- Left Column -->
            <div style="flex: 1; background: #fff; padding: 20px; border: 1px solid #ddd; border-radius: 8px;">
				<h2 style="margin: 0 0 30px;background: #000;color: #fff;padding: 22px;text-align: center;border-radius: 6px;">Use this coupon code and get 15% discount instantly <span style="background: #ff0000; color: #fff; padding: 5px 10px; border-radius: 5px;margin-left: 10px;">LUZUKDISCOUNT</span></h2>
                <img src="<?php echo esc_url($screenshot); ?>" alt="Theme Screenshot" style="max-width: 50%; border: 1px solid #ccc; float: left; margin-right: 20px; border-radius: 8px; border-right-color: #ff0000; border-bottom-color: #ff0000;" />
				<div style="background: #fff; padding: 20px; border: 1px solid #ddd; border-radius: 8px;">
					<h2 style="margin: 20px 0 30px;"><?php echo esc_html($theme_name); ?></h2>
					<p><strong>Version:</strong> <?php echo esc_html($theme_version); ?></p>
					<p><?php echo esc_html($theme_description); ?></p>
				</div>
                <div style="margin: 15px 0 50px;">
                    <a href="https://www.luzukdemo.com/demo/retail-hardware-store/" target="_blank" class="button" style="background: #000; color: #fff; margin-right: 10px; padding: 6px 24px; font-size: 16px; font-weight: bold">Live Demo</a>
					<a href="https://www.luzukdemo.com/docs/retail-hardware-store/" target="_blank" class="button" style="background: #000; color: #fff; margin-right: 10px; padding: 6px 24px; font-size: 16px; font-weight: bold">Pro Documentation</a>
					<a href="https://www.luzuk.com/products/hardware-shop-wordpress-theme/" target="_blank" class="button" style="background: #0056ff; color: #fff; margin-right: 10px; padding: 6px 24px; font-size: 16px; font-weight: bold">Buy Premium</a>
                </div>

                <?php echo $dashboard_html; ?>

		</div>
          
		<div style="display: flex; gap: 30px; margin-top: 30px; text-align: center;">
			<div style="flex: 2; margin: 20px 0; padding: 20px; background: #f7f7f7; border: 1px dashed #aaa;">
                <div class="coupon-ticket">
                    <div class="coupon-title">Get 15% OFF</div>
                    <div>Use Code Below:</div>
                    <div class="coupon-code" onclick="copyCoupon(this)">LUZUKDISCOUNT</div>
                </div>
                <script>
                    function copyCoupon(el) {
                        const coupon = el.textContent;
                        navigator.clipboard.writeText(coupon).then(() => {
                        el.classList.add("copied");
                        setTimeout(() => {
                            el.classList.remove("copied");
                        }, 2000);
                        });
                    }
                </script>
                  <style>
      
                .coupon-ticket {
                width: 320px;
                margin: 40px auto;
                padding: 20px;
                border: 2px dashed #ff4d4d;
                border-radius: 10px;
                background-color: #fff4f4;
                font-family: Arial, sans-serif;
                text-align: center;
                position: relative;
                }

                .coupon-ticket::before,
                .coupon-ticket::after {
                content: "";
                position: absolute;
                top: 50%;
                width: 20px;
                height: 20px;
                background-color: #fff4f4;
                border: 2px dashed #ff4d4d;
                border-radius: 50%;
                transform: translateY(-50%);
                }

                .coupon-ticket::before {
                left: -12px;
                }

                .coupon-ticket::after {
                right: -12px;
                }

                .coupon-title {
                font-size: 20px;
                color: #d80000;
                font-weight: bold;
                margin-bottom: 10px;
                }

                .coupon-code {
                display: inline-block;
                background-color: #d80000;
                color: #fff;
                padding: 8px 16px;
                font-size: 16px;
                border-radius: 4px;
                margin-top: 5px;
                letter-spacing: 1px;
                cursor: pointer;
                }
                .coupon-code::after {
                content: "Click to copy";
                position: absolute;
                top: -30px;
                left: 50%;
                transform: translateX(-50%);
                background: #333;
                color: #fff;
                padding: 5px 8px;
                border-radius: 4px;
                font-size: 12px;
                white-space: nowrap;
                opacity: 0;
                pointer-events: none;
                transition: opacity 0.3s ease;
            }

            .coupon-code:hover::after {
                opacity: 1;
            }

            .coupon-code.copied::after {
                content: "Copied!";
                background: #4caf50;
            }
            </style>
				<a href="https://www.luzuk.com/products/hardware-shop-wordpress-theme/" target="_blank" class="button button-primary" style="display: block; padding: 10px; background: #77b255;font-weight: bold; margin-top: 10px;">UPGRADE NOW</a><br>
			</div>
			<div style="flex: 2; margin: 20px 0; padding: 20px;"></div>
		</div>
		
    <?php
    return ob_get_clean();
}

/**
 * Show notice on frontend pages that contain shortcodes.
 * Free theme: inform user that shortcodes require premium.
 */
function luzuk_lite_shortcode_premium_notice( $content ) {
    if ( is_admin() ) {
        return $content;
    }
 
    if ( ! is_singular( 'page' ) || ! in_the_loop() || ! is_main_query() ) {
        return $content;
    }
 
    global $post;
    if ( ! $post instanceof WP_Post ) {
        return $content;
    }
 
    // Simple detection: if the original content contains shortcode syntax
    if ( strpos( $post->post_content, '[' ) === false || strpos( $post->post_content, ']' ) === false ) {
        return $content;
    }
 
    $notice  = '<div class="luzuk-shortcode-premium-notice" style="margin:20px 0;padding:12px 15px;border:1px solid #e1a200;background:#fff8e5;color:#333;font-size:14px;border-radius:4px;">';
    $notice .= esc_html__( 'Shortcodes are available only in the premium version of this theme. To use shortcode features, please purchase the premium theme.', 'Luzuk Premium' );
    $notice .= '</div>';
 
    // Add big upgrade button under the notice text
    $notice .= '<a href="https://www.luzuk.com/products/hardware-shop-wordpress-theme/" target="_blank" class="button button-primary" style="    color: #fff;display:block;padding:10px;background:#77b255;font-weight:bold;margin:10px 0 0 0;text-align:center;">UPGRADE NOW</a>';
 
    return $notice . $content;
}
add_filter( 'the_content', 'luzuk_lite_shortcode_premium_notice', 5 );