<?php
$wp_customize->add_section(
    'banner2_section',
    array(
        'title' => __( 'Banner Section', 'Luzuk' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);

$wp_customize->add_setting(
    'banner2_section_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'banner2_section_disable',
        array(
            'settings'      => 'banner2_section_disable',
            'section'       => 'banner2_section',
            'label'         => __( 'Disable/ Enable Section', 'Luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'Luzuk' ),
                'off' => __( 'No', 'Luzuk' )
            ),
        )
    )
);

BackgroundManager($wp_customize, 'banner2', 'banner2_section', $color='#fff', get_template_directory_uri().'/images/default-graybg.png', 'img');


lzCustomLable($wp_customize, 'sec_banner2padding', 'banner2_section', 'Section Padding');

$wp_customize->add_setting(
    'banner2_Tpadding', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'banner2_Tpadding',
    array(
        'settings'      => 'banner2_Tpadding',
        'section'       => 'banner2_section',
        'type'          => 'text',
        'label'         => __( 'Top', 'Luzuk' )
    )
);
$wp_customize->add_setting(
    'banner2_Bpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1em', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'banner2_Bpadding',
    array(
        'settings'      => 'banner2_Bpadding',
        'section'       => 'banner2_section',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'Luzuk' )
    )
);

lzCustomLable($wp_customize, 'sec_banner2innebx', 'banner2_section', 'Inner Box Image Setting');

BackgroundManager($wp_customize, 'banner2innbox', 'banner2_section', $color='#fff', get_template_directory_uri().'/images/bannerbg.jpg', 'color'); 

lzCustomLable($wp_customize, 'banner2_overlay', 'banner2_section', 'Section Overlay');

$wp_customize->add_setting(
    'banner2_Opacity',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.4', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'banner2_Opacity',
    array(
        'settings'      => 'banner2_Opacity',
        'section'       => 'banner2_section',
        'type'          => 'text',
        'label'         => __( 'Opacity', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'banner2_overclr', 'banner2_section', 'Overlay Color', '#202447'); 

lzCustomLable($wp_customize, 'banner2_shape', 'banner2_section', 'Section Shape ');

$wp_customize->add_setting( 'bann2svg_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'bann2svg_display', array( 'label' => 'Shape Display', 'section' => 'banner2_section', 'settings' => 'bann2svg_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show ', 'hide' => 'Hide ', ), ) ); 


addColorPalatOption($wp_customize, 'banner2_shap1', 'banner2_section', 'Shape 1 Color', '#1e2244'); 

addColorPalatOption($wp_customize, 'banner2_shap2a', 'banner2_section', 'Shape 2 Color 1', '#202447'); 

addColorPalatOption($wp_customize, 'banner2_shap2b', 'banner2_section', 'Shape 2 Color 2', '#2a3c6b');

$wp_customize->add_setting(
    'banner2_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'banner2_title_heading',
        array(
            'settings'      => 'banner2_title_heading',
            'section'       => 'banner2_section',
            'label'         => __( 'Section Title ', 'Luzuk' ),
        )
    )
);  


$wp_customize->add_setting(
    'banner2_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'SALE', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'banner2_title',
    array(
        'settings'      => 'banner2_title',
        'section'       => 'banner2_section',
        'type'          => 'text',
        'label'         => __( 'Section Title ', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'banner2_headclr', 'banner2_section', 'Heading Color', '#fff'); 

addColorPalatOption($wp_customize, 'banner2_headtxtbrdclr', 'banner2_section', 'Heading Text Border Color', '#FAB915'); 


$wp_customize->add_setting(
    'banner2_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'ONLY THIS WEEK', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'banner2_text',
    array(
        'settings'      => 'banner2_text',
        'section'       => 'banner2_section',
        'type'          => 'text',
        'label'         => __( 'Section Text ', 'Luzuk' )
    )
); 

addColorPalatOption($wp_customize, 'banner2_textclr', 'banner2_section', 'Text Color', '#fff'); 

lzCustomLable($wp_customize, 'banner2_btn', 'banner2_section', 'Section Button ');

$wp_customize->add_setting(
    'b2btn_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Shop Now', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'b2btn_text',
    array(
        'settings'      => 'b2btn_text',
        'section'       => 'banner2_section',
        'type'          => 'text',
        'label'         => __( 'Button Text ', 'Luzuk' )
    )
);

$wp_customize->add_setting('banner2_btnlink',   
    array('default'=> 'Add Link', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('banner2_btnlink',
    array(
        'settings'      => 'banner2_btnlink',
        'section'       => 'banner2_section',
        'type'          => 'url',
        'label'         => __( 'Button Link ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'banner2_btntxtclr', 'banner2_section', 'Button Text Color', '#202447'); 

addColorPalatOption($wp_customize, 'banner2_btntxthvclr', 'banner2_section', 'Button Text Hover Color', '#fff'); 

addColorPalatOption($wp_customize, 'banner2_btnbgclr', 'banner2_section', 'Button BG Color', '#FAB915'); 

addColorPalatOption($wp_customize, 'banner2_btnbghvclr', 'banner2_section', 'Button BG Hover Color', '#000'); 

// social media

lzCustomLable($wp_customize, 'bannsmedia', 'banner2_section', 'Social Media');

// FACEBOOK 
$wp_customize->add_setting('bann_fb', array('default'=> 'https://facebook.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('bann_fb',
    array(
        'settings'      => 'bann_fb',
        'section'       => 'banner2_section',
        'type'          => 'url',
        'label'         => __( 'Facebook Url', 'luzuk-premium' )
    )
);


// Instagram
$wp_customize->add_setting('bann_insta',array('default'=> 'https://instagram.com/','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('bann_insta',
    array(
        'settings'      => 'bann_insta',
        'section'       => 'banner2_section',
        'type'          => 'url',
        'label'         => __( 'Instagram Url', 'luzuk-premium' )
    )
);

// Linkedin
$wp_customize->add_setting('bann_lin', array('default'=> 'https://linkedin.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('bann_lin',
    array(
        'settings'      => 'bann_lin',
        'section'       => 'banner2_section',
        'type'          => 'url',
        'label'         => __( 'Linkedin Url', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'banner2_sicn', 'banner2_section', 'Social Media Icon Color', '#202447'); 

addColorPalatOption($wp_customize, 'banner2_sicnbg', 'banner2_section', 'Social Media Icon BG Color', '#fff'); 

addColorPalatOption($wp_customize, 'banner2_sicnbghv', 'banner2_section', 'Social Media Icon BG Hover Color', '#FAB915'); 


lzCustomLable($wp_customize, 'banndis', 'banner2_section', 'Discount Text');

$wp_customize->add_setting(
    'distext',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'UP To ', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'distext',
    array(
        'settings'      => 'distext',
        'section'       => 'banner2_section',
        'type'          => 'text',
        'label'         => __( 'Discount Text ', 'Luzuk' )
    )
); 

addColorPalatOption($wp_customize, 'banner2_Distext', 'banner2_section', 'Discount Text Color', '#fff'); 

addColorPalatOption($wp_customize, 'banner2_Distextbg', 'banner2_section', 'Discount Text BG Color', '#202447'); 


$wp_customize->add_setting(
    'dishightext',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '25 % oFF', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'dishightext',
    array(
        'settings'      => 'dishightext',
        'section'       => 'banner2_section',
        'type'          => 'text',
        'label'         => __( 'Discount Highlight Text ', 'Luzuk' )
    )
); 

addColorPalatOption($wp_customize, 'banner2_Dishightext1', 'banner2_section', 'Discount Highlight Text Color 1', '#fff'); 

addColorPalatOption($wp_customize, 'banner2_Dishightext2', 'banner2_section', 'Discount Highlight Text Color 2', '#FAB915'); 